/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.EncryptionMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.BaseJWEProvider;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.ContentCryptoProvider;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.StandardCharset;

public abstract class PasswordBasedCryptoProvider
extends BaseJWEProvider {
    public static final Set<JWEAlgorithm> SUPPORTED_ALGORITHMS;
    public static final Set<EncryptionMethod> SUPPORTED_ENCRYPTION_METHODS;
    private final byte[] password;

    protected PasswordBasedCryptoProvider(byte[] byArray) {
        super(SUPPORTED_ALGORITHMS, ContentCryptoProvider.SUPPORTED_ENCRYPTION_METHODS);
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException("The password must not be null or empty");
        }
        this.password = byArray;
    }

    public byte[] getPassword() {
        return this.password;
    }

    public String getPasswordString() {
        return new String(this.password, StandardCharset.UTF_8);
    }

    static {
        SUPPORTED_ENCRYPTION_METHODS = ContentCryptoProvider.SUPPORTED_ENCRYPTION_METHODS;
        LinkedHashSet<JWEAlgorithm> linkedHashSet = new LinkedHashSet<JWEAlgorithm>();
        linkedHashSet.add(JWEAlgorithm.PBES2_HS256_A128KW);
        linkedHashSet.add(JWEAlgorithm.PBES2_HS384_A192KW);
        linkedHashSet.add(JWEAlgorithm.PBES2_HS512_A256KW);
        SUPPORTED_ALGORITHMS = Collections.unmodifiableSet(linkedHashSet);
    }
}

