/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl;

import javax.crypto.SecretKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.AuthenticatedCipherText;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.ThreadSafe;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;

@ThreadSafe
public class LegacyAESGCM {
    public static final int AUTH_TAG_BIT_LENGTH = 128;

    public static AESEngine createAESCipher(SecretKey secretKey, boolean bl2) {
        AESEngine aESEngine = new AESEngine();
        KeyParameter keyParameter = new KeyParameter(secretKey.getEncoded());
        aESEngine.init(bl2, (CipherParameters)keyParameter);
        return aESEngine;
    }

    private static GCMBlockCipher createAESGCMCipher(SecretKey secretKey, boolean bl2, byte[] byArray, byte[] byArray2) {
        AESEngine aESEngine = LegacyAESGCM.createAESCipher(secretKey, bl2);
        GCMBlockCipher gCMBlockCipher = new GCMBlockCipher((BlockCipher)aESEngine);
        AEADParameters aEADParameters = new AEADParameters(new KeyParameter(secretKey.getEncoded()), 128, byArray, byArray2);
        gCMBlockCipher.init(bl2, (CipherParameters)aEADParameters);
        return gCMBlockCipher;
    }

    public static AuthenticatedCipherText encrypt(SecretKey secretKey, byte[] byArray, byte[] byArray2, byte[] byArray3) throws JOSEException {
        GCMBlockCipher gCMBlockCipher = LegacyAESGCM.createAESGCMCipher(secretKey, true, byArray, byArray3);
        int n2 = gCMBlockCipher.getOutputSize(byArray2.length);
        byte[] byArray4 = new byte[n2];
        int n3 = gCMBlockCipher.processBytes(byArray2, 0, byArray2.length, byArray4, 0);
        try {
            n3 += gCMBlockCipher.doFinal(byArray4, n3);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new JOSEException("Couldn't generate GCM authentication tag: " + invalidCipherTextException.getMessage(), invalidCipherTextException);
        }
        int n4 = 16;
        byte[] byArray5 = new byte[n3 - n4];
        byte[] byArray6 = new byte[n4];
        System.arraycopy(byArray4, 0, byArray5, 0, byArray5.length);
        System.arraycopy(byArray4, n3 - n4, byArray6, 0, byArray6.length);
        return new AuthenticatedCipherText(byArray5, byArray6);
    }

    public static byte[] decrypt(SecretKey secretKey, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) throws JOSEException {
        GCMBlockCipher gCMBlockCipher = LegacyAESGCM.createAESGCMCipher(secretKey, false, byArray, byArray3);
        byte[] byArray5 = new byte[byArray2.length + byArray4.length];
        System.arraycopy(byArray2, 0, byArray5, 0, byArray2.length);
        System.arraycopy(byArray4, 0, byArray5, byArray2.length, byArray4.length);
        int n2 = gCMBlockCipher.getOutputSize(byArray5.length);
        byte[] byArray6 = new byte[n2];
        int n3 = gCMBlockCipher.processBytes(byArray5, 0, byArray5.length, byArray6, 0);
        try {
            n3 += gCMBlockCipher.doFinal(byArray6, n3);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new JOSEException("Couldn't validate GCM authentication tag: " + invalidCipherTextException.getMessage(), invalidCipherTextException);
        }
        return byArray6;
    }

    private LegacyAESGCM() {
    }
}

