/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.BaseJWSProvider;

public abstract class ECDSAProvider
extends BaseJWSProvider {
    public static final Set<JWSAlgorithm> SUPPORTED_ALGORITHMS;

    protected ECDSAProvider(JWSAlgorithm jWSAlgorithm) throws JOSEException {
        super(Collections.singleton(jWSAlgorithm));
        if (!SUPPORTED_ALGORITHMS.contains(jWSAlgorithm)) {
            throw new JOSEException("Unsupported EC DSA algorithm: " + jWSAlgorithm);
        }
    }

    public JWSAlgorithm supportedECDSAAlgorithm() {
        return this.supportedJWSAlgorithms().iterator().next();
    }

    static {
        LinkedHashSet<JWSAlgorithm> linkedHashSet = new LinkedHashSet<JWSAlgorithm>();
        linkedHashSet.add(JWSAlgorithm.ES256);
        linkedHashSet.add(JWSAlgorithm.ES256K);
        linkedHashSet.add(JWSAlgorithm.ES384);
        linkedHashSet.add(JWSAlgorithm.ES512);
        SUPPORTED_ALGORITHMS = Collections.unmodifiableSet(linkedHashSet);
    }
}

