/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.AuthenticatedCipherText;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.LegacyAESGCM;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.ByteUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Container;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.KeyUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class AESGCM {
    public static final int IV_BIT_LENGTH = 96;
    public static final int AUTH_TAG_BIT_LENGTH = 128;

    public static byte[] generateIV(SecureRandom secureRandom) {
        byte[] byArray = new byte[12];
        secureRandom.nextBytes(byArray);
        return byArray;
    }

    public static AuthenticatedCipherText encrypt(SecretKey secretKey, Container<byte[]> container, byte[] byArray, byte[] byArray2, Provider provider) throws JOSEException {
        Object object;
        Cipher cipher;
        SecretKey secretKey2 = KeyUtils.toAESKey(secretKey);
        byte[] byArray3 = container.get();
        try {
            cipher = provider != null ? Cipher.getInstance("AES/GCM/NoPadding", provider) : Cipher.getInstance("AES/GCM/NoPadding");
            object = new GCMParameterSpec(128, byArray3);
            cipher.init(1, (Key)secretKey2, (AlgorithmParameterSpec)object);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException generalSecurityException) {
            throw new JOSEException("Couldn't create AES/GCM/NoPadding cipher: " + generalSecurityException.getMessage(), generalSecurityException);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return LegacyAESGCM.encrypt(secretKey2, byArray3, byArray, byArray2);
        }
        cipher.updateAAD(byArray2);
        try {
            object = cipher.doFinal(byArray);
        }
        catch (BadPaddingException | IllegalBlockSizeException generalSecurityException) {
            throw new JOSEException("Couldn't encrypt with AES/GCM/NoPadding: " + generalSecurityException.getMessage(), generalSecurityException);
        }
        int n2 = ((Object)object).length - ByteUtils.byteLength(128);
        byte[] byArray4 = ByteUtils.subArray((byte[])object, 0, n2);
        byte[] byArray5 = ByteUtils.subArray((byte[])object, n2, ByteUtils.byteLength(128));
        container.set(AESGCM.actualIVOf(cipher));
        return new AuthenticatedCipherText(byArray4, byArray5);
    }

    private static byte[] actualIVOf(Cipher cipher) throws JOSEException {
        GCMParameterSpec gCMParameterSpec = AESGCM.actualParamsOf(cipher);
        byte[] byArray = gCMParameterSpec.getIV();
        int n2 = gCMParameterSpec.getTLen();
        AESGCM.validate(byArray, n2);
        return byArray;
    }

    private static void validate(byte[] byArray, int n2) throws JOSEException {
        if (ByteUtils.safeBitLength(byArray) != 96) {
            throw new JOSEException(String.format("IV length of %d bits is required, got %d", 96, ByteUtils.safeBitLength(byArray)));
        }
        if (n2 != 128) {
            throw new JOSEException(String.format("Authentication tag length of %d bits is required, got %d", 128, n2));
        }
    }

    private static GCMParameterSpec actualParamsOf(Cipher cipher) throws JOSEException {
        AlgorithmParameters algorithmParameters = cipher.getParameters();
        if (algorithmParameters == null) {
            throw new JOSEException("AES GCM ciphers are expected to make use of algorithm parameters");
        }
        try {
            return algorithmParameters.getParameterSpec(GCMParameterSpec.class);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new JOSEException(invalidParameterSpecException.getMessage(), invalidParameterSpecException);
        }
    }

    public static byte[] decrypt(SecretKey secretKey, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, Provider provider) throws JOSEException {
        Cipher cipher;
        SecretKey secretKey2 = KeyUtils.toAESKey(secretKey);
        try {
            cipher = provider != null ? Cipher.getInstance("AES/GCM/NoPadding", provider) : Cipher.getInstance("AES/GCM/NoPadding");
            GCMParameterSpec gCMParameterSpec = new GCMParameterSpec(128, byArray);
            cipher.init(2, (Key)secretKey2, gCMParameterSpec);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException generalSecurityException) {
            throw new JOSEException("Couldn't create AES/GCM/NoPadding cipher: " + generalSecurityException.getMessage(), generalSecurityException);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return LegacyAESGCM.decrypt(secretKey2, byArray, byArray2, byArray3, byArray4);
        }
        cipher.updateAAD(byArray3);
        try {
            return cipher.doFinal(ByteUtils.concat(byArray2, byArray4));
        }
        catch (BadPaddingException | IllegalBlockSizeException generalSecurityException) {
            throw new JOSEException("AES/GCM/NoPadding decryption failed: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    private AESGCM() {
    }
}

