/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto;

import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.SecretKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.EncryptionMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWECryptoParts;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEEncrypter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.AlgorithmSupportMessage;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.ContentCryptoProvider;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.RSA1_5;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.RSACryptoProvider;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.RSA_OAEP;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.RSA_OAEP_SHA2;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.RSAKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class RSAEncrypter
extends RSACryptoProvider
implements JWEEncrypter {
    private final RSAPublicKey publicKey;
    private final SecretKey contentEncryptionKey;

    public RSAEncrypter(RSAPublicKey rSAPublicKey) {
        this(rSAPublicKey, null);
    }

    public RSAEncrypter(RSAKey rSAKey) throws JOSEException {
        this(rSAKey.toRSAPublicKey());
    }

    public RSAEncrypter(RSAPublicKey rSAPublicKey, SecretKey secretKey) {
        if (rSAPublicKey == null) {
            throw new IllegalArgumentException("The public RSA key must not be null");
        }
        this.publicKey = rSAPublicKey;
        Set<String> set = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("AES", "ChaCha20")));
        if (secretKey != null) {
            if (secretKey.getAlgorithm() == null || !set.contains(secretKey.getAlgorithm())) {
                throw new IllegalArgumentException("The algorithm of the content encryption key (CEK) must be AES or ChaCha20");
            }
            this.contentEncryptionKey = secretKey;
        } else {
            this.contentEncryptionKey = null;
        }
    }

    public RSAPublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public JWECryptoParts encrypt(JWEHeader jWEHeader, byte[] byArray) throws JOSEException {
        Base64URL base64URL;
        JWEAlgorithm jWEAlgorithm = jWEHeader.getAlgorithm();
        EncryptionMethod encryptionMethod = jWEHeader.getEncryptionMethod();
        SecretKey secretKey = this.contentEncryptionKey != null ? this.contentEncryptionKey : ContentCryptoProvider.generateCEK(encryptionMethod, this.getJCAContext().getSecureRandom());
        if (jWEAlgorithm.equals(JWEAlgorithm.RSA1_5)) {
            base64URL = Base64URL.encode(RSA1_5.encryptCEK(this.publicKey, secretKey, this.getJCAContext().getKeyEncryptionProvider()));
        } else if (jWEAlgorithm.equals(JWEAlgorithm.RSA_OAEP)) {
            base64URL = Base64URL.encode(RSA_OAEP.encryptCEK(this.publicKey, secretKey, this.getJCAContext().getKeyEncryptionProvider()));
        } else if (jWEAlgorithm.equals(JWEAlgorithm.RSA_OAEP_256)) {
            base64URL = Base64URL.encode(RSA_OAEP_SHA2.encryptCEK(this.publicKey, secretKey, 256, this.getJCAContext().getKeyEncryptionProvider()));
        } else if (jWEAlgorithm.equals(JWEAlgorithm.RSA_OAEP_384)) {
            base64URL = Base64URL.encode(RSA_OAEP_SHA2.encryptCEK(this.publicKey, secretKey, 384, this.getJCAContext().getKeyEncryptionProvider()));
        } else if (jWEAlgorithm.equals(JWEAlgorithm.RSA_OAEP_512)) {
            base64URL = Base64URL.encode(RSA_OAEP_SHA2.encryptCEK(this.publicKey, secretKey, 512, this.getJCAContext().getKeyEncryptionProvider()));
        } else {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedJWEAlgorithm(jWEAlgorithm, SUPPORTED_ALGORITHMS));
        }
        return ContentCryptoProvider.encrypt(jWEHeader, byArray, secretKey, base64URL, this.getJCAContext());
    }
}

