/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.BindingPolicy;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.HttpHelper;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.HttpMethod;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.HttpRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IHttpResponse;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MexParser;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalServiceException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalServiceExceptionFactory;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.RequestContext;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ServiceBundle;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.StringHelper;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.WSTrustResponse;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.WSTrustVersion;

class WSTrustRequest {
    private static final int MAX_EXPECTED_MESSAGE_SIZE = 1024;
    static final String DEFAULT_APPLIES_TO = "urn:federation:MicrosoftOnline";

    WSTrustRequest() {
    }

    static WSTrustResponse execute(String string, String string2, String string3, BindingPolicy bindingPolicy, RequestContext requestContext, ServiceBundle serviceBundle) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Content-Type", "application/soap+xml; charset=utf-8");
        hashMap.put("return-client-request-id", "true");
        String string4 = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/RST/Issue";
        if (bindingPolicy.getVersion() == WSTrustVersion.WSTRUST2005) {
            string4 = "http://schemas.xmlsoap.org/ws/2005/02/trust/RST/Issue";
        }
        hashMap.put("SOAPAction", string4);
        String string5 = WSTrustRequest.buildMessage(bindingPolicy.getUrl(), string, string2, bindingPolicy.getVersion(), string3).toString();
        HttpRequest httpRequest = new HttpRequest(HttpMethod.POST, bindingPolicy.getUrl(), hashMap, string5);
        IHttpResponse iHttpResponse = HttpHelper.executeHttpRequest(httpRequest, requestContext, serviceBundle);
        return WSTrustResponse.parse(iHttpResponse.body(), bindingPolicy.getVersion());
    }

    static WSTrustResponse execute(String string, String string2, String string3, String string4, RequestContext requestContext, ServiceBundle serviceBundle, boolean bl2) throws Exception {
        HttpRequest httpRequest = new HttpRequest(HttpMethod.GET, string);
        IHttpResponse iHttpResponse = HttpHelper.executeHttpRequest(httpRequest, requestContext, serviceBundle);
        if (iHttpResponse.statusCode() != 200 || StringHelper.isBlank(iHttpResponse.body())) {
            throw MsalServiceExceptionFactory.fromHttpResponse(iHttpResponse);
        }
        BindingPolicy bindingPolicy = MexParser.getWsTrustEndpointFromMexResponse(iHttpResponse.body(), bl2);
        if (bindingPolicy == null) {
            throw new MsalServiceException("WsTrust endpoint not found in metadata document", "wstrust_endpoint_not_found");
        }
        return WSTrustRequest.execute(string2, string3, string4, bindingPolicy, requestContext, serviceBundle);
    }

    static WSTrustResponse execute(String string, String string2, RequestContext requestContext, ServiceBundle serviceBundle, boolean bl2) throws Exception {
        HttpRequest httpRequest = new HttpRequest(HttpMethod.GET, string);
        IHttpResponse iHttpResponse = HttpHelper.executeHttpRequest(httpRequest, requestContext, serviceBundle);
        BindingPolicy bindingPolicy = MexParser.getPolicyFromMexResponseForIntegrated(iHttpResponse.body(), bl2);
        if (bindingPolicy == null) {
            throw new MsalServiceException("WsTrust endpoint not found in metadata document", "wstrust_endpoint_not_found");
        }
        return WSTrustRequest.execute(null, null, string2, bindingPolicy, requestContext, serviceBundle);
    }

    static StringBuilder buildMessage(String string, String string2, String string3, WSTrustVersion wSTrustVersion, String string4) {
        boolean bl2 = string2 == null & string3 == null;
        StringBuilder stringBuilder = new StringBuilder(1024);
        if (!bl2) {
            WSTrustRequest.buildSecurityHeader(stringBuilder, string2, string3, wSTrustVersion);
        }
        String string5 = UUID.randomUUID().toString();
        StringBuilder stringBuilder2 = new StringBuilder(1024);
        String string6 = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
        String string7 = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/RST/Issue";
        String string8 = "http://docs.oasis-open.org/ws-sx/ws-trust/200512";
        String string9 = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/Bearer";
        String string10 = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/Issue";
        if (wSTrustVersion == WSTrustVersion.WSTRUST2005) {
            string7 = "http://schemas.xmlsoap.org/ws/2005/02/trust/RST/Issue";
            string8 = "http://schemas.xmlsoap.org/ws/2005/02/trust";
            string9 = "http://schemas.xmlsoap.org/ws/2005/05/identity/NoProofKey";
            string10 = "http://schemas.xmlsoap.org/ws/2005/02/trust/Issue";
        }
        stringBuilder2.append(String.format("<s:Envelope xmlns:s='http://www.w3.org/2003/05/soap-envelope' xmlns:a='http://www.w3.org/2005/08/addressing' xmlns:u='%s'><s:Header><a:Action s:mustUnderstand='1'>%s</a:Action><a:messageID>urn:uuid:%s</a:messageID><a:ReplyTo><a:Address>http://www.w3.org/2005/08/addressing/anonymous</a:Address></a:ReplyTo><a:To s:mustUnderstand='1'>%s</a:To>%s</s:Header><s:Body><trust:RequestSecurityToken xmlns:trust='%s'><wsp:AppliesTo xmlns:wsp='http://schemas.xmlsoap.org/ws/2004/09/policy'><a:EndpointReference><a:Address>%s</a:Address></a:EndpointReference></wsp:AppliesTo><trust:KeyType>%s</trust:KeyType><trust:RequestType>%s</trust:RequestType></trust:RequestSecurityToken></s:Body></s:Envelope>", string6, string7, string5, string, bl2 ? "" : stringBuilder.toString(), string8, StringHelper.isBlank(string4) ? DEFAULT_APPLIES_TO : string4, string9, string10));
        return stringBuilder2;
    }

    static String escapeXMLElementData(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        block7: for (char c2 : string.toCharArray()) {
            switch (c2) {
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    stringBuilder.append("&apos;");
                    continue block7;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block7;
                }
                default: {
                    stringBuilder.append(c2);
                }
            }
        }
        return stringBuilder.toString();
    }

    private static StringBuilder buildSecurityHeader(StringBuilder stringBuilder, String string, String string2, WSTrustVersion wSTrustVersion) {
        StringBuilder stringBuilder2 = new StringBuilder(1024);
        String string3 = UUID.randomUUID().toString();
        string = WSTrustRequest.escapeXMLElementData(string);
        string2 = WSTrustRequest.escapeXMLElementData(string2);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date date = new Date();
        String string4 = simpleDateFormat.format(date);
        int n2 = 600000;
        date = new Date(date.getTime() + (long)n2);
        String string5 = simpleDateFormat.format(date);
        stringBuilder2.append(String.format("<o:UsernameToken u:Id='uuid-%s'><o:Username>%s</o:Username><o:Password>%s</o:Password></o:UsernameToken>", string3, string, string2));
        stringBuilder.append("<o:Security s:mustUnderstand='1' xmlns:o='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd'>");
        stringBuilder.append(String.format("<u:Timestamp u:Id='_0'><u:Created>%s</u:Created><u:Expires>%s</u:Expires></u:Timestamp>", string4, string5));
        stringBuilder.append(stringBuilder2.toString());
        stringBuilder.append("</o:Security>");
        return stringBuilder;
    }
}

