/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ApiEvent;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.DefaultEvent;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.Event;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.EventKey;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ITelemetry;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ITelemetryManager;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.StringHelper;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.TelemetryHelper;

class TelemetryManager
implements ITelemetry,
ITelemetryManager {
    private final ConcurrentHashMap<String, List<Event>> completedEvents = new ConcurrentHashMap();
    private final ConcurrentHashMap<EventKey, Event> eventsInProgress = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ConcurrentHashMap<String, Integer>> eventCount = new ConcurrentHashMap();
    private boolean onlySendFailureTelemetry;
    private Consumer<List<HashMap<String, String>>> telemetryConsumer;

    public TelemetryManager(Consumer<List<HashMap<String, String>>> consumer, boolean bl2) {
        this.telemetryConsumer = consumer;
        this.onlySendFailureTelemetry = bl2;
    }

    @Override
    public TelemetryHelper createTelemetryHelper(String string, String string2, Event event, Boolean bl2) {
        return new TelemetryHelper(this, string, string2, event, bl2);
    }

    @Override
    public String generateRequestId() {
        return UUID.randomUUID().toString();
    }

    @Override
    public void startEvent(String string, Event event) {
        if (this.hasConsumer() && !StringHelper.isBlank(string)) {
            this.eventsInProgress.put(new EventKey(string, event), event);
        }
    }

    @Override
    public void stopEvent(String string, Event event) {
        if (!this.hasConsumer() || StringHelper.isBlank(string)) {
            return;
        }
        EventKey eventKey = new EventKey(string, event);
        Event event2 = this.eventsInProgress.getOrDefault(eventKey, null);
        if (event2 == null) {
            return;
        }
        event.stop();
        this.incrementEventCount(string, event);
        if (!this.completedEvents.containsKey(string)) {
            ArrayList<Event> arrayList = new ArrayList<Event>(Arrays.asList(event));
            this.completedEvents.put(string, arrayList);
        } else {
            List<Event> list = this.completedEvents.get(string);
            list.add(event);
        }
        this.eventsInProgress.remove(eventKey);
    }

    @Override
    public void flush(String string, String string2) {
        if (!this.hasConsumer()) {
            return;
        }
        if (!this.completedEvents.containsKey(string)) {
            return;
        }
        this.completedEvents.get(string).addAll(this.collateOrphanedEvents(string));
        List<Event> list = this.completedEvents.remove(string);
        Map map = this.eventCount.remove(string);
        map = map != null ? map : new ConcurrentHashMap();
        Predicate<Event> predicate = event -> event instanceof ApiEvent && ((ApiEvent)event).getWasSuccessful();
        if (this.onlySendFailureTelemetry && list.stream().anyMatch(predicate)) {
            list.clear();
        }
        if (list.size() <= 0) {
            return;
        }
        list.add(0, new DefaultEvent(string2, map));
        this.telemetryConsumer.accept(Collections.unmodifiableList(list));
    }

    private Collection<Event> collateOrphanedEvents(String string) {
        ArrayList<Event> arrayList = new ArrayList<Event>();
        for (EventKey eventKey : this.eventsInProgress.keySet()) {
            if (!eventKey.getRequestId().equalsIgnoreCase(string)) continue;
            arrayList.add(this.eventsInProgress.remove(eventKey));
        }
        return arrayList;
    }

    private void incrementEventCount(String string, Event event) {
        final String string2 = (String)event.get("event_name");
        ConcurrentHashMap<String, Integer> concurrentHashMap = this.eventCount.getOrDefault(string, new ConcurrentHashMap<String, Integer>(){
            {
                this.put(string2, 0);
            }
        });
        concurrentHashMap.put(string2, concurrentHashMap.getOrDefault(string2, 0) + 1);
        this.eventCount.put(string, concurrentHashMap);
    }

    private boolean hasConsumer() {
        return this.telemetryConsumer != null;
    }
}

