/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.CurrentRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.StringHelper;
import macromedia.jdbc.sqlserver.externals.org.slf4j.Logger;
import macromedia.jdbc.sqlserver.externals.org.slf4j.LoggerFactory;

class ServerSideTelemetry {
    private static final Logger log = LoggerFactory.getLogger(ServerSideTelemetry.class);
    private static final String SCHEMA_VERSION = "5";
    private static final String SCHEMA_PIPE_DELIMITER = "|";
    private static final String SCHEMA_COMMA_DELIMITER = ",";
    private static final String CURRENT_REQUEST_HEADER_NAME = "x-client-current-telemetry";
    private static final String LAST_REQUEST_HEADER_NAME = "x-client-last-telemetry";
    private static final int CURRENT_REQUEST_MAX_SIZE = 100;
    private static final int LAST_REQUEST_MAX_SIZE = 350;
    private CurrentRequest currentRequest;
    private AtomicInteger silentSuccessfulCount = new AtomicInteger(0);
    ConcurrentMap<String, String[]> previousRequests = new ConcurrentHashMap<String, String[]>();
    ConcurrentMap<String, String[]> previousRequestInProgress = new ConcurrentHashMap<String, String[]>();

    ServerSideTelemetry() {
    }

    synchronized Map<String, String> getServerTelemetryHeaderMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(CURRENT_REQUEST_HEADER_NAME, this.buildCurrentRequestHeader());
        hashMap.put(LAST_REQUEST_HEADER_NAME, this.buildLastRequestHeader());
        return hashMap;
    }

    void addFailedRequestTelemetry(String string, String string2, String string3) {
        String[] stringArray = new String[]{string, string3};
        this.previousRequests.put(string2, stringArray);
    }

    void incrementSilentSuccessfulCount() {
        this.silentSuccessfulCount.incrementAndGet();
    }

    synchronized CurrentRequest getCurrentRequest() {
        return this.currentRequest;
    }

    synchronized void setCurrentRequest(CurrentRequest currentRequest) {
        this.currentRequest = currentRequest;
    }

    private synchronized String buildCurrentRequestHeader() {
        if (this.currentRequest == null) {
            return StringHelper.EMPTY_STRING;
        }
        String string = "5|" + this.currentRequest.publicApi().getApiId() + SCHEMA_COMMA_DELIMITER + (this.currentRequest.cacheInfo() == -1 ? "" : Integer.valueOf(this.currentRequest.cacheInfo())) + SCHEMA_COMMA_DELIMITER + this.currentRequest.regionUsed() + SCHEMA_COMMA_DELIMITER + this.currentRequest.regionSource() + SCHEMA_COMMA_DELIMITER + this.currentRequest.regionOutcome() + SCHEMA_PIPE_DELIMITER;
        if (string.getBytes(StandardCharsets.UTF_8).length > 100) {
            log.warn("Current request telemetry header greater than 100 bytes");
        }
        return string;
    }

    private synchronized String buildLastRequestHeader() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SCHEMA_VERSION).append(SCHEMA_PIPE_DELIMITER).append(this.silentSuccessfulCount.getAndSet(0));
        int n2 = stringBuilder.toString().getBytes(StandardCharsets.UTF_8).length;
        if (this.previousRequests.isEmpty()) {
            return stringBuilder.append(SCHEMA_PIPE_DELIMITER).append(SCHEMA_PIPE_DELIMITER).append(SCHEMA_PIPE_DELIMITER).toString();
        }
        StringBuilder stringBuilder2 = new StringBuilder(SCHEMA_PIPE_DELIMITER);
        StringBuilder stringBuilder3 = new StringBuilder(SCHEMA_PIPE_DELIMITER);
        Iterator iterator = this.previousRequests.keySet().iterator();
        String string = stringBuilder.toString() + SCHEMA_PIPE_DELIMITER + SCHEMA_PIPE_DELIMITER;
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String[] stringArray = (String[])this.previousRequests.get(string2);
            String string3 = (String)Array.get(stringArray, 0);
            String string4 = (String)Array.get(stringArray, 1);
            stringBuilder2.append(string3).append(SCHEMA_COMMA_DELIMITER).append(string2);
            stringBuilder3.append(string4);
            int n3 = n2 + stringBuilder2.toString().getBytes(StandardCharsets.UTF_8).length + stringBuilder3.toString().getBytes(StandardCharsets.UTF_8).length;
            if (n3 >= 349) break;
            string = stringBuilder.toString() + stringBuilder2.toString() + stringBuilder3.toString();
            this.previousRequestInProgress.put(string2, stringArray);
            iterator.remove();
            if (!iterator.hasNext()) continue;
            stringBuilder2.append(SCHEMA_COMMA_DELIMITER);
            stringBuilder3.append(SCHEMA_COMMA_DELIMITER);
        }
        return string + SCHEMA_PIPE_DELIMITER;
    }
}

