/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ConfidentialClientApplication;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalClientException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.OAuthAuthorizationGrant;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.OnBehalfOfParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.RequestContext;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.SignedJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.AuthorizationGrant;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.JWTBearerGrant;

class OnBehalfOfRequest
extends MsalRequest {
    OnBehalfOfParameters parameters;

    OnBehalfOfRequest(OnBehalfOfParameters onBehalfOfParameters, ConfidentialClientApplication confidentialClientApplication, RequestContext requestContext) {
        super(confidentialClientApplication, OnBehalfOfRequest.createAuthenticationGrant(onBehalfOfParameters), requestContext);
        this.parameters = onBehalfOfParameters;
    }

    private static OAuthAuthorizationGrant createAuthenticationGrant(OnBehalfOfParameters onBehalfOfParameters) {
        JWTBearerGrant jWTBearerGrant;
        try {
            jWTBearerGrant = new JWTBearerGrant(SignedJWT.parse(onBehalfOfParameters.userAssertion().getAssertion()));
        }
        catch (Exception exception) {
            throw new MsalClientException(exception);
        }
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        hashMap.put("requested_token_use", Collections.singletonList("on_behalf_of"));
        if (onBehalfOfParameters.claims() != null) {
            hashMap.put("claims", Collections.singletonList(onBehalfOfParameters.claims().formatAsJSONString()));
        }
        return new OAuthAuthorizationGrant((AuthorizationGrant)jWTBearerGrant, String.join((CharSequence)" ", onBehalfOfParameters.scopes()), hashMap);
    }

    public OnBehalfOfParameters parameters() {
        return this.parameters;
    }
}

