/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.BindingPolicy;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalClientException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.NamespaceContextImpl;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.SafeDocumentBuilderFactory;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.StringHelper;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.WSTrustVersion;
import macromedia.jdbc.sqlserver.externals.org.slf4j.Logger;
import macromedia.jdbc.sqlserver.externals.org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class MexParser {
    private static final Logger log = LoggerFactory.getLogger(MexParser.class);
    private static final String TRANSPORT_BINDING_XPATH = "wsp:ExactlyOne/wsp:All/sp:TransportBinding";
    private static final String TRANSPORT_BINDING_2005_XPATH = "wsp:ExactlyOne/wsp:All/sp2005:TransportBinding";
    private static final String PORT_XPATH = "//wsdl:definitions/wsdl:service/wsdl:port";
    private static final String ADDRESS_XPATH = "wsa10:EndpointReference/wsa10:Address";
    private static final String SOAP_ACTION_XPATH = "wsdl:operation/soap12:operation/@soapAction";
    private static final String RST_SOAP_ACTION = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/RST/Issue";
    private static final String RST_SOAP_ACTION_2005 = "http://schemas.xmlsoap.org/ws/2005/02/trust/RST/Issue";
    private static final String SOAP_TRANSPORT_XPATH = "soap12:binding/@transport";
    private static final String SOAP_HTTP_TRANSPORT_VALUE = "http://schemas.xmlsoap.org/soap/http";

    MexParser() {
    }

    static BindingPolicy getPolicy(String string, PolicySelector policySelector, boolean bl2) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = SafeDocumentBuilderFactory.createInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8)));
        XPath xPath = XPathFactory.newInstance().newXPath();
        NamespaceContextImpl namespaceContextImpl = new NamespaceContextImpl();
        xPath.setNamespaceContext(namespaceContextImpl);
        Map<String, BindingPolicy> map = policySelector.selectPolicies(document, xPath, bl2);
        if (map.isEmpty()) {
            log.debug("No matching policies");
            return null;
        }
        Map<String, BindingPolicy> map2 = MexParser.getMatchingBindings(document, xPath, map, bl2);
        if (map2.isEmpty()) {
            log.debug("No matching bindings");
            return null;
        }
        MexParser.getPortsForPolicyBindings(document, xPath, map2, map, bl2);
        return MexParser.selectSingleMatchingPolicy(map);
    }

    static BindingPolicy getPolicyFromMexResponseForIntegrated(String string, boolean bl2) throws Exception {
        return MexParser.getPolicy(string, new NegotiateAuthenticationPolicySelector(), bl2);
    }

    static BindingPolicy getWsTrustEndpointFromMexResponse(String string, boolean bl2) throws Exception {
        return MexParser.getPolicy(string, new WsTrustEndpointPolicySelector(), bl2);
    }

    private static BindingPolicy selectSingleMatchingPolicy(Map<String, BindingPolicy> map) {
        BindingPolicy bindingPolicy = null;
        BindingPolicy bindingPolicy2 = null;
        for (Map.Entry<String, BindingPolicy> entry : map.entrySet()) {
            if (entry.getValue().getUrl() == null) continue;
            if (entry.getValue().getVersion() == WSTrustVersion.WSTRUST13) {
                bindingPolicy = entry.getValue();
                continue;
            }
            if (entry.getValue().getVersion() != WSTrustVersion.WSTRUST2005) continue;
            bindingPolicy2 = entry.getValue();
        }
        if (bindingPolicy == null && bindingPolicy2 == null) {
            log.warn("No policies found with the url");
            return null;
        }
        return bindingPolicy != null ? bindingPolicy : bindingPolicy2;
    }

    private static void getPortsForPolicyBindings(Document document, XPath xPath, Map<String, BindingPolicy> map, Map<String, BindingPolicy> map2, boolean bl2) throws Exception {
        NodeList nodeList = (NodeList)xPath.compile(PORT_XPATH).evaluate(document, XPathConstants.NODESET);
        if (nodeList.getLength() == 0) {
            log.warn("No ports found");
        } else {
            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                BindingPolicy bindingPolicy;
                Node node = nodeList.item(i2);
                String string = node.getAttributes().getNamedItem("binding").getNodeValue();
                String[] stringArray = string.split(":");
                BindingPolicy bindingPolicy2 = map.get(string = stringArray[stringArray.length - 1]);
                if (bindingPolicy2 == null || (bindingPolicy = map2.get(bindingPolicy2.getUrl())) == null || !StringHelper.isBlank(bindingPolicy.getUrl())) continue;
                bindingPolicy.setVersion(bindingPolicy2.getVersion());
                NodeList nodeList2 = (NodeList)xPath.compile(ADDRESS_XPATH).evaluate(node, XPathConstants.NODESET);
                if (nodeList2.getLength() > 0) {
                    String string2 = nodeList2.item(0).getTextContent();
                    if (string2 != null && string2.toLowerCase().startsWith("https://")) {
                        bindingPolicy.setUrl(string2.trim());
                        continue;
                    }
                    if (bl2) {
                        log.warn("Skipping insecure endpoint: " + string2);
                        continue;
                    }
                    log.warn("Skipping insecure endpoint");
                    continue;
                }
                throw new MsalClientException("Error parsing WSTrustResponse: No address nodes on port", "wstrust_invalid_response");
            }
        }
    }

    private static Map<String, BindingPolicy> getMatchingBindings(Document document, XPath xPath, Map<String, BindingPolicy> map, boolean bl2) throws XPathExpressionException {
        HashMap<String, BindingPolicy> hashMap = new HashMap<String, BindingPolicy>();
        NodeList nodeList = (NodeList)xPath.compile("//wsdl:definitions/wsdl:binding/wsp:PolicyReference").evaluate(document, XPathConstants.NODESET);
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Node node = nodeList.item(i2);
            String string = node.getAttributes().getNamedItem("URI").getNodeValue();
            if (!map.containsKey(string)) continue;
            Node node2 = node.getParentNode();
            String string2 = node2.getAttributes().getNamedItem("name").getNodeValue();
            WSTrustVersion wSTrustVersion = MexParser.checkSoapActionAndTransport(xPath, node2, bl2);
            if (wSTrustVersion == WSTrustVersion.UNDEFINED) continue;
            BindingPolicy bindingPolicy = new BindingPolicy("");
            bindingPolicy.setUrl(string);
            bindingPolicy.setVersion(wSTrustVersion);
            hashMap.put(string2, bindingPolicy);
        }
        return hashMap;
    }

    private static WSTrustVersion checkSoapActionAndTransport(XPath xPath, Node node, boolean bl2) throws XPathExpressionException {
        NodeList nodeList = null;
        String string = null;
        String string2 = node.getAttributes().getNamedItem("name").getNodeValue();
        NodeList nodeList2 = (NodeList)xPath.compile(SOAP_ACTION_XPATH).evaluate(node, XPathConstants.NODESET);
        if (nodeList2.getLength() > 0) {
            string = nodeList2.item(0).getNodeValue();
            nodeList = (NodeList)xPath.compile(SOAP_TRANSPORT_XPATH).evaluate(node, XPathConstants.NODESET);
            if (nodeList != null && nodeList.getLength() > 0 && nodeList.item(0).getNodeValue().equalsIgnoreCase(SOAP_HTTP_TRANSPORT_VALUE)) {
                if (string.equalsIgnoreCase(RST_SOAP_ACTION)) {
                    if (bl2) {
                        log.debug("Found binding matching Action and Transport: " + string2);
                    } else {
                        log.debug("Found binding matching Action and Transport");
                    }
                    return WSTrustVersion.WSTRUST13;
                }
                if (string.equalsIgnoreCase(RST_SOAP_ACTION_2005)) {
                    if (bl2) {
                        log.debug("Binding node did not match soap Action or Transport: " + string2);
                    } else {
                        log.debug("Binding node did not match soap Action or Transport");
                    }
                    return WSTrustVersion.WSTRUST2005;
                }
            }
        }
        return WSTrustVersion.UNDEFINED;
    }

    private static Map<String, BindingPolicy> selectUsernamePasswordPoliciesWithExpression(Document document, XPath xPath, String string, boolean bl2) throws XPathExpressionException {
        HashMap<String, BindingPolicy> hashMap = new HashMap<String, BindingPolicy>();
        NodeList nodeList = (NodeList)xPath.compile(string).evaluate(document, XPathConstants.NODESET);
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            String string2 = MexParser.checkPolicy(xPath, nodeList.item(i2).getParentNode().getParentNode().getParentNode().getParentNode().getParentNode().getParentNode().getParentNode(), bl2);
            hashMap.put("#" + string2, new BindingPolicy("#" + string2));
        }
        return hashMap;
    }

    private static Map<String, BindingPolicy> selectIntegratedPoliciesWithExpression(Document document, XPath xPath, String string) throws XPathExpressionException {
        HashMap<String, BindingPolicy> hashMap = new HashMap<String, BindingPolicy>();
        NodeList nodeList = (NodeList)xPath.compile(string).evaluate(document, XPathConstants.NODESET);
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            String string2 = MexParser.checkPolicyIntegrated(xPath, nodeList.item(i2).getParentNode().getParentNode().getParentNode());
            hashMap.put("#" + string2, new BindingPolicy("#" + string2));
        }
        return hashMap;
    }

    private static String checkPolicy(XPath xPath, Node node, boolean bl2) throws XPathExpressionException {
        String string = null;
        Node node2 = node.getAttributes().getNamedItem("wsu:Id");
        NodeList nodeList = (NodeList)xPath.compile(TRANSPORT_BINDING_XPATH).evaluate(node, XPathConstants.NODESET);
        if (nodeList.getLength() == 0) {
            nodeList = (NodeList)xPath.compile(TRANSPORT_BINDING_2005_XPATH).evaluate(node, XPathConstants.NODESET);
        }
        if (nodeList.getLength() > 0 && node2 != null) {
            string = node2.getNodeValue();
            if (bl2) {
                log.debug("found matching policy id: " + string);
            } else {
                log.debug("found matching policy");
            }
        } else {
            String string2 = "none";
            if (node2 != null) {
                string2 = node2.getNodeValue();
            }
            if (bl2) {
                log.debug("potential policy did not match required transport binding: " + string2);
            } else {
                log.debug("potential policy did not match required transport binding");
            }
        }
        return string;
    }

    private static String checkPolicyIntegrated(XPath xPath, Node node) throws XPathExpressionException {
        Node node2 = node.getAttributes().getNamedItem("wsu:Id");
        String string = node2.getNodeValue();
        return string;
    }

    private static class WsTrustEndpointPolicySelector
    implements PolicySelector {
        private WsTrustEndpointPolicySelector() {
        }

        @Override
        public Map<String, BindingPolicy> selectPolicies(Document document, XPath xPath, boolean bl2) throws XPathExpressionException {
            String string = "//wsdl:definitions/wsp:Policy/wsp:ExactlyOne/wsp:All/sp:SignedEncryptedSupportingTokens/wsp:Policy/sp:UsernameToken/wsp:Policy/sp:WssUsernameToken10";
            Map map = MexParser.selectUsernamePasswordPoliciesWithExpression(document, xPath, string, bl2);
            ((NamespaceContextImpl)xPath.getNamespaceContext()).modifyNameSpace("sp", "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy");
            string = "//wsdl:definitions/wsp:Policy/wsp:ExactlyOne/wsp:All/sp:SignedSupportingTokens/wsp:Policy/sp:UsernameToken/wsp:Policy/sp:WssUsernameToken10";
            map.putAll(MexParser.selectUsernamePasswordPoliciesWithExpression(document, xPath, string, bl2));
            return map;
        }
    }

    private static class NegotiateAuthenticationPolicySelector
    implements PolicySelector {
        private NegotiateAuthenticationPolicySelector() {
        }

        @Override
        public Map<String, BindingPolicy> selectPolicies(Document document, XPath xPath, boolean bl2) throws XPathExpressionException {
            String string = "//wsdl:definitions/wsp:Policy/wsp:ExactlyOne/wsp:All/http:NegotiateAuthentication";
            return MexParser.selectIntegratedPoliciesWithExpression(document, xPath, string);
        }
    }

    private static interface PolicySelector {
        public Map<String, BindingPolicy> selectPolicies(Document var1, XPath var2, boolean var3) throws XPathExpressionException;
    }
}

