/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ClientAssertion;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ClientCertificate;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalClientException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.StringHelper;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSSigner;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.RSASSASigner;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.SignedJWT;

final class JwtHelper {
    JwtHelper() {
    }

    static ClientAssertion buildJwt(String string, ClientCertificate clientCertificate, String string2, boolean bl2) throws MsalClientException {
        SignedJWT signedJWT;
        if (StringHelper.isBlank(string)) {
            throw new IllegalArgumentException("clientId is null or empty");
        }
        if (clientCertificate == null) {
            throw new IllegalArgumentException("credential is null");
        }
        long l2 = System.currentTimeMillis();
        JWTClaimsSet jWTClaimsSet = new JWTClaimsSet.Builder().audience(Collections.singletonList(string2)).issuer(string).jwtID(UUID.randomUUID().toString()).notBeforeTime(new Date(l2)).expirationTime(new Date(l2 + 600000L)).subject(string).build();
        try {
            Object object;
            JWSHeader.Builder builder = new JWSHeader.Builder(JWSAlgorithm.RS256);
            if (bl2) {
                object = new ArrayList<Base64>();
                for (String string3 : clientCertificate.getEncodedPublicKeyCertificateChain()) {
                    object.add((Base64)new Base64(string3));
                }
                builder.x509CertChain((List<Base64>)object);
            }
            builder.x509CertThumbprint(new Base64URL(clientCertificate.publicCertificateHash()));
            signedJWT = new SignedJWT(builder.build(), jWTClaimsSet);
            object = new RSASSASigner(clientCertificate.privateKey());
            signedJWT.sign((JWSSigner)object);
        }
        catch (Exception exception) {
            throw new MsalClientException(exception);
        }
        return new ClientAssertion(signedJWT.serialize());
    }
}

