/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthorizationRequestUrlParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IAuthenticationResult;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.InteractiveRequestParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalClientException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.PublicClientApplication;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.RequestContext;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.StringHelper;

class InteractiveRequest
extends MsalRequest {
    private AtomicReference<CompletableFuture<IAuthenticationResult>> futureReference;
    private InteractiveRequestParameters interactiveRequestParameters;
    private String verifier;
    private String state;
    private PublicClientApplication publicClientApplication;
    private URL authorizationUrl;

    InteractiveRequest(InteractiveRequestParameters interactiveRequestParameters, AtomicReference<CompletableFuture<IAuthenticationResult>> atomicReference, PublicClientApplication publicClientApplication, RequestContext requestContext) {
        super(publicClientApplication, null, requestContext);
        this.interactiveRequestParameters = interactiveRequestParameters;
        this.futureReference = atomicReference;
        this.publicClientApplication = publicClientApplication;
        this.validateRedirectUrl(interactiveRequestParameters.redirectUri());
    }

    URL authorizationUrl() {
        if (this.authorizationUrl == null) {
            this.authorizationUrl = this.createAuthorizationUrl();
        }
        return this.authorizationUrl;
    }

    private void validateRedirectUrl(URI uRI) {
        try {
            if (!InetAddress.getByName(uRI.getHost()).isLoopbackAddress()) {
                throw new MsalClientException(String.format("Only loopback redirect uri is supported, but %s was found Configure http://localhost or http://localhost:port both during app registrationand when you create the create the InteractiveRequestParameters object", uRI.getHost()), "loopback_redirect_uri");
            }
            if (!uRI.getScheme().equals("http")) {
                throw new MsalClientException(String.format("Only http uri scheme is supported but %s was found. Configure http://localhostor http://localhost:port both during app registration and when you create the create the InteractiveRequestParameters object", uRI.toString()), "loopback_redirect_uri");
            }
        }
        catch (Exception exception) {
            throw new MsalClientException(exception);
        }
    }

    private URL createAuthorizationUrl() {
        AuthorizationRequestUrlParameters.Builder builder = AuthorizationRequestUrlParameters.builder(this.interactiveRequestParameters.redirectUri().toString(), this.interactiveRequestParameters.scopes()).prompt(this.interactiveRequestParameters.prompt()).claimsChallenge(this.interactiveRequestParameters.claimsChallenge()).loginHint(this.interactiveRequestParameters.loginHint()).domainHint(this.interactiveRequestParameters.domainHint()).correlationId(this.publicClientApplication.correlationId()).instanceAware(this.interactiveRequestParameters.instanceAware());
        this.addPkceAndState(builder);
        return this.publicClientApplication.getAuthorizationRequestUrl(builder.build());
    }

    private void addPkceAndState(AuthorizationRequestUrlParameters.Builder builder) {
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray = new byte[32];
        secureRandom.nextBytes(byArray);
        this.verifier = Base64.getUrlEncoder().withoutPadding().encodeToString(byArray);
        this.state = UUID.randomUUID().toString() + UUID.randomUUID().toString();
        builder.codeChallenge(StringHelper.createBase64EncodedSha256Hash(this.verifier)).codeChallengeMethod("S256").state(this.state);
    }

    AtomicReference<CompletableFuture<IAuthenticationResult>> futureReference() {
        return this.futureReference;
    }

    InteractiveRequestParameters interactiveRequestParameters() {
        return this.interactiveRequestParameters;
    }

    String verifier() {
        return this.verifier;
    }

    String state() {
        return this.state;
    }
}

