/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ClientAssertion;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.SerializeException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.ClientID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URLUtils;

public class CustomJWTAuthentication
extends ClientAuthentication {
    private ClientAssertion clientAssertion;

    protected CustomJWTAuthentication(ClientAuthenticationMethod clientAuthenticationMethod, ClientAssertion clientAssertion, ClientID clientID) {
        super(clientAuthenticationMethod, clientID);
        this.clientAssertion = clientAssertion;
    }

    @Override
    public Set<String> getFormParameterNames() {
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("client_assertion", "client_assertion_type", "client_id")));
    }

    @Override
    public void applyTo(HTTPRequest hTTPRequest) {
        if (hTTPRequest.getMethod() != HTTPRequest.Method.POST) {
            throw new SerializeException("The HTTP request method must be POST");
        }
        ContentType contentType = hTTPRequest.getEntityContentType();
        if (contentType == null) {
            throw new SerializeException("Missing HTTP Content-Type header");
        }
        if (!contentType.matches(ContentType.APPLICATION_URLENCODED)) {
            throw new SerializeException("The HTTP Content-Type header must be " + ContentType.APPLICATION_URLENCODED);
        }
        Map<String, List<String>> map = hTTPRequest.getQueryParameters();
        map.putAll(this.toParameters());
        String string = URLUtils.serializeParameters(map);
        hTTPRequest.setQuery(string);
    }

    public Map<String, List<String>> toParameters() {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        try {
            hashMap.put("client_assertion", Collections.singletonList(this.clientAssertion.assertion()));
        }
        catch (IllegalStateException illegalStateException) {
            throw new SerializeException("Couldn't serialize JWT to a client assertion string: " + illegalStateException.getMessage(), illegalStateException);
        }
        hashMap.put("client_assertion_type", Collections.singletonList("urn:ietf:params:oauth:client-assertion-type:jwt-bearer"));
        hashMap.put("client_id", Collections.singletonList(this.getClientID().getValue()));
        return hashMap;
    }
}

