/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.net.URLDecoder;
import java.util.LinkedHashMap;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalClientException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.StringHelper;

class AuthorizationResult {
    private String code;
    private String state;
    private AuthorizationStatus status;
    private String error;
    private String errorDescription;
    private String environment;

    static AuthorizationResult fromResponseBody(String string) {
        if (StringHelper.isBlank(string)) {
            return new AuthorizationResult(AuthorizationStatus.UnknownError, "invalid_authorization_result", "The authorization server returned an invalid response: response is null or empty");
        }
        Map<String, String> map = AuthorizationResult.parseParameters(string);
        if (map.containsKey("error")) {
            return new AuthorizationResult(AuthorizationStatus.ProtocolError, map.get("error"), !StringHelper.isBlank(map.get("error_description")) ? map.get("error_description") : null);
        }
        if (!map.containsKey("code")) {
            return new AuthorizationResult(AuthorizationStatus.UnknownError, "invalid_authorization_result", "Authorization result response does not contain authorization code");
        }
        AuthorizationResult authorizationResult = new AuthorizationResult();
        authorizationResult.code = map.get("code");
        authorizationResult.status = AuthorizationStatus.Success;
        if (map.containsKey("cloud_instance_host_name")) {
            authorizationResult.environment = map.get("cloud_instance_host_name");
        }
        if (map.containsKey("state")) {
            authorizationResult.state = map.get("state");
        }
        return authorizationResult;
    }

    private AuthorizationResult() {
    }

    private AuthorizationResult(AuthorizationStatus authorizationStatus, String string, String string2) {
        this.status = authorizationStatus;
        this.error = string;
        this.errorDescription = string2;
    }

    private static Map<String, String> parseParameters(String string) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        try {
            String[] stringArray;
            for (String string2 : stringArray = string.split("&")) {
                int n2 = string2.indexOf("=");
                String string3 = URLDecoder.decode(string2.substring(0, n2), "UTF-8");
                String string4 = URLDecoder.decode(string2.substring(n2 + 1), "UTF-8");
                linkedHashMap.put(string3, string4);
            }
        }
        catch (Exception exception) {
            throw new MsalClientException("invalid_authorization_result", String.format("Error parsing authorization result:  %s", exception.getMessage()));
        }
        return linkedHashMap;
    }

    public String code() {
        return this.code;
    }

    public String state() {
        return this.state;
    }

    public AuthorizationStatus status() {
        return this.status;
    }

    public String error() {
        return this.error;
    }

    public String errorDescription() {
        return this.errorDescription;
    }

    public String environment() {
        return this.environment;
    }

    public AuthorizationResult code(String string) {
        this.code = string;
        return this;
    }

    public AuthorizationResult state(String string) {
        this.state = string;
        return this;
    }

    public AuthorizationResult status(AuthorizationStatus authorizationStatus) {
        this.status = authorizationStatus;
        return this;
    }

    public AuthorizationResult error(String string) {
        this.error = string;
        return this;
    }

    public AuthorizationResult errorDescription(String string) {
        this.errorDescription = string;
        return this;
    }

    public AuthorizationResult environment(String string) {
        this.environment = string;
        return this;
    }

    static enum AuthorizationStatus {
        Success,
        ProtocolError,
        UnknownError;

    }
}

