/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AcquireTokenByAuthorizationGrantSupplier;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AcquireTokenSilentSupplier;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthenticationResult;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthenticationResultSupplier;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ConfidentialClientApplication;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalClientException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.OnBehalfOfRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.PublicApi;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.RequestContext;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.SilentParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.SilentRequest;
import macromedia.jdbc.sqlserver.externals.org.slf4j.Logger;
import macromedia.jdbc.sqlserver.externals.org.slf4j.LoggerFactory;

class AcquireTokenByOnBehalfOfSupplier
extends AuthenticationResultSupplier {
    private static final Logger LOG = LoggerFactory.getLogger(AcquireTokenByOnBehalfOfSupplier.class);
    private OnBehalfOfRequest onBehalfOfRequest;

    AcquireTokenByOnBehalfOfSupplier(ConfidentialClientApplication confidentialClientApplication, OnBehalfOfRequest onBehalfOfRequest) {
        super(confidentialClientApplication, onBehalfOfRequest);
        this.onBehalfOfRequest = onBehalfOfRequest;
    }

    @Override
    AuthenticationResult execute() throws Exception {
        if (this.onBehalfOfRequest.parameters.skipCache() != null && !this.onBehalfOfRequest.parameters.skipCache().booleanValue()) {
            LOG.debug("SkipCache set to false. Attempting cache lookup");
            try {
                SilentParameters silentParameters = SilentParameters.builder(this.onBehalfOfRequest.parameters.scopes()).claims(this.onBehalfOfRequest.parameters.claims()).build();
                RequestContext requestContext = new RequestContext(this.clientApplication, PublicApi.ACQUIRE_TOKEN_SILENTLY, silentParameters);
                SilentRequest silentRequest = new SilentRequest(silentParameters, this.clientApplication, requestContext, this.onBehalfOfRequest.parameters.userAssertion());
                AcquireTokenSilentSupplier acquireTokenSilentSupplier = new AcquireTokenSilentSupplier(this.clientApplication, silentRequest);
                return acquireTokenSilentSupplier.execute();
            }
            catch (MsalClientException msalClientException) {
                LOG.debug(String.format("Cache lookup failed: %s", msalClientException.getMessage()));
                return this.acquireTokenOnBehalfOf();
            }
        }
        LOG.debug("SkipCache set to true. Skipping cache lookup and attempting on-behalf-of request");
        return this.acquireTokenOnBehalfOf();
    }

    private AuthenticationResult acquireTokenOnBehalfOf() throws Exception {
        AcquireTokenByAuthorizationGrantSupplier acquireTokenByAuthorizationGrantSupplier = new AcquireTokenByAuthorizationGrantSupplier(this.clientApplication, this.onBehalfOfRequest, null);
        return acquireTokenByAuthorizationGrantSupplier.execute();
    }
}

