/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.google.gson;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import macromedia.jdbc.sqlserver.externals.com.google.gson.JsonElement;
import macromedia.jdbc.sqlserver.externals.com.google.gson.JsonNull;
import macromedia.jdbc.sqlserver.externals.com.google.gson.JsonPrimitive;
import macromedia.jdbc.sqlserver.externals.com.google.gson.internal.NonNullElementWrapperList;

public final class JsonArray
extends JsonElement
implements Iterable<JsonElement> {
    private final ArrayList<JsonElement> elements;

    public JsonArray() {
        this.elements = new ArrayList();
    }

    public JsonArray(int n2) {
        this.elements = new ArrayList(n2);
    }

    @Override
    public JsonArray deepCopy() {
        if (!this.elements.isEmpty()) {
            JsonArray jsonArray = new JsonArray(this.elements.size());
            for (JsonElement jsonElement : this.elements) {
                jsonArray.add(jsonElement.deepCopy());
            }
            return jsonArray;
        }
        return new JsonArray();
    }

    public void add(Boolean bl2) {
        this.elements.add(bl2 == null ? JsonNull.INSTANCE : new JsonPrimitive(bl2));
    }

    public void add(Character c2) {
        this.elements.add(c2 == null ? JsonNull.INSTANCE : new JsonPrimitive(c2));
    }

    public void add(Number number) {
        this.elements.add(number == null ? JsonNull.INSTANCE : new JsonPrimitive(number));
    }

    public void add(String string) {
        this.elements.add(string == null ? JsonNull.INSTANCE : new JsonPrimitive(string));
    }

    public void add(JsonElement jsonElement) {
        if (jsonElement == null) {
            jsonElement = JsonNull.INSTANCE;
        }
        this.elements.add(jsonElement);
    }

    public void addAll(JsonArray jsonArray) {
        this.elements.addAll(jsonArray.elements);
    }

    public JsonElement set(int n2, JsonElement jsonElement) {
        return this.elements.set(n2, jsonElement == null ? JsonNull.INSTANCE : jsonElement);
    }

    public boolean remove(JsonElement jsonElement) {
        return this.elements.remove(jsonElement);
    }

    public JsonElement remove(int n2) {
        return this.elements.remove(n2);
    }

    public boolean contains(JsonElement jsonElement) {
        return this.elements.contains(jsonElement);
    }

    public int size() {
        return this.elements.size();
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public Iterator<JsonElement> iterator() {
        return this.elements.iterator();
    }

    public JsonElement get(int n2) {
        return this.elements.get(n2);
    }

    private JsonElement getAsSingleElement() {
        int n2 = this.elements.size();
        if (n2 == 1) {
            return this.elements.get(0);
        }
        throw new IllegalStateException("Array must have size 1, but has size " + n2);
    }

    @Override
    public Number getAsNumber() {
        return this.getAsSingleElement().getAsNumber();
    }

    @Override
    public String getAsString() {
        return this.getAsSingleElement().getAsString();
    }

    @Override
    public double getAsDouble() {
        return this.getAsSingleElement().getAsDouble();
    }

    @Override
    public BigDecimal getAsBigDecimal() {
        return this.getAsSingleElement().getAsBigDecimal();
    }

    @Override
    public BigInteger getAsBigInteger() {
        return this.getAsSingleElement().getAsBigInteger();
    }

    @Override
    public float getAsFloat() {
        return this.getAsSingleElement().getAsFloat();
    }

    @Override
    public long getAsLong() {
        return this.getAsSingleElement().getAsLong();
    }

    @Override
    public int getAsInt() {
        return this.getAsSingleElement().getAsInt();
    }

    @Override
    public byte getAsByte() {
        return this.getAsSingleElement().getAsByte();
    }

    @Override
    @Deprecated
    public char getAsCharacter() {
        return this.getAsSingleElement().getAsCharacter();
    }

    @Override
    public short getAsShort() {
        return this.getAsSingleElement().getAsShort();
    }

    @Override
    public boolean getAsBoolean() {
        return this.getAsSingleElement().getAsBoolean();
    }

    public List<JsonElement> asList() {
        return new NonNullElementWrapperList<JsonElement>(this.elements);
    }

    public boolean equals(Object object) {
        return object == this || object instanceof JsonArray && ((JsonArray)object).elements.equals(this.elements);
    }

    public int hashCode() {
        return this.elements.hashCode();
    }
}

