/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.deser.std;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.DeserializationConfig;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.DeserializationContext;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JavaType;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonMappingException;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.deser.ValueInstantiator;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.util.ClassUtil;

@JacksonStdImpl
public class StdValueInstantiator
extends ValueInstantiator
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final String _valueTypeDesc;
    protected final Class<?> _valueClass;
    protected AnnotatedWithParams _defaultCreator;
    protected AnnotatedWithParams _withArgsCreator;
    protected SettableBeanProperty[] _constructorArguments;
    protected JavaType _delegateType;
    protected AnnotatedWithParams _delegateCreator;
    protected SettableBeanProperty[] _delegateArguments;
    protected JavaType _arrayDelegateType;
    protected AnnotatedWithParams _arrayDelegateCreator;
    protected SettableBeanProperty[] _arrayDelegateArguments;
    protected AnnotatedWithParams _fromStringCreator;
    protected AnnotatedWithParams _fromIntCreator;
    protected AnnotatedWithParams _fromLongCreator;
    protected AnnotatedWithParams _fromBigIntegerCreator;
    protected AnnotatedWithParams _fromDoubleCreator;
    protected AnnotatedWithParams _fromBigDecimalCreator;
    protected AnnotatedWithParams _fromBooleanCreator;

    @Deprecated
    public StdValueInstantiator(DeserializationConfig deserializationConfig, Class<?> clazz) {
        this._valueTypeDesc = ClassUtil.nameOf(clazz);
        this._valueClass = clazz == null ? Object.class : clazz;
    }

    public StdValueInstantiator(DeserializationConfig deserializationConfig, JavaType javaType) {
        this._valueTypeDesc = javaType == null ? "UNKNOWN TYPE" : javaType.toString();
        this._valueClass = javaType == null ? Object.class : javaType.getRawClass();
    }

    protected StdValueInstantiator(StdValueInstantiator stdValueInstantiator) {
        this._valueTypeDesc = stdValueInstantiator._valueTypeDesc;
        this._valueClass = stdValueInstantiator._valueClass;
        this._defaultCreator = stdValueInstantiator._defaultCreator;
        this._constructorArguments = stdValueInstantiator._constructorArguments;
        this._withArgsCreator = stdValueInstantiator._withArgsCreator;
        this._delegateType = stdValueInstantiator._delegateType;
        this._delegateCreator = stdValueInstantiator._delegateCreator;
        this._delegateArguments = stdValueInstantiator._delegateArguments;
        this._arrayDelegateType = stdValueInstantiator._arrayDelegateType;
        this._arrayDelegateCreator = stdValueInstantiator._arrayDelegateCreator;
        this._arrayDelegateArguments = stdValueInstantiator._arrayDelegateArguments;
        this._fromStringCreator = stdValueInstantiator._fromStringCreator;
        this._fromIntCreator = stdValueInstantiator._fromIntCreator;
        this._fromLongCreator = stdValueInstantiator._fromLongCreator;
        this._fromBigIntegerCreator = stdValueInstantiator._fromBigIntegerCreator;
        this._fromDoubleCreator = stdValueInstantiator._fromDoubleCreator;
        this._fromBigDecimalCreator = stdValueInstantiator._fromBigDecimalCreator;
        this._fromBooleanCreator = stdValueInstantiator._fromBooleanCreator;
    }

    public void configureFromObjectSettings(AnnotatedWithParams annotatedWithParams, AnnotatedWithParams annotatedWithParams2, JavaType javaType, SettableBeanProperty[] settableBeanPropertyArray, AnnotatedWithParams annotatedWithParams3, SettableBeanProperty[] settableBeanPropertyArray2) {
        this._defaultCreator = annotatedWithParams;
        this._delegateCreator = annotatedWithParams2;
        this._delegateType = javaType;
        this._delegateArguments = settableBeanPropertyArray;
        this._withArgsCreator = annotatedWithParams3;
        this._constructorArguments = settableBeanPropertyArray2;
    }

    public void configureFromArraySettings(AnnotatedWithParams annotatedWithParams, JavaType javaType, SettableBeanProperty[] settableBeanPropertyArray) {
        this._arrayDelegateCreator = annotatedWithParams;
        this._arrayDelegateType = javaType;
        this._arrayDelegateArguments = settableBeanPropertyArray;
    }

    public void configureFromStringCreator(AnnotatedWithParams annotatedWithParams) {
        this._fromStringCreator = annotatedWithParams;
    }

    public void configureFromIntCreator(AnnotatedWithParams annotatedWithParams) {
        this._fromIntCreator = annotatedWithParams;
    }

    public void configureFromLongCreator(AnnotatedWithParams annotatedWithParams) {
        this._fromLongCreator = annotatedWithParams;
    }

    public void configureFromBigIntegerCreator(AnnotatedWithParams annotatedWithParams) {
        this._fromBigIntegerCreator = annotatedWithParams;
    }

    public void configureFromDoubleCreator(AnnotatedWithParams annotatedWithParams) {
        this._fromDoubleCreator = annotatedWithParams;
    }

    public void configureFromBigDecimalCreator(AnnotatedWithParams annotatedWithParams) {
        this._fromBigDecimalCreator = annotatedWithParams;
    }

    public void configureFromBooleanCreator(AnnotatedWithParams annotatedWithParams) {
        this._fromBooleanCreator = annotatedWithParams;
    }

    @Override
    public String getValueTypeDesc() {
        return this._valueTypeDesc;
    }

    @Override
    public Class<?> getValueClass() {
        return this._valueClass;
    }

    @Override
    public boolean canCreateFromString() {
        return this._fromStringCreator != null;
    }

    @Override
    public boolean canCreateFromInt() {
        return this._fromIntCreator != null;
    }

    @Override
    public boolean canCreateFromLong() {
        return this._fromLongCreator != null;
    }

    @Override
    public boolean canCreateFromBigInteger() {
        return this._fromBigIntegerCreator != null;
    }

    @Override
    public boolean canCreateFromDouble() {
        return this._fromDoubleCreator != null;
    }

    @Override
    public boolean canCreateFromBigDecimal() {
        return this._fromBigDecimalCreator != null;
    }

    @Override
    public boolean canCreateFromBoolean() {
        return this._fromBooleanCreator != null;
    }

    @Override
    public boolean canCreateUsingDefault() {
        return this._defaultCreator != null;
    }

    @Override
    public boolean canCreateUsingDelegate() {
        return this._delegateType != null;
    }

    @Override
    public boolean canCreateUsingArrayDelegate() {
        return this._arrayDelegateType != null;
    }

    @Override
    public boolean canCreateFromObjectWith() {
        return this._withArgsCreator != null;
    }

    @Override
    public boolean canInstantiate() {
        return this.canCreateUsingDefault() || this.canCreateUsingDelegate() || this.canCreateUsingArrayDelegate() || this.canCreateFromObjectWith() || this.canCreateFromString() || this.canCreateFromInt() || this.canCreateFromLong() || this.canCreateFromDouble() || this.canCreateFromBoolean();
    }

    @Override
    public JavaType getDelegateType(DeserializationConfig deserializationConfig) {
        return this._delegateType;
    }

    @Override
    public JavaType getArrayDelegateType(DeserializationConfig deserializationConfig) {
        return this._arrayDelegateType;
    }

    @Override
    public SettableBeanProperty[] getFromObjectArguments(DeserializationConfig deserializationConfig) {
        return this._constructorArguments;
    }

    @Override
    public Object createUsingDefault(DeserializationContext deserializationContext) throws IOException {
        if (this._defaultCreator == null) {
            return super.createUsingDefault(deserializationContext);
        }
        try {
            return this._defaultCreator.call();
        }
        catch (Exception exception) {
            return deserializationContext.handleInstantiationProblem(this._valueClass, null, this.rewrapCtorProblem(deserializationContext, exception));
        }
    }

    @Override
    public Object createFromObjectWith(DeserializationContext deserializationContext, Object[] objectArray) throws IOException {
        if (this._withArgsCreator == null) {
            return super.createFromObjectWith(deserializationContext, objectArray);
        }
        try {
            return this._withArgsCreator.call(objectArray);
        }
        catch (Exception exception) {
            return deserializationContext.handleInstantiationProblem(this._valueClass, objectArray, this.rewrapCtorProblem(deserializationContext, exception));
        }
    }

    @Override
    public Object createUsingDelegate(DeserializationContext deserializationContext, Object object) throws IOException {
        if (this._delegateCreator == null && this._arrayDelegateCreator != null) {
            return this._createUsingDelegate(this._arrayDelegateCreator, this._arrayDelegateArguments, deserializationContext, object);
        }
        return this._createUsingDelegate(this._delegateCreator, this._delegateArguments, deserializationContext, object);
    }

    @Override
    public Object createUsingArrayDelegate(DeserializationContext deserializationContext, Object object) throws IOException {
        if (this._arrayDelegateCreator == null && this._delegateCreator != null) {
            return this.createUsingDelegate(deserializationContext, object);
        }
        return this._createUsingDelegate(this._arrayDelegateCreator, this._arrayDelegateArguments, deserializationContext, object);
    }

    @Override
    public Object createFromString(DeserializationContext deserializationContext, String string) throws IOException {
        if (this._fromStringCreator != null) {
            try {
                return this._fromStringCreator.call1(string);
            }
            catch (Throwable throwable) {
                return deserializationContext.handleInstantiationProblem(this._fromStringCreator.getDeclaringClass(), string, this.rewrapCtorProblem(deserializationContext, throwable));
            }
        }
        return super.createFromString(deserializationContext, string);
    }

    @Override
    public Object createFromInt(DeserializationContext deserializationContext, int n2) throws IOException {
        if (this._fromIntCreator != null) {
            Integer n3 = n2;
            try {
                return this._fromIntCreator.call1(n3);
            }
            catch (Throwable throwable) {
                return deserializationContext.handleInstantiationProblem(this._fromIntCreator.getDeclaringClass(), n3, this.rewrapCtorProblem(deserializationContext, throwable));
            }
        }
        if (this._fromLongCreator != null) {
            Long l2 = n2;
            try {
                return this._fromLongCreator.call1(l2);
            }
            catch (Throwable throwable) {
                return deserializationContext.handleInstantiationProblem(this._fromLongCreator.getDeclaringClass(), l2, this.rewrapCtorProblem(deserializationContext, throwable));
            }
        }
        if (this._fromBigIntegerCreator != null) {
            BigInteger bigInteger = BigInteger.valueOf(n2);
            try {
                return this._fromBigIntegerCreator.call1(bigInteger);
            }
            catch (Throwable throwable) {
                return deserializationContext.handleInstantiationProblem(this._fromBigIntegerCreator.getDeclaringClass(), bigInteger, this.rewrapCtorProblem(deserializationContext, throwable));
            }
        }
        return super.createFromInt(deserializationContext, n2);
    }

    @Override
    public Object createFromLong(DeserializationContext deserializationContext, long l2) throws IOException {
        if (this._fromLongCreator != null) {
            Long l3 = l2;
            try {
                return this._fromLongCreator.call1(l3);
            }
            catch (Throwable throwable) {
                return deserializationContext.handleInstantiationProblem(this._fromLongCreator.getDeclaringClass(), l3, this.rewrapCtorProblem(deserializationContext, throwable));
            }
        }
        if (this._fromBigIntegerCreator != null) {
            BigInteger bigInteger = BigInteger.valueOf(l2);
            try {
                return this._fromBigIntegerCreator.call1(bigInteger);
            }
            catch (Throwable throwable) {
                return deserializationContext.handleInstantiationProblem(this._fromBigIntegerCreator.getDeclaringClass(), bigInteger, this.rewrapCtorProblem(deserializationContext, throwable));
            }
        }
        return super.createFromLong(deserializationContext, l2);
    }

    @Override
    public Object createFromBigInteger(DeserializationContext deserializationContext, BigInteger bigInteger) throws IOException {
        if (this._fromBigIntegerCreator != null) {
            try {
                return this._fromBigIntegerCreator.call1(bigInteger);
            }
            catch (Throwable throwable) {
                return deserializationContext.handleInstantiationProblem(this._fromBigIntegerCreator.getDeclaringClass(), bigInteger, this.rewrapCtorProblem(deserializationContext, throwable));
            }
        }
        return super.createFromBigInteger(deserializationContext, bigInteger);
    }

    @Override
    public Object createFromDouble(DeserializationContext deserializationContext, double d2) throws IOException {
        if (this._fromDoubleCreator != null) {
            Double d3 = d2;
            try {
                return this._fromDoubleCreator.call1(d3);
            }
            catch (Throwable throwable) {
                return deserializationContext.handleInstantiationProblem(this._fromDoubleCreator.getDeclaringClass(), d3, this.rewrapCtorProblem(deserializationContext, throwable));
            }
        }
        if (this._fromBigDecimalCreator != null) {
            BigDecimal bigDecimal = BigDecimal.valueOf(d2);
            try {
                return this._fromBigDecimalCreator.call1(bigDecimal);
            }
            catch (Throwable throwable) {
                return deserializationContext.handleInstantiationProblem(this._fromBigDecimalCreator.getDeclaringClass(), bigDecimal, this.rewrapCtorProblem(deserializationContext, throwable));
            }
        }
        return super.createFromDouble(deserializationContext, d2);
    }

    @Override
    public Object createFromBigDecimal(DeserializationContext deserializationContext, BigDecimal bigDecimal) throws IOException {
        Double d2;
        if (this._fromBigDecimalCreator != null) {
            try {
                return this._fromBigDecimalCreator.call1(bigDecimal);
            }
            catch (Throwable throwable) {
                return deserializationContext.handleInstantiationProblem(this._fromBigDecimalCreator.getDeclaringClass(), bigDecimal, this.rewrapCtorProblem(deserializationContext, throwable));
            }
        }
        if (this._fromDoubleCreator != null && (d2 = StdValueInstantiator.tryConvertToDouble(bigDecimal)) != null) {
            try {
                return this._fromDoubleCreator.call1(d2);
            }
            catch (Throwable throwable) {
                return deserializationContext.handleInstantiationProblem(this._fromDoubleCreator.getDeclaringClass(), d2, this.rewrapCtorProblem(deserializationContext, throwable));
            }
        }
        return super.createFromBigDecimal(deserializationContext, bigDecimal);
    }

    static Double tryConvertToDouble(BigDecimal bigDecimal) {
        double d2 = bigDecimal.doubleValue();
        return Double.isInfinite(d2) ? null : Double.valueOf(d2);
    }

    @Override
    public Object createFromBoolean(DeserializationContext deserializationContext, boolean bl2) throws IOException {
        if (this._fromBooleanCreator == null) {
            return super.createFromBoolean(deserializationContext, bl2);
        }
        Boolean bl3 = bl2;
        try {
            return this._fromBooleanCreator.call1(bl3);
        }
        catch (Throwable throwable) {
            return deserializationContext.handleInstantiationProblem(this._fromBooleanCreator.getDeclaringClass(), bl3, this.rewrapCtorProblem(deserializationContext, throwable));
        }
    }

    @Override
    public AnnotatedWithParams getDelegateCreator() {
        return this._delegateCreator;
    }

    @Override
    public AnnotatedWithParams getArrayDelegateCreator() {
        return this._arrayDelegateCreator;
    }

    @Override
    public AnnotatedWithParams getDefaultCreator() {
        return this._defaultCreator;
    }

    @Override
    public AnnotatedWithParams getWithArgsCreator() {
        return this._withArgsCreator;
    }

    @Deprecated
    protected JsonMappingException wrapException(Throwable throwable) {
        for (Throwable throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            if (!(throwable2 instanceof JsonMappingException)) continue;
            return (JsonMappingException)throwable2;
        }
        return new JsonMappingException(null, "Instantiation of " + this.getValueTypeDesc() + " value failed: " + ClassUtil.exceptionMessage(throwable), throwable);
    }

    @Deprecated
    protected JsonMappingException unwrapAndWrapException(DeserializationContext deserializationContext, Throwable throwable) {
        for (Throwable throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            if (!(throwable2 instanceof JsonMappingException)) continue;
            return (JsonMappingException)throwable2;
        }
        return deserializationContext.instantiationException(this.getValueClass(), throwable);
    }

    protected JsonMappingException wrapAsJsonMappingException(DeserializationContext deserializationContext, Throwable throwable) {
        if (throwable instanceof JsonMappingException) {
            return (JsonMappingException)throwable;
        }
        return deserializationContext.instantiationException(this.getValueClass(), throwable);
    }

    protected JsonMappingException rewrapCtorProblem(DeserializationContext deserializationContext, Throwable throwable) {
        Throwable throwable2;
        if ((throwable instanceof ExceptionInInitializerError || throwable instanceof InvocationTargetException) && (throwable2 = throwable.getCause()) != null) {
            throwable = throwable2;
        }
        return this.wrapAsJsonMappingException(deserializationContext, throwable);
    }

    private Object _createUsingDelegate(AnnotatedWithParams annotatedWithParams, SettableBeanProperty[] settableBeanPropertyArray, DeserializationContext deserializationContext, Object object) throws IOException {
        if (annotatedWithParams == null) {
            throw new IllegalStateException("No delegate constructor for " + this.getValueTypeDesc());
        }
        try {
            if (settableBeanPropertyArray == null) {
                return annotatedWithParams.call1(object);
            }
            int n2 = settableBeanPropertyArray.length;
            Object[] objectArray = new Object[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                SettableBeanProperty settableBeanProperty = settableBeanPropertyArray[i2];
                objectArray[i2] = settableBeanProperty == null ? object : deserializationContext.findInjectableValue(settableBeanProperty.getInjectableValueId(), settableBeanProperty, null);
            }
            return annotatedWithParams.call(objectArray);
        }
        catch (Throwable throwable) {
            throw this.rewrapCtorProblem(deserializationContext, throwable);
        }
    }
}

