/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.deser.std;

import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.DeserializationContext;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonDeserializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonMappingException;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.deser.std.AtomicBooleanDeserializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.deser.std.AtomicIntegerDeserializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.deser.std.AtomicLongDeserializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.deser.std.ByteBufferDeserializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.deser.std.NullifyingDeserializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.deser.std.StackTraceElementDeserializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.deser.std.UUIDDeserializer;

public class JdkDeserializers {
    private static final HashSet<String> _classNames;

    @Deprecated
    public static JsonDeserializer<?> find(Class<?> clazz, String string) throws JsonMappingException {
        return JdkDeserializers.find(null, clazz, string);
    }

    public static JsonDeserializer<?> find(DeserializationContext deserializationContext, Class<?> clazz, String string) throws JsonMappingException {
        if (_classNames.contains(string)) {
            FromStringDeserializer<?> fromStringDeserializer = FromStringDeserializer.findDeserializer(clazz);
            if (fromStringDeserializer != null) {
                return fromStringDeserializer;
            }
            if (clazz == UUID.class) {
                return new UUIDDeserializer();
            }
            if (clazz == StackTraceElement.class) {
                return StackTraceElementDeserializer.construct(deserializationContext);
            }
            if (clazz == AtomicBoolean.class) {
                return new AtomicBooleanDeserializer();
            }
            if (clazz == AtomicInteger.class) {
                return new AtomicIntegerDeserializer();
            }
            if (clazz == AtomicLong.class) {
                return new AtomicLongDeserializer();
            }
            if (clazz == ByteBuffer.class) {
                return new ByteBufferDeserializer();
            }
            if (clazz == Void.class) {
                return NullifyingDeserializer.instance;
            }
        }
        return null;
    }

    public static boolean hasDeserializerFor(Class<?> clazz) {
        return _classNames.contains(clazz.getName());
    }

    static {
        Class[] classArray;
        _classNames = new HashSet();
        for (Class clazz : classArray = new Class[]{UUID.class, AtomicBoolean.class, AtomicInteger.class, AtomicLong.class, StackTraceElement.class, ByteBuffer.class, Void.class}) {
            _classNames.add(clazz.getName());
        }
        for (Class clazz : FromStringDeserializer.types()) {
            _classNames.add(clazz.getName());
        }
    }
}

