/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.deser;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.BeanDescription;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.DeserializationConfig;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.DeserializationContext;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.DeserializationFeature;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JavaType;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonMappingException;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.cfg.CoercionAction;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.cfg.CoercionInputShape;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.type.LogicalType;

public abstract class ValueInstantiator {
    public ValueInstantiator createContextual(DeserializationContext deserializationContext, BeanDescription beanDescription) throws JsonMappingException {
        return this;
    }

    public Class<?> getValueClass() {
        return Object.class;
    }

    public String getValueTypeDesc() {
        Class<?> clazz = this.getValueClass();
        if (clazz == null) {
            return "UNKNOWN";
        }
        return clazz.getName();
    }

    public boolean canInstantiate() {
        return this.canCreateUsingDefault() || this.canCreateUsingDelegate() || this.canCreateUsingArrayDelegate() || this.canCreateFromObjectWith() || this.canCreateFromString() || this.canCreateFromInt() || this.canCreateFromLong() || this.canCreateFromDouble() || this.canCreateFromBoolean();
    }

    public boolean canCreateFromString() {
        return false;
    }

    public boolean canCreateFromInt() {
        return false;
    }

    public boolean canCreateFromLong() {
        return false;
    }

    public boolean canCreateFromBigInteger() {
        return false;
    }

    public boolean canCreateFromDouble() {
        return false;
    }

    public boolean canCreateFromBigDecimal() {
        return false;
    }

    public boolean canCreateFromBoolean() {
        return false;
    }

    public boolean canCreateUsingDefault() {
        return this.getDefaultCreator() != null;
    }

    public boolean canCreateUsingDelegate() {
        return false;
    }

    public boolean canCreateUsingArrayDelegate() {
        return false;
    }

    public boolean canCreateFromObjectWith() {
        return false;
    }

    public SettableBeanProperty[] getFromObjectArguments(DeserializationConfig deserializationConfig) {
        return null;
    }

    public JavaType getDelegateType(DeserializationConfig deserializationConfig) {
        return null;
    }

    public JavaType getArrayDelegateType(DeserializationConfig deserializationConfig) {
        return null;
    }

    public Object createUsingDefault(DeserializationContext deserializationContext) throws IOException {
        return deserializationContext.handleMissingInstantiator(this.getValueClass(), this, null, "no default no-arguments constructor found", new Object[0]);
    }

    public Object createFromObjectWith(DeserializationContext deserializationContext, Object[] objectArray) throws IOException {
        return deserializationContext.handleMissingInstantiator(this.getValueClass(), this, null, "no creator with arguments specified", new Object[0]);
    }

    public Object createFromObjectWith(DeserializationContext deserializationContext, SettableBeanProperty[] settableBeanPropertyArray, PropertyValueBuffer propertyValueBuffer) throws IOException {
        return this.createFromObjectWith(deserializationContext, propertyValueBuffer.getParameters(settableBeanPropertyArray));
    }

    public Object createUsingDelegate(DeserializationContext deserializationContext, Object object) throws IOException {
        return deserializationContext.handleMissingInstantiator(this.getValueClass(), this, null, "no delegate creator specified", new Object[0]);
    }

    public Object createUsingArrayDelegate(DeserializationContext deserializationContext, Object object) throws IOException {
        return deserializationContext.handleMissingInstantiator(this.getValueClass(), this, null, "no array delegate creator specified", new Object[0]);
    }

    public Object createFromString(DeserializationContext deserializationContext, String string) throws IOException {
        return deserializationContext.handleMissingInstantiator(this.getValueClass(), this, deserializationContext.getParser(), "no String-argument constructor/factory method to deserialize from String value ('%s')", string);
    }

    public Object createFromInt(DeserializationContext deserializationContext, int n2) throws IOException {
        return deserializationContext.handleMissingInstantiator(this.getValueClass(), this, null, "no int/Int-argument constructor/factory method to deserialize from Number value (%s)", n2);
    }

    public Object createFromLong(DeserializationContext deserializationContext, long l2) throws IOException {
        return deserializationContext.handleMissingInstantiator(this.getValueClass(), this, null, "no long/Long-argument constructor/factory method to deserialize from Number value (%s)", l2);
    }

    public Object createFromBigInteger(DeserializationContext deserializationContext, BigInteger bigInteger) throws IOException {
        return deserializationContext.handleMissingInstantiator(this.getValueClass(), this, null, "no BigInteger-argument constructor/factory method to deserialize from Number value (%s)", bigInteger);
    }

    public Object createFromDouble(DeserializationContext deserializationContext, double d2) throws IOException {
        return deserializationContext.handleMissingInstantiator(this.getValueClass(), this, null, "no double/Double-argument constructor/factory method to deserialize from Number value (%s)", d2);
    }

    public Object createFromBigDecimal(DeserializationContext deserializationContext, BigDecimal bigDecimal) throws IOException {
        return deserializationContext.handleMissingInstantiator(this.getValueClass(), this, null, "no BigDecimal/double/Double-argument constructor/factory method to deserialize from Number value (%s)", bigDecimal);
    }

    public Object createFromBoolean(DeserializationContext deserializationContext, boolean bl2) throws IOException {
        return deserializationContext.handleMissingInstantiator(this.getValueClass(), this, null, "no boolean/Boolean-argument constructor/factory method to deserialize from boolean value (%s)", bl2);
    }

    public AnnotatedWithParams getDefaultCreator() {
        return null;
    }

    public AnnotatedWithParams getDelegateCreator() {
        return null;
    }

    public AnnotatedWithParams getArrayDelegateCreator() {
        return null;
    }

    public AnnotatedWithParams getWithArgsCreator() {
        return null;
    }

    @Deprecated
    protected Object _createFromStringFallbacks(DeserializationContext deserializationContext, String string) throws IOException {
        if (string.isEmpty() && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT)) {
            return null;
        }
        if (this.canCreateFromBoolean() && deserializationContext.findCoercionAction(LogicalType.Boolean, Boolean.class, CoercionInputShape.String) == CoercionAction.TryConvert) {
            String string2 = string.trim();
            if ("true".equals(string2)) {
                return this.createFromBoolean(deserializationContext, true);
            }
            if ("false".equals(string2)) {
                return this.createFromBoolean(deserializationContext, false);
            }
        }
        return deserializationContext.handleMissingInstantiator(this.getValueClass(), this, deserializationContext.getParser(), "no String-argument constructor/factory method to deserialize from String value ('%s')", string);
    }

    public static class Delegating
    extends ValueInstantiator
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected final ValueInstantiator _delegate;

        protected Delegating(ValueInstantiator valueInstantiator) {
            this._delegate = valueInstantiator;
        }

        @Override
        public ValueInstantiator createContextual(DeserializationContext deserializationContext, BeanDescription beanDescription) throws JsonMappingException {
            ValueInstantiator valueInstantiator = this._delegate.createContextual(deserializationContext, beanDescription);
            return valueInstantiator == this._delegate ? this : new Delegating(valueInstantiator);
        }

        protected ValueInstantiator delegate() {
            return this._delegate;
        }

        @Override
        public Class<?> getValueClass() {
            return this.delegate().getValueClass();
        }

        @Override
        public String getValueTypeDesc() {
            return this.delegate().getValueTypeDesc();
        }

        @Override
        public boolean canInstantiate() {
            return this.delegate().canInstantiate();
        }

        @Override
        public boolean canCreateFromString() {
            return this.delegate().canCreateFromString();
        }

        @Override
        public boolean canCreateFromInt() {
            return this.delegate().canCreateFromInt();
        }

        @Override
        public boolean canCreateFromLong() {
            return this.delegate().canCreateFromLong();
        }

        @Override
        public boolean canCreateFromDouble() {
            return this.delegate().canCreateFromDouble();
        }

        @Override
        public boolean canCreateFromBoolean() {
            return this.delegate().canCreateFromBoolean();
        }

        @Override
        public boolean canCreateUsingDefault() {
            return this.delegate().canCreateUsingDefault();
        }

        @Override
        public boolean canCreateUsingDelegate() {
            return this.delegate().canCreateUsingDelegate();
        }

        @Override
        public boolean canCreateUsingArrayDelegate() {
            return this.delegate().canCreateUsingArrayDelegate();
        }

        @Override
        public boolean canCreateFromObjectWith() {
            return this.delegate().canCreateFromObjectWith();
        }

        @Override
        public SettableBeanProperty[] getFromObjectArguments(DeserializationConfig deserializationConfig) {
            return this.delegate().getFromObjectArguments(deserializationConfig);
        }

        @Override
        public JavaType getDelegateType(DeserializationConfig deserializationConfig) {
            return this.delegate().getDelegateType(deserializationConfig);
        }

        @Override
        public JavaType getArrayDelegateType(DeserializationConfig deserializationConfig) {
            return this.delegate().getArrayDelegateType(deserializationConfig);
        }

        @Override
        public Object createUsingDefault(DeserializationContext deserializationContext) throws IOException {
            return this.delegate().createUsingDefault(deserializationContext);
        }

        @Override
        public Object createFromObjectWith(DeserializationContext deserializationContext, Object[] objectArray) throws IOException {
            return this.delegate().createFromObjectWith(deserializationContext, objectArray);
        }

        @Override
        public Object createFromObjectWith(DeserializationContext deserializationContext, SettableBeanProperty[] settableBeanPropertyArray, PropertyValueBuffer propertyValueBuffer) throws IOException {
            return this.delegate().createFromObjectWith(deserializationContext, settableBeanPropertyArray, propertyValueBuffer);
        }

        @Override
        public Object createUsingDelegate(DeserializationContext deserializationContext, Object object) throws IOException {
            return this.delegate().createUsingDelegate(deserializationContext, object);
        }

        @Override
        public Object createUsingArrayDelegate(DeserializationContext deserializationContext, Object object) throws IOException {
            return this.delegate().createUsingArrayDelegate(deserializationContext, object);
        }

        @Override
        public Object createFromString(DeserializationContext deserializationContext, String string) throws IOException {
            return this.delegate().createFromString(deserializationContext, string);
        }

        @Override
        public Object createFromInt(DeserializationContext deserializationContext, int n2) throws IOException {
            return this.delegate().createFromInt(deserializationContext, n2);
        }

        @Override
        public Object createFromLong(DeserializationContext deserializationContext, long l2) throws IOException {
            return this.delegate().createFromLong(deserializationContext, l2);
        }

        @Override
        public Object createFromBigInteger(DeserializationContext deserializationContext, BigInteger bigInteger) throws IOException {
            return this.delegate().createFromBigInteger(deserializationContext, bigInteger);
        }

        @Override
        public Object createFromDouble(DeserializationContext deserializationContext, double d2) throws IOException {
            return this.delegate().createFromDouble(deserializationContext, d2);
        }

        @Override
        public Object createFromBigDecimal(DeserializationContext deserializationContext, BigDecimal bigDecimal) throws IOException {
            return this.delegate().createFromBigDecimal(deserializationContext, bigDecimal);
        }

        @Override
        public Object createFromBoolean(DeserializationContext deserializationContext, boolean bl2) throws IOException {
            return this.delegate().createFromBoolean(deserializationContext, bl2);
        }

        @Override
        public AnnotatedWithParams getDefaultCreator() {
            return this.delegate().getDefaultCreator();
        }

        @Override
        public AnnotatedWithParams getDelegateCreator() {
            return this.delegate().getDelegateCreator();
        }

        @Override
        public AnnotatedWithParams getArrayDelegateCreator() {
            return this.delegate().getArrayDelegateCreator();
        }

        @Override
        public AnnotatedWithParams getWithArgsCreator() {
            return this.delegate().getWithArgsCreator();
        }
    }

    public static class Base
    extends ValueInstantiator
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected final Class<?> _valueType;

        public Base(Class<?> clazz) {
            this._valueType = clazz;
        }

        public Base(JavaType javaType) {
            this._valueType = javaType.getRawClass();
        }

        @Override
        public String getValueTypeDesc() {
            return this._valueType.getName();
        }

        @Override
        public Class<?> getValueClass() {
            return this._valueType;
        }
    }

    public static interface Gettable {
        public ValueInstantiator getValueInstantiator();
    }
}

