/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.deser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonFactory;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonParser;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.format.InputAccessor;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.format.MatchStrength;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.io.MergedStream;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.DeserializationConfig;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JavaType;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ObjectReader;

public class DataFormatReaders {
    public static final int DEFAULT_MAX_INPUT_LOOKAHEAD = 64;
    protected final ObjectReader[] _readers;
    protected final MatchStrength _optimalMatch;
    protected final MatchStrength _minimalMatch;
    protected final int _maxInputLookahead;

    public DataFormatReaders(ObjectReader ... objectReaderArray) {
        this(objectReaderArray, MatchStrength.SOLID_MATCH, MatchStrength.WEAK_MATCH, 64);
    }

    public DataFormatReaders(Collection<ObjectReader> collection) {
        this(collection.toArray(new ObjectReader[collection.size()]));
    }

    private DataFormatReaders(ObjectReader[] objectReaderArray, MatchStrength matchStrength, MatchStrength matchStrength2, int n2) {
        this._readers = objectReaderArray;
        this._optimalMatch = matchStrength;
        this._minimalMatch = matchStrength2;
        this._maxInputLookahead = n2;
    }

    public DataFormatReaders withOptimalMatch(MatchStrength matchStrength) {
        if (matchStrength == this._optimalMatch) {
            return this;
        }
        return new DataFormatReaders(this._readers, matchStrength, this._minimalMatch, this._maxInputLookahead);
    }

    public DataFormatReaders withMinimalMatch(MatchStrength matchStrength) {
        if (matchStrength == this._minimalMatch) {
            return this;
        }
        return new DataFormatReaders(this._readers, this._optimalMatch, matchStrength, this._maxInputLookahead);
    }

    public DataFormatReaders with(ObjectReader[] objectReaderArray) {
        return new DataFormatReaders(objectReaderArray, this._optimalMatch, this._minimalMatch, this._maxInputLookahead);
    }

    public DataFormatReaders withMaxInputLookahead(int n2) {
        if (n2 == this._maxInputLookahead) {
            return this;
        }
        return new DataFormatReaders(this._readers, this._optimalMatch, this._minimalMatch, n2);
    }

    public DataFormatReaders with(DeserializationConfig deserializationConfig) {
        int n2 = this._readers.length;
        ObjectReader[] objectReaderArray = new ObjectReader[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            objectReaderArray[i2] = this._readers[i2].with(deserializationConfig);
        }
        return new DataFormatReaders(objectReaderArray, this._optimalMatch, this._minimalMatch, this._maxInputLookahead);
    }

    public DataFormatReaders withType(JavaType javaType) {
        int n2 = this._readers.length;
        ObjectReader[] objectReaderArray = new ObjectReader[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            objectReaderArray[i2] = this._readers[i2].forType(javaType);
        }
        return new DataFormatReaders(objectReaderArray, this._optimalMatch, this._minimalMatch, this._maxInputLookahead);
    }

    public Match findFormat(InputStream inputStream) throws IOException {
        return this._findFormat(new AccessorForReader(inputStream, new byte[this._maxInputLookahead]));
    }

    public Match findFormat(byte[] byArray) throws IOException {
        return this._findFormat(new AccessorForReader(byArray));
    }

    public Match findFormat(byte[] byArray, int n2, int n3) throws IOException {
        return this._findFormat(new AccessorForReader(byArray, n2, n3));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n2 = this._readers.length;
        if (n2 > 0) {
            stringBuilder.append(this._readers[0].getFactory().getFormatName());
            for (int i2 = 1; i2 < n2; ++i2) {
                stringBuilder.append(", ");
                stringBuilder.append(this._readers[i2].getFactory().getFormatName());
            }
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private Match _findFormat(AccessorForReader accessorForReader) throws IOException {
        ObjectReader objectReader = null;
        Enum enum_ = null;
        for (ObjectReader objectReader2 : this._readers) {
            accessorForReader.reset();
            MatchStrength matchStrength = objectReader2.getFactory().hasFormat(accessorForReader);
            if (matchStrength == null || matchStrength.ordinal() < this._minimalMatch.ordinal() || objectReader != null && enum_.ordinal() >= matchStrength.ordinal()) continue;
            objectReader = objectReader2;
            enum_ = matchStrength;
            if (matchStrength.ordinal() >= this._optimalMatch.ordinal()) break;
        }
        return accessorForReader.createMatcher(objectReader, (MatchStrength)enum_);
    }

    public static class Match {
        protected final InputStream _originalStream;
        protected final byte[] _bufferedData;
        protected final int _bufferedStart;
        protected final int _bufferedLength;
        protected final ObjectReader _match;
        protected final MatchStrength _matchStrength;

        protected Match(InputStream inputStream, byte[] byArray, int n2, int n3, ObjectReader objectReader, MatchStrength matchStrength) {
            this._originalStream = inputStream;
            this._bufferedData = byArray;
            this._bufferedStart = n2;
            this._bufferedLength = n3;
            this._match = objectReader;
            this._matchStrength = matchStrength;
        }

        public boolean hasMatch() {
            return this._match != null;
        }

        public MatchStrength getMatchStrength() {
            return this._matchStrength == null ? MatchStrength.INCONCLUSIVE : this._matchStrength;
        }

        public ObjectReader getReader() {
            return this._match;
        }

        public String getMatchedFormatName() {
            return this._match.getFactory().getFormatName();
        }

        public JsonParser createParserWithMatch() throws IOException {
            if (this._match == null) {
                return null;
            }
            JsonFactory jsonFactory = this._match.getFactory();
            if (this._originalStream == null) {
                return jsonFactory.createParser(this._bufferedData, this._bufferedStart, this._bufferedLength);
            }
            return jsonFactory.createParser(this.getDataStream());
        }

        public InputStream getDataStream() {
            if (this._originalStream == null) {
                return new ByteArrayInputStream(this._bufferedData, this._bufferedStart, this._bufferedLength);
            }
            return new MergedStream(null, this._originalStream, this._bufferedData, this._bufferedStart, this._bufferedLength);
        }
    }

    protected static class AccessorForReader
    extends InputAccessor.Std {
        public AccessorForReader(InputStream inputStream, byte[] byArray) {
            super(inputStream, byArray);
        }

        public AccessorForReader(byte[] byArray) {
            super(byArray);
        }

        public AccessorForReader(byte[] byArray, int n2, int n3) {
            super(byArray, n2, n3);
        }

        public Match createMatcher(ObjectReader objectReader, MatchStrength matchStrength) {
            return new Match(this._in, this._buffer, this._bufferedStart, this._bufferedEnd - this._bufferedStart, objectReader, matchStrength);
        }
    }
}

