/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.slbase;

import java.sql.SQLException;
import macromedia.jdbc.slbase.BaseConnection;
import macromedia.jdbc.slbase.BaseImplConnection;
import macromedia.jdbc.slbase.BaseMessages;
import macromedia.jdbc.slbase.BaseSQLException;
import macromedia.slutil.UtilDebug;
import macromedia.slutil.UtilException;
import macromedia.slutil.UtilResource;

public final class BaseExceptions {
    public static final String generalErrorSqlState = "HY000";
    protected BaseMessages baseMessages;
    protected boolean useUnsyncLogging = false;
    public static final int ADD_AT_BEGINNING = 0;
    public static final int ADD_AT_END = 1;
    private boolean returnVendorCode = false;
    private BaseConnection connection = null;

    public BaseExceptions(String string) throws SQLException {
        this.baseMessages = new BaseMessages(string);
        this.returnVendorCode = this.returnVendorCode(string);
    }

    public BaseExceptions(BaseMessages baseMessages, boolean bl2) throws SQLException {
        this.baseMessages = baseMessages;
        this.returnVendorCode = bl2;
    }

    public final BaseMessages getMessages() {
        return this.baseMessages;
    }

    public final boolean getReturnVendorCode() {
        return this.returnVendorCode;
    }

    public final void setConnection(BaseConnection baseConnection) {
        this.connection = baseConnection;
    }

    public SQLException getException(SQLException sQLException, int n2, int n3, String[] stringArray, String string, int n4) {
        SQLException sQLException2 = this.createException(this.baseMessages.getMessage(n3, stringArray, true), string, n4);
        return this.chainExceptions(sQLException, sQLException2, n2);
    }

    public SQLException getException(SQLException sQLException, int n2, int n3, String[] stringArray, String string) {
        SQLException sQLException2 = this.returnVendorCode ? this.createException(this.baseMessages.getMessage(n3, stringArray, false), string, n3) : this.createException(this.baseMessages.getMessage(n3, stringArray, false), string);
        return this.chainExceptions(sQLException, sQLException2, n2);
    }

    public SQLException getException(SQLException sQLException, int n2, int n3, String string) {
        SQLException sQLException2 = this.returnVendorCode ? this.createException(this.baseMessages.getMessage(n3, null, false), string, n3) : this.createException(this.baseMessages.getMessage(n3, null, false), string);
        return this.chainExceptions(sQLException, sQLException2, n2);
    }

    public SQLException getException(SQLException sQLException, int n2, int n3, String[] stringArray) {
        SQLException sQLException2 = this.returnVendorCode ? this.createException(this.baseMessages.getMessage(n3, stringArray, false), generalErrorSqlState, n3) : this.createException(this.baseMessages.getMessage(n3, stringArray, false), generalErrorSqlState);
        return this.chainExceptions(sQLException, sQLException2, n2);
    }

    public SQLException getException(SQLException sQLException, int n2, int n3) {
        SQLException sQLException2 = this.returnVendorCode ? this.createException(this.baseMessages.getMessage(n3, null, false), generalErrorSqlState, n3) : this.createException(this.baseMessages.getMessage(n3, null, false), generalErrorSqlState);
        return this.chainExceptions(sQLException, sQLException2, n2);
    }

    public SQLException getException(SQLException sQLException, int n2, String[] stringArray, String string, int n3) {
        return this.getException(sQLException, 0, n2, stringArray, string, n3);
    }

    public SQLException getException(SQLException sQLException, int n2, String[] stringArray, String string) {
        return this.getException(sQLException, 0, n2, stringArray, string);
    }

    public SQLException getException(SQLException sQLException, int n2, String string) {
        return this.getException(sQLException, 0, n2, string);
    }

    public SQLException getException(SQLException sQLException, int n2, String[] stringArray) {
        return this.getException(sQLException, 0, n2, stringArray);
    }

    public SQLException getException(SQLException sQLException, int n2) {
        return this.getException(sQLException, 0, n2);
    }

    public SQLException getException(int n2, String[] stringArray, String string, int n3) {
        SQLException sQLException = this.createException(this.baseMessages.getMessage(n2, stringArray, true), string, n3);
        return sQLException;
    }

    public SQLException getException(int n2, String[] stringArray, String string) {
        SQLException sQLException = this.returnVendorCode ? this.createException(this.baseMessages.getMessage(n2, stringArray, false), string, n2) : this.createException(this.baseMessages.getMessage(n2, stringArray, false), string);
        return sQLException;
    }

    public SQLException getException(int n2, String string) {
        SQLException sQLException = this.returnVendorCode ? this.createException(this.baseMessages.getMessage(n2, null, false), string, n2) : this.createException(this.baseMessages.getMessage(n2, null, false), string);
        return sQLException;
    }

    public SQLException getException(int n2, String[] stringArray) {
        SQLException sQLException = this.returnVendorCode ? this.createException(this.baseMessages.getMessage(n2, stringArray, false), generalErrorSqlState, n2) : this.createException(this.baseMessages.getMessage(n2, stringArray, false), generalErrorSqlState);
        return sQLException;
    }

    public SQLException getException(int n2) {
        SQLException sQLException = this.returnVendorCode ? this.createException(this.baseMessages.getMessage(n2, null, false), generalErrorSqlState, n2) : this.createException(this.baseMessages.getMessage(n2, null, false), generalErrorSqlState);
        return sQLException;
    }

    public SQLException getException(Exception exception) {
        SQLException sQLException;
        boolean bl2 = false;
        int n2 = -1;
        boolean bl3 = false;
        if (exception instanceof UtilException) {
            bl2 = true;
            n2 = ((UtilException)exception).getReason();
            bl3 = ((UtilException)exception).wasSocketGenerated();
        }
        if (n2 == 1018) {
            sQLException = this.getException(exception, "08S01");
        } else if (n2 == 1001) {
            sQLException = this.getException(exception, "08006");
        } else {
            if (n2 == 1029) {
                return new BaseSQLException("SOCKETTIMEOUT");
            }
            sQLException = bl3 ? this.getException(exception, "08S01") : (bl2 && this.returnVendorCode ? this.createException(this.baseMessages.formatMessage(exception.getMessage(), null, false), generalErrorSqlState, ((UtilException)exception).getReason()) : this.createException(this.baseMessages.formatMessage(exception.getMessage(), null, false), generalErrorSqlState));
        }
        return sQLException;
    }

    public SQLException getException(Exception exception, String string) {
        boolean bl2 = false;
        int n2 = -1;
        boolean bl3 = false;
        if (exception instanceof UtilException) {
            bl2 = true;
            n2 = ((UtilException)exception).getReason();
            bl3 = ((UtilException)exception).wasSocketGenerated();
        }
        if (n2 == 1029) {
            return new BaseSQLException("SOCKETTIMEOUT");
        }
        SQLException sQLException = bl3 ? this.createException(this.baseMessages.formatMessage(exception.getMessage(), null, false), "08S01") : (bl2 && this.returnVendorCode ? this.createException(this.baseMessages.formatMessage(exception.getMessage(), null, false), string, ((UtilException)exception).getReason()) : this.createException(this.baseMessages.formatMessage(exception.getMessage(), null, false), string));
        return sQLException;
    }

    public SQLException getException(Exception exception, String string, int n2) {
        boolean bl2 = false;
        int n3 = -1;
        if (exception instanceof UtilException) {
            bl2 = true;
            n3 = ((UtilException)exception).getReason();
        }
        if (n3 == 1029) {
            return new BaseSQLException("SOCKETTIMEOUT");
        }
        SQLException sQLException = this.createException(this.baseMessages.formatMessage(exception.getMessage(), null, false), string, n2);
        return sQLException;
    }

    public void setUnsyncLogExceptions(boolean bl2) {
        this.useUnsyncLogging = bl2;
    }

    public boolean getUnsyncLogExceptions() {
        return this.useUnsyncLogging;
    }

    private SQLException chainExceptions(SQLException sQLException, SQLException sQLException2, int n2) {
        SQLException sQLException3 = sQLException2;
        if (sQLException != null) {
            if (n2 == 0) {
                sQLException2.setNextException(sQLException);
                sQLException3 = sQLException2;
            } else {
                UtilDebug._assert("Bad chain value specified", n2 == 1);
                sQLException.setNextException(sQLException2);
                sQLException3 = sQLException;
            }
        }
        return sQLException3;
    }

    private SQLException createException(String string, String string2, int n2) {
        BaseImplConnection baseImplConnection;
        if (this.connection != null && string2.startsWith("08") && (baseImplConnection = this.connection.implConnection) != null) {
            baseImplConnection.setConnectionStatus(1);
        }
        if (this.useUnsyncLogging) {
            return new BaseSQLException(string, string2, n2);
        }
        return new SQLException(string, string2, n2);
    }

    private SQLException createException(String string, String string2) {
        BaseImplConnection baseImplConnection;
        if (this.connection != null && string2.startsWith("08") && (baseImplConnection = this.connection.implConnection) != null) {
            baseImplConnection.setConnectionStatus(1);
        }
        if (this.useUnsyncLogging) {
            return new BaseSQLException(string, string2);
        }
        return new SQLException(string, string2);
    }

    private boolean returnVendorCode(String string) throws SQLException {
        String string2 = string.toLowerCase();
        try {
            String string3 = new UtilResource(Class.forName("macromedia.jdbc." + string2 + "." + string + "Connection"), string2 + ".properties").getAsProperties().getProperty("returnVendorCode", "false");
            if (string3.equalsIgnoreCase("true")) {
                return true;
            }
        }
        catch (UtilException utilException) {
            throw this.getException(utilException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }
}

