/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sequelink.columns;

import java.io.IOException;
import java.sql.SQLException;
import java.sql.Time;
import macromedia.jdbc.sequelink.columns.SequeLinkColumnDescribe;
import macromedia.jdbc.sequelink.columns.SequeLinkDateTimeColumn;
import macromedia.jdbc.sequelink.utilities.BooleanArray;
import macromedia.jdbc.sequelink.utilities.IntArray;
import macromedia.jdbc.slbase.BaseData;
import macromedia.jdbc.slbase.BaseTimestamp;
import macromedia.sequelink.ctxt.stmt.StatementContext;
import macromedia.sequelink.ssp.DiagnosticList;
import macromedia.sequelink.ssp.SspInputStream;
import macromedia.slutil.UtilException;

public class SequeLinkTimeColumn
extends SequeLinkDateTimeColumn {
    private IntArray array;
    private BooleanArray isNull;

    public SequeLinkTimeColumn(StatementContext statementContext, SequeLinkColumnDescribe sequeLinkColumnDescribe, int n2) throws SQLException {
        super(statementContext, sequeLinkColumnDescribe, n2, 12);
        this.out = new char[19];
        this.array = new IntArray();
        this.isNull = new BooleanArray();
    }

    protected void setBindInfo() {
        this.sqlnkType = 8;
        this.sqlnkSize = 3;
    }

    protected void readDataFromStream(SspInputStream sspInputStream) throws IOException, UtilException {
        int n2 = sspInputStream.readSSPInt8();
        n2 <<= 6;
        n2 |= sspInputStream.readSSPInt8();
        n2 <<= 6;
        this.array.add(n2 |= sspInputStream.readSSPInt8());
        this.isNull.add(false);
    }

    protected void readNull() {
        this.array.add(0);
        this.isNull.add(true);
    }

    public void clearData() {
        this.array.reset();
        this.isNull.reset();
    }

    public BaseData getData(int n2, int n3, DiagnosticList diagnosticList) throws SQLException {
        if (this.isNull.get(n3)) {
            this.myBaseData.setNull(this.baseDataType);
            return this.myBaseData;
        }
        int n4 = this.array.get(n3);
        int n5 = n4 & 0x3F;
        int n6 = (n4 >>= 6) & 0x3F;
        int n7 = n4 >>= 6;
        switch (n2) {
            case 12: {
                Time time = new Time(n7, n6, n5);
                this.myBaseData.setTime(time);
                break;
            }
            case 10: {
                String string = this.getTimeString(n7, n6, n5);
                this.myBaseData.setString(string);
                break;
            }
            case 13: {
                BaseTimestamp baseTimestamp = new BaseTimestamp(70, 0, 1, n7, n6, n5, 0, null);
                this.myBaseData.setTimestamp(baseTimestamp);
                break;
            }
            default: {
                Time time = new Time(n7, n6, n5);
                this.myBaseData.setTime(time);
            }
        }
        return this.myBaseData;
    }

    private String getTimeString(int n2, int n3, int n4) throws SQLException {
        this.pos = 0;
        this.writeInt(n2, 2);
        this.out[this.pos++] = 58;
        this.writeInt(n3, 2);
        this.out[this.pos++] = 58;
        this.writeInt(n4, 2);
        return new String(this.out, 0, this.pos);
    }
}

