/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.math.BigDecimal;
import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.JRAbstractExtendedIncrementer;
import net.sf.jasperreports.engine.fill.JRBigDecimalIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRCalculable;

class JRBigDecimalSumIncrementer
extends JRAbstractExtendedIncrementer {
    private static JRBigDecimalSumIncrementer mainInstance = new JRBigDecimalSumIncrementer();

    private JRBigDecimalSumIncrementer() {
    }

    public static JRBigDecimalSumIncrementer getInstance() {
        return mainInstance;
    }

    @Override
    public Object increment(JRCalculable variable, Object expressionValue, AbstractValueProvider valueProvider) {
        BigDecimal value = (BigDecimal)variable.getIncrementedValue();
        BigDecimal newValue = (BigDecimal)expressionValue;
        if (newValue == null) {
            if (variable.isInitialized()) {
                return null;
            }
            return value;
        }
        if (value == null) {
            value = variable.getValue() == null ? JRBigDecimalIncrementerFactory.ZERO : (BigDecimal)variable.getValue();
        }
        return value.add(newValue);
    }

    @Override
    public Object initialValue(JRCalculable variable) {
        if (variable.getValue() == null) {
            return JRBigDecimalIncrementerFactory.ZERO;
        }
        return (BigDecimal)variable.getValue();
    }
}

