/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.util;

import org.smpp.SmppObject;

public abstract class ProcessingThread
extends SmppObject
implements Runnable {
    private static final String PROCESSING_THREAD_NAME = "ProcThread";
    private static int threadIndex = 0;
    private boolean keepProcessing = true;
    private byte processingStatus = 0;
    private static final byte PROC_INITIALISING = 0;
    private static final byte PROC_RECEIVING = 1;
    private static final byte PROC_FINISHED = 2;
    private Object processingStatusLock = new Object();
    private Exception termException = null;
    private Thread processingThread = null;

    public abstract void process();

    public void start() {
        debug.enter(9, this, "start()");
        if (!this.isProcessing()) {
            this.setProcessingStatus((byte)0);
            this.termException = null;
            this.keepProcessing = true;
            this.processingThread = new Thread(this);
            this.processingThread.setName(this.generateIndexedThreadName());
            this.processingThread.start();
            while (this.isInitialising()) {
                Thread.yield();
            }
        }
        debug.exit(9, this);
    }

    public void stop() {
        debug.enter(9, this, "stop()");
        if (this.isProcessing()) {
            this.stopProcessing(null);
            this.processingThread.interrupt();
            while (!this.isFinished()) {
                Thread.yield();
            }
        }
        debug.exit(9, this);
    }

    protected void stopProcessing(Exception e) {
        this.setTermException(e);
        this.keepProcessing = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        debug.enter(9, this, "run()");
        try {
            this.setProcessingStatus((byte)1);
            while (this.keepProcessing) {
                this.process();
                Thread.yield();
            }
        }
        catch (Exception e) {
            this.setTermException(e);
            debug.write("ProcessingThread.run() caught unhadled exception " + e);
            event.write(e, "ProcessingThread.run() unhadled exception");
        }
        finally {
            this.setProcessingStatus((byte)2);
            debug.exit(9, this);
        }
    }

    public String getThreadName() {
        return PROCESSING_THREAD_NAME;
    }

    public int getThreadIndex() {
        return ++threadIndex;
    }

    public String generateIndexedThreadName() {
        return this.getThreadName() + "-" + this.getThreadIndex();
    }

    protected void setTermException(Exception e) {
        this.termException = e;
    }

    public Exception getTermException() {
        return this.termException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setProcessingStatus(byte value) {
        Object object = this.processingStatusLock;
        synchronized (object) {
            this.processingStatus = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isInitialising() {
        Object object = this.processingStatusLock;
        synchronized (object) {
            return this.processingStatus == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isProcessing() {
        Object object = this.processingStatusLock;
        synchronized (object) {
            return this.processingStatus == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isFinished() {
        Object object = this.processingStatusLock;
        synchronized (object) {
            return this.processingStatus == 2;
        }
    }
}

