/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.smscsim;

import java.io.IOException;
import org.smpp.Connection;
import org.smpp.Receiver;
import org.smpp.SmppObject;
import org.smpp.Transmitter;
import org.smpp.pdu.PDU;
import org.smpp.pdu.PDUException;
import org.smpp.pdu.Request;
import org.smpp.pdu.Response;
import org.smpp.smscsim.PDUProcessor;

public class SMSCSession
extends SmppObject
implements Runnable {
    private Receiver receiver;
    private Transmitter transmitter;
    private PDUProcessor pduProcessor;
    private Connection connection;
    private long receiveTimeout = 60000L;
    private boolean keepReceiving = true;
    private boolean isReceiving = false;
    private int timeoutCntr = 0;

    public SMSCSession(Connection connection) {
        this.connection = connection;
        this.transmitter = new Transmitter(connection);
        this.receiver = new Receiver(this.transmitter, connection);
    }

    public void stop() {
        debug.write("SMSCSession stopping");
        this.keepReceiving = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        PDU pdu = null;
        debug.enter(this, "SMSCSession run()");
        debug.write("SMSCSession starting receiver");
        this.receiver.start();
        this.isReceiving = true;
        try {
            while (this.keepReceiving) {
                try {
                    debug.write("SMSCSession going to receive a PDU");
                    pdu = this.receiver.receive(this.getReceiveTimeout());
                }
                catch (Exception e) {
                    debug.write("SMSCSession caught exception receiving PDU " + e.getMessage());
                }
                if (pdu != null) {
                    this.timeoutCntr = 0;
                    if (pdu.isRequest()) {
                        debug.write("SMSCSession got request " + pdu.debugString());
                        this.pduProcessor.clientRequest((Request)pdu);
                        continue;
                    }
                    if (pdu.isResponse()) {
                        debug.write("SMSCSession got response " + pdu.debugString());
                        this.pduProcessor.clientResponse((Response)pdu);
                        continue;
                    }
                    debug.write("SMSCSession not reqest nor response => not doing anything.");
                    continue;
                }
                ++this.timeoutCntr;
                if (this.timeoutCntr <= 5) continue;
                debug.write("SMSCSession stoped due to inactivity");
                this.stop();
            }
        }
        finally {
            this.isReceiving = false;
        }
        debug.write("SMSCSession stopping receiver");
        this.receiver.stop();
        debug.write("SMSCSession exiting PDUProcessor");
        this.pduProcessor.exit();
        try {
            debug.write("SMSCSession closing connection");
            this.connection.close();
        }
        catch (IOException e) {
            event.write(e, "closing SMSCSession's connection.");
        }
        debug.write("SMSCSession exiting run()");
        debug.exit(this);
    }

    public void send(PDU pdu) throws IOException, PDUException {
        this.timeoutCntr = 0;
        debug.write("SMSCSession going to send pdu over transmitter");
        this.transmitter.send(pdu);
        debug.write("SMSCSession pdu sent over transmitter");
    }

    public void setPDUProcessor(PDUProcessor pduProcessor) {
        this.pduProcessor = pduProcessor;
    }

    public void setReceiveTimeout(long timeout) {
        this.receiveTimeout = timeout;
    }

    public long getReceiveTimeout() {
        return this.receiveTimeout;
    }
}

