/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.smscsim;

import java.io.IOException;
import org.smpp.SmppObject;
import org.smpp.debug.Debug;
import org.smpp.pdu.Address;
import org.smpp.pdu.DeliverSM;
import org.smpp.pdu.PDUException;
import org.smpp.pdu.Request;
import org.smpp.pdu.SubmitMultiSM;
import org.smpp.pdu.SubmitSM;
import org.smpp.pdu.WrongLengthOfStringException;
import org.smpp.smscsim.PDUProcessor;
import org.smpp.smscsim.PDUProcessorGroup;
import org.smpp.smscsim.SimulatorPDUProcessor;
import org.smpp.util.ProcessingThread;
import org.smpp.util.Queue;

public class MessageSender
extends ProcessingThread {
    private static final String MESSAGE_SENDER_NAME = "MessageSender";
    private static int dlvrInfoSenderIndex = 0;
    private long waitForQueueInterval = 10000L;
    private Queue submitRequests = new Queue();
    private Queue undelivered = new Queue();
    private PDUProcessorGroup processors = null;
    private Debug debug = SmppObject.getDebug();

    public MessageSender(PDUProcessorGroup processors) {
        this.processors = processors;
    }

    private void sendMessage(MessageEntry msg) {
        this.debug.enter(this, "sendMessage");
        String destination = "";
        if (msg.request instanceof SubmitSM) {
            SubmitSM submit = (SubmitSM)msg.request;
            destination = submit.getDestAddr().getAddress();
            Address destAddr = submit.getDestAddr();
            Address sourceAddr = submit.getSourceAddr();
            String serviceType = submit.getServiceType();
            String shortMessage = submit.getShortMessage();
            DeliverSM deliver = new DeliverSM();
            deliver.setDestAddr(destAddr);
            deliver.setSourceAddr(sourceAddr);
            try {
                deliver.setServiceType(serviceType);
                deliver.setShortMessage(shortMessage);
            }
            catch (WrongLengthOfStringException e) {
                this.debug.write("sendMessage: Problem creating message to deliver: " + e);
                this.debug.exit(this);
                return;
            }
            boolean ok = this.deliver(destination, deliver, msg);
            if (!ok) {
                this.debug.write("Message for '" + destination + "' not delivered - putting message back on Queue");
                this.undelivered.enqueue(msg);
            }
        } else if (msg.request instanceof SubmitMultiSM) {
            SubmitMultiSM multi = (SubmitMultiSM)msg.request;
            Address sourceAddr = multi.getSourceAddr();
            sourceAddr = multi.getSourceAddr();
            String serviceType = multi.getServiceType();
            String shortMessage = multi.getShortMessage();
            int num = multi.getNumberOfDests();
            for (int i = 0; i < num; ++i) {
                Address destAddr = multi.getDestAddress(i).getAddress();
                destination = destAddr.getAddress();
                DeliverSM deliver = new DeliverSM();
                deliver.setDestAddr(destAddr);
                deliver.setSourceAddr(sourceAddr);
                try {
                    deliver.setServiceType(serviceType);
                    deliver.setShortMessage(shortMessage);
                }
                catch (WrongLengthOfStringException e) {
                    this.debug.write("sendMessage: Problem creating message to deliver: " + e);
                    this.debug.exit(this);
                    return;
                }
                boolean ok = this.deliver(destination, deliver, msg);
                if (ok) continue;
                this.debug.write("Message for '" + destination + "' not delivered - Message will NOT be delivered");
            }
        }
        this.debug.exit(this);
    }

    private boolean deliver(String destination, DeliverSM deliver, MessageEntry orginalMsg) {
        PDUProcessor proc = null;
        int procCount = this.processors.count();
        boolean found = false;
        for (int i = 0; i < procCount; ++i) {
            proc = (SimulatorPDUProcessor)this.processors.get(i);
            if (!((SimulatorPDUProcessor)proc).getAddress().equals(destination)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.debug.write("Destination PDU (" + destination + ") not found for destination " + destination);
            return false;
        }
        if (!proc.isActive()) {
            this.debug.write("sendMessage: This processor " + ((SimulatorPDUProcessor)proc).getSystemId() + " is inactive.");
        }
        boolean delivered = false;
        try {
            ((SimulatorPDUProcessor)proc).serverRequest(deliver);
            delivered = true;
            this.debug.write("sendMessage: Sent Message ID=" + orginalMsg.messageId + ":" + deliver.debugString());
        }
        catch (WrongLengthOfStringException e) {
            this.debug.write("sendMessage: Message sending failed: " + e);
        }
        catch (IOException ioe) {
            this.debug.write("sendMessage: I/O Exception: " + ioe);
            proc.exit();
        }
        catch (PDUException pe) {
            this.debug.write("sendMessage: PDU Exception: " + pe);
        }
        return delivered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submit(Request request, String messageId) {
        MessageEntry entry = new MessageEntry(request, messageId);
        Queue queue = this.submitRequests;
        synchronized (queue) {
            this.submitRequests.enqueue(entry);
            this.submitRequests.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        if (this.submitRequests.isEmpty()) {
            while (!this.undelivered.isEmpty()) {
                this.submitRequests.enqueue(this.undelivered.dequeue());
            }
            try {
                Queue queue = this.submitRequests;
                synchronized (queue) {
                    this.submitRequests.wait(this.waitForQueueInterval);
                }
            }
            catch (InterruptedException interruptedException) {}
        } else {
            while (!this.submitRequests.isEmpty()) {
                this.sendMessage((MessageEntry)this.submitRequests.dequeue());
            }
        }
    }

    public String getThreadName() {
        return MESSAGE_SENDER_NAME;
    }

    public int getThreadIndex() {
        return ++dlvrInfoSenderIndex;
    }

    protected class MessageEntry {
        public Request request;
        public int sub = 1;
        public int dlvrd = 0;
        public String messageId;
        public long submitted = System.currentTimeMillis();

        public MessageEntry(Request request, String messageId) {
            this.request = request;
            this.messageId = messageId;
        }
    }
}

