/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.smsclient;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.html.HTMLEditorKit;
import org.smpp.ServerPDUEvent;
import org.smpp.ServerPDUEventListener;
import org.smpp.Session;
import org.smpp.SmppObject;
import org.smpp.TCPIPConnection;
import org.smpp.debug.Debug;
import org.smpp.debug.Event;
import org.smpp.debug.FileDebug;
import org.smpp.debug.FileEvent;
import org.smpp.pdu.Address;
import org.smpp.pdu.AddressRange;
import org.smpp.pdu.BindResponse;
import org.smpp.pdu.BindTransciever;
import org.smpp.pdu.EnquireLink;
import org.smpp.pdu.EnquireLinkResp;
import org.smpp.pdu.PDU;
import org.smpp.pdu.Response;
import org.smpp.pdu.SubmitSM;
import org.smpp.pdu.WrongLengthOfStringException;
import org.smpp.smsclient.KeyPad;
import org.smpp.util.Queue;

public class SMSClient
extends JPanel
implements ActionListener {
    private JFrame frame;
    private JEditorPane screenPane = new JEditorPane();
    private JScrollPane jspScrollingScreen = new JScrollPane(this.screenPane);
    private JScrollBar sb = this.jspScrollingScreen.getVerticalScrollBar();
    private StringBuffer screenbuffer = new StringBuffer();
    private HTMLEditorKit html = new HTMLEditorKit();
    private JMenuBar menuBar = new JMenuBar();
    private JMenu fileMenu = new JMenu();
    private JMenuItem miExit = new JMenuItem();
    private JMenu connectionMenu = new JMenu();
    private JMenuItem miConnect = new JMenuItem();
    private JMenuItem miUnbind = new JMenuItem();
    private JMenuItem miCheck = new JMenuItem();
    private JTextField jtfTo = new JTextField("5551212", 12);
    private JLabel jlTo = new JLabel("Send SMS to:");
    private JTextField jtfMessage = new JTextField();
    private JButton jbSend = new JButton("Send");
    private JTextField jtfServer = new JTextField("localhost");
    private JTextField jtfPort = new JTextField("7901");
    private JTextField jtfUsername = new JTextField("user1");
    private JPasswordField jpfPassword = new JPasswordField("user1");
    private JTextField jtfNumber = new JTextField("5551234");
    private ImageIcon red = null;
    private ImageIcon green = null;
    private JLabel jlIcon = new JLabel(this.red);
    private JTextField statusbarText = new JTextField("Disconnected");
    SettingsDialog settingsDialog;
    static final String dbgDir = "./";
    static Debug debug = new FileDebug("./", "SMSClientDebug.log");
    static Event event = new FileEvent("./", "SMSClientEvent.log");
    static Session session = null;
    Properties properties = new Properties();
    boolean bound = false;
    String ipAddress = null;
    int port = 0;
    String systemId = null;
    String password = null;
    String bindOption = "t";
    boolean asynchronous = false;
    SMSClientPDUEventListener pduListener = null;
    AddressRange addressRange = new AddressRange();
    private Thread monitorThread = null;
    private boolean monitorShutdown = false;
    private final int ONE_MINUTE = 5000;
    private final int TEN_SECONDS = 10000;
    private long pingInterval = 5000L;
    private HashMap waiterMap = new HashMap();
    String systemType = "";
    String serviceType = "";
    Address sourceAddress = new Address();
    Address destAddress = new Address();
    String scheduleDeliveryTime = "";
    String validityPeriod = "";
    String shortMessage = "";
    String phoneNum = "";
    byte ton = 1;
    byte npi = 1;
    int numberOfDestination = 1;
    String messageId = "";
    byte esmClass = 0;
    byte protocolId = 0;
    byte priorityFlag = 0;
    byte registeredDelivery = 0;
    byte replaceIfPresentFlag = 0;
    byte dataCoding = 0;
    byte smDefaultMsgId = 0;
    String lastIncomingMessageSourceAddress = "";
    String replyToAddress = "";
    byte isReply = 0;
    byte isSubmit = 0;
    long receiveTimeout = -1L;

    SMSClient(JFrame frame) {
        super(new BorderLayout());
        this.frame = frame;
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                SMSClient.this.exit();
            }
        });
        this.makeIcons();
        this.frame.setJMenuBar(this.makeMenu());
        this.add((Component)this.makePanel(), "Center");
        this.add((Component)this.makeStatusBar(), "South");
        this.settingsDialog = new SettingsDialog(frame);
        this.settingsDialog.pack();
        this.settingsDialog.setLocationRelativeTo(frame);
        this.settingsDialog.setVisible(true);
    }

    private void makeIcons() {
        Class<?> c = this.getClass();
        ClassLoader cl = c.getClassLoader();
        this.red = new ImageIcon(cl.getResource("org/smpp/smsclient/red.gif"));
        this.green = new ImageIcon(cl.getResource("org/smpp/smsclient/green.gif"));
    }

    private JPanel makePanel() {
        int height = 350;
        int width = 240;
        this.jspScrollingScreen.setHorizontalScrollBarPolicy(31);
        this.screenPane.setEditable(false);
        this.screenPane.setEditorKit(this.html);
        this.screenPane.setAutoscrolls(true);
        JPanel jpScreenHolder = new JPanel();
        jpScreenHolder.setLayout(new BorderLayout());
        jpScreenHolder.add((Component)this.jspScrollingScreen, "Center");
        jpScreenHolder.setPreferredSize(new Dimension(240, 350));
        JPanel jpSendStuff = new JPanel(new BorderLayout());
        JPanel jpAddress = new JPanel(new FlowLayout());
        this.jlTo.setLabelFor(this.jtfTo);
        jpAddress.add(this.jlTo);
        jpAddress.add(this.jtfTo);
        jpSendStuff.add((Component)jpAddress, "West");
        JPanel jpMessageAndSend = new JPanel(new BorderLayout());
        this.jtfMessage.setColumns(30);
        this.jtfMessage.addActionListener(this);
        jpMessageAndSend.add((Component)this.jtfMessage, "Center");
        this.jbSend.addActionListener(this);
        this.jbSend.setSelected(true);
        jpMessageAndSend.add((Component)this.jbSend, "East");
        jpSendStuff.add((Component)jpMessageAndSend, "South");
        jpScreenHolder.add((Component)jpSendStuff, "South");
        this.disconnectedUpdateGUI();
        JPanel jpMain = new JPanel(new BorderLayout());
        jpMain.add((Component)jpScreenHolder, "Center");
        KeyPad keyPad = new KeyPad(this.jtfMessage);
        jpMain.add((Component)keyPad, "South");
        return jpMain;
    }

    private JMenuBar makeMenu() {
        this.fileMenu.setText("File");
        this.fileMenu.addSeparator();
        this.miExit.setText("Exit");
        this.fileMenu.add((Component)this.miExit, 1);
        this.menuBar.add(this.fileMenu);
        this.connectionMenu.setText("Connection");
        this.miConnect.setText("Connect to SMSC");
        if (this.bound) {
            this.miConnect.setEnabled(false);
        }
        this.connectionMenu.add((Component)this.miConnect, 0);
        this.miUnbind.setText("Disconnect from SMSC");
        if (!this.bound) {
            this.miUnbind.setEnabled(false);
        }
        this.connectionMenu.add((Component)this.miUnbind, 1);
        this.miCheck.setText("Check connection to SMSC");
        this.connectionMenu.add((Component)this.miCheck, 2);
        this.menuBar.add(this.connectionMenu);
        this.miExit.addActionListener(this);
        this.miConnect.addActionListener(this);
        this.miUnbind.addActionListener(this);
        this.miCheck.addActionListener(this);
        return this.menuBar;
    }

    private Box makeStatusBar() {
        Box sbar = Box.createHorizontalBox();
        this.jlIcon.setToolTipText("disconnected");
        sbar.add(this.jlIcon);
        this.statusbarText.setBackground(Color.lightGray);
        this.statusbarText.setEditable(false);
        sbar.add(this.statusbarText);
        sbar.add(Box.createGlue());
        return sbar;
    }

    private void enableSend() {
        this.jtfMessage.setEnabled(true);
        this.jtfTo.setEnabled(true);
        this.jbSend.setEnabled(true);
        this.jlTo.setEnabled(true);
        this.jlIcon.setIcon(this.green);
        this.jlIcon.setToolTipText("Connected");
        this.statusbarText.setText("Connected to " + this.ipAddress + ":" + this.port);
        this.frame.setTitle("SMSClient: " + this.phoneNum);
    }

    private void disconnectedUpdateGUI() {
        this.jtfMessage.setEnabled(false);
        this.jtfTo.setEnabled(false);
        this.jbSend.setEnabled(false);
        this.jlTo.setEnabled(false);
        this.jlIcon.setIcon(this.red);
        this.jlIcon.setToolTipText("Disconnected");
        this.statusbarText.setText("Disconnected");
        this.frame.setTitle("SMSClient");
        if (this.monitorThread != null) {
            this.monitorShutdown = true;
            this.monitorThread.interrupt();
            this.monitorThread = null;
        }
    }

    private synchronized void writeScreen(String msg, String color) {
        if (msg.indexOf("\n") > 0) {
            StringTokenizer st = new StringTokenizer(msg, "\n");
            StringBuffer newbuffer = new StringBuffer();
            newbuffer.append(st.nextElement());
            newbuffer.append("<br>");
            while (st.hasMoreElements()) {
                newbuffer.append(st.nextElement());
                newbuffer.append("<br>");
            }
            msg = newbuffer.toString();
        }
        String out = "<font color=\"" + color + "\"><strong>" + msg + "</strong></font>";
        this.screenbuffer.append(out);
        this.screenPane.setText(this.screenbuffer.toString());
    }

    private void exit() {
        if (this.bound) {
            this.unbind();
        }
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bind() {
        debug.enter(this, "SimpleSMPPClient.bind()");
        try {
            if (this.bound) {
                return;
            }
            BindTransciever request = null;
            BindResponse response = null;
            request = new BindTransciever();
            TCPIPConnection connection = new TCPIPConnection(this.ipAddress, this.port);
            connection.setReceiveTimeout(20000L);
            session = new Session(connection);
            request.setSystemId(this.systemId);
            request.setPassword(this.password);
            request.setSystemType(this.systemType);
            request.setInterfaceVersion((byte)52);
            this.addressRange.setTon(this.ton);
            this.addressRange.setNpi(this.npi);
            this.addressRange.setAddressRange(this.phoneNum);
            request.setAddressRange(this.addressRange);
            this.pduListener = new SMSClientPDUEventListener(session);
            response = session.bind(request, this.pduListener);
            if (response.getCommandStatus() == 0) {
                this.bound = true;
                this.miConnect.setEnabled(false);
                this.miUnbind.setEnabled(true);
                this.enableSend();
            }
            if (this.bound) {
                Runnable r = new Runnable(){

                    public void run() {
                        SMSClient.this.monitor();
                    }
                };
                this.monitorThread = new Thread(r);
                this.monitorThread.setName("SMS ping thread");
                this.monitorShutdown = false;
                this.monitorThread.start();
            }
        }
        catch (Exception e) {
            event.write(e, "");
            debug.write("Bind operation failed. " + e);
            System.out.println("Bind operation failed. " + e);
            this.statusbarText.setText("Unable to connect to " + this.ipAddress + ":" + this.port);
        }
        finally {
            debug.exit(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unbind() {
        debug.enter(this, "SimpleSMPPClient.unbind()");
        try {
            if (!this.bound) {
                return;
            }
            if (this.monitorThread != null) {
                this.monitorShutdown = true;
                this.monitorThread.interrupt();
                this.monitorThread = null;
            }
            session.unbind();
            this.bound = false;
            this.miConnect.setEnabled(true);
            this.miUnbind.setEnabled(false);
            this.disconnectedUpdateGUI();
        }
        catch (Exception e) {
            event.write(e, "");
            debug.write("Unbind operation failed. " + e);
            System.out.println("Unbind operation failed. Resetting..." + e);
            session = null;
            this.pduListener = null;
            this.bound = false;
            this.miConnect.setEnabled(true);
            this.miUnbind.setEnabled(false);
            this.disconnectedUpdateGUI();
        }
        finally {
            debug.exit(this);
        }
        this.frame.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enquireLink() {
        debug.enter(this, "SMPPTest.enquireLink()");
        try {
            EnquireLink request = new EnquireLink();
            request.assignSequenceNumber();
            int sequenceNumber = request.getSequenceNumber();
            ResponseWaiter rw = new ResponseWaiter(sequenceNumber);
            Integer key = new Integer(sequenceNumber);
            this.waiterMap.put(key, rw);
            session.enquireLink(request);
            try {
                EnquireLinkResp response = (EnquireLinkResp)rw.getResponse(10000L);
                this.waiterMap.remove(key);
                if (response == null) {
                    throw new Exception("No response to Ping");
                }
                if (response.getCommandStatus() != 0) {
                    throw new Exception("Response code was not OK");
                }
                this.statusbarText.setText("Connected to " + this.ipAddress + ":" + this.port + " OK");
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        catch (Exception ex) {
            event.write(ex, "");
            debug.write("Enquire Link operation failed. " + ex);
            this.bound = false;
            this.miConnect.setEnabled(true);
            this.miUnbind.setEnabled(false);
            this.disconnectedUpdateGUI();
        }
        finally {
            debug.exit(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submit(Address destination, String message) {
        debug.enter(this, "SimpleSMPPClient.submit()");
        try {
            SubmitSM request = new SubmitSM();
            request.setServiceType(this.serviceType);
            request.setSourceAddr(this.sourceAddress);
            request.setDestAddr(destination);
            request.setReplaceIfPresentFlag(this.replaceIfPresentFlag);
            request.setShortMessage(message);
            request.setScheduleDeliveryTime(this.scheduleDeliveryTime);
            request.setValidityPeriod(this.validityPeriod);
            request.setEsmClass(this.esmClass);
            request.setProtocolId(this.protocolId);
            request.setPriorityFlag(this.priorityFlag);
            request.setRegisteredDelivery(this.registeredDelivery);
            request.setDataCoding(this.dataCoding);
            request.setSmDefaultMsgId(this.smDefaultMsgId);
            request.assignSequenceNumber(true);
            this.writeScreen(this.phoneNum + ": " + message + "\n", "black");
            session.submit(request);
            this.isReply = 0;
        }
        catch (Exception e) {
            event.write(e, "");
            debug.write("Submit operation failed. " + e);
            System.out.println("Submit operation failed. " + e);
            this.writeScreen("send failed\n", "red");
        }
        finally {
            debug.exit(this);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jbSend || e.getSource() == this.jtfMessage) {
            try {
                String num = this.jtfTo.getText();
                String msg = this.jtfMessage.getText();
                if (num.length() > 0 && msg.length() > 0) {
                    Address aTo = new Address(1, 1, num);
                    this.submit(aTo, msg);
                    this.jtfMessage.setText("");
                } else if (num.length() == 0) {
                    this.jtfTo.grabFocus();
                } else if (msg.length() == 0) {
                    this.jtfMessage.grabFocus();
                }
            }
            catch (Exception ef) {
                this.writeScreen("send failed. bad address", "red");
            }
        } else if (e.getSource() == this.miExit) {
            this.exit();
        } else if (e.getSource() == this.miConnect) {
            this.settingsDialog.setVisible(true);
        } else if (e.getSource() == this.miUnbind) {
            this.unbind();
        } else if (e.getSource() == this.miCheck) {
            this.enquireLink();
        }
    }

    public static void main(String[] args) {
        debug.activate();
        event.activate();
        SmppObject.setDebug(debug);
        SmppObject.setEvent(event);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SMSClient.createAndShowGUI();
            }
        });
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("SMSClient");
        frame.setDefaultCloseOperation(0);
        SMSClient newContentPane = new SMSClient(frame);
        frame.setContentPane(newContentPane);
        frame.pack();
        frame.setVisible(true);
    }

    private void monitor() {
        while (!this.monitorShutdown) {
            try {
                Thread.sleep(this.pingInterval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.monitorShutdown) continue;
            this.enquireLink();
        }
    }

    static /* synthetic */ void access$500(SMSClient x0, String x1, String x2) {
        x0.writeScreen(x1, x2);
    }

    private class SettingsDialog
    extends JDialog
    implements PropertyChangeListener {
        private String msgString1 = "Connect to SMSC Server";
        private String msgString2 = "Server: ";
        private String msgString3 = "Port: ";
        private String msgString4 = "Username: ";
        private String msgString5 = "Password: ";
        private String msgString6 = "Your Phone Number: ";
        private JOptionPane settingsPane;

        private SettingsDialog(JFrame aFrame) {
            super((Frame)aFrame, true);
            Object[] array = new Object[]{this.msgString1, this.msgString2, SMSClient.this.jtfServer, this.msgString3, SMSClient.this.jtfPort, this.msgString4, SMSClient.this.jtfUsername, this.msgString5, SMSClient.this.jpfPassword, this.msgString6, SMSClient.this.jtfNumber};
            Object[] options = new Object[]{"Connect", "Cancel"};
            this.settingsPane = new JOptionPane(array, 3, 0, null, options, options[0]);
            this.setContentPane(this.settingsPane);
            this.setDefaultCloseOperation(1);
            this.settingsPane.addPropertyChangeListener(this);
        }

        public void clearAndHide() {
            this.setVisible(false);
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (this.isVisible() && e.getSource() == this.settingsPane) {
                String val = (String)this.settingsPane.getValue();
                if (val == "Connect") {
                    SMSClient.this.ipAddress = SMSClient.this.jtfServer.getText();
                    try {
                        SMSClient.this.port = Integer.parseInt(SMSClient.this.jtfPort.getText());
                    }
                    catch (Exception ex) {
                        SMSClient.this.port = 7901;
                    }
                    SMSClient.this.systemId = SMSClient.this.jtfUsername.getText();
                    SMSClient.this.password = new String(SMSClient.this.jpfPassword.getPassword());
                    SMSClient.this.phoneNum = SMSClient.this.jtfNumber.getText();
                    try {
                        SMSClient.this.sourceAddress.setAddress(SMSClient.this.phoneNum);
                    }
                    catch (WrongLengthOfStringException e1) {
                        e1.printStackTrace();
                    }
                    this.clearAndHide();
                    SMSClient.this.bind();
                } else if (val == "Cancel") {
                    this.clearAndHide();
                }
                this.settingsPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
            }
        }
    }

    protected class ResponseWaiter {
        private int seq = 0;
        private Response result = null;
        private boolean ready = false;

        public ResponseWaiter(int sequenceNum) {
            this.seq = sequenceNum;
        }

        public synchronized Response getResponse(long timeout) throws InterruptedException {
            if (!this.ready) {
                this.wait(timeout);
            }
            return this.result;
        }

        public synchronized void setResponse(Response r) {
            if (r.getSequenceNumber() != this.seq) {
                return;
            }
            this.result = r;
            this.ready = true;
            this.notify();
        }
    }

    private class SMSClientPDUEventListener
    extends SmppObject
    implements ServerPDUEventListener {
        Session session;
        Queue requestEvents = new Queue();

        public SMSClientPDUEventListener(Session session) {
            this.session = session;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(ServerPDUEvent event) {
            PDU pdu = event.getPDU();
            if (pdu.isRequest()) {
                SMSClient.this.lastIncomingMessageSourceAddress = pdu.getSource();
                Runnable r = new Runnable(this, pdu){
                    private final /* synthetic */ PDU val$pdu;
                    private final /* synthetic */ SMSClientPDUEventListener this$1;
                    {
                        this.this$1 = this$1;
                        this.val$pdu = val$pdu;
                    }

                    public void run() {
                        SMSClient.access$500(SMSClientPDUEventListener.access$400(this.this$1), this.val$pdu.screenOutput() + "\n", "blue");
                    }
                };
                try {
                    SwingUtilities.invokeAndWait(r);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                Queue e = this.requestEvents;
                synchronized (e) {
                    this.requestEvents.enqueue(event);
                    this.requestEvents.notify();
                }
            }
            if (pdu.isResponse()) {
                Object o = SMSClient.this.waiterMap.get(new Integer(pdu.getSequenceNumber()));
                if (o != null) {
                    ResponseWaiter rw = (ResponseWaiter)o;
                    rw.setResponse((Response)pdu);
                }
            } else {
                System.out.println("pdu of unknown class (not request nor response) received, discarding " + pdu.debugString());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ServerPDUEvent getRequestEvent(long timeout) {
            ServerPDUEvent pduEvent = null;
            Queue queue = this.requestEvents;
            synchronized (queue) {
                if (this.requestEvents.isEmpty()) {
                    try {
                        this.requestEvents.wait(timeout);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                if (!this.requestEvents.isEmpty()) {
                    pduEvent = (ServerPDUEvent)this.requestEvents.dequeue();
                }
            }
            return pduEvent;
        }

        static /* synthetic */ SMSClient access$400(SMSClientPDUEventListener x0) {
            return x0.SMSClient.this;
        }
    }
}

