/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.pdu.tlv;

import org.smpp.pdu.ValueNotSetException;
import org.smpp.pdu.tlv.TLV;
import org.smpp.pdu.tlv.TLVException;
import org.smpp.util.ByteBuffer;
import org.smpp.util.NotEnoughDataInByteBufferException;

public class TLVInt
extends TLV {
    private int value = 0;

    public TLVInt() {
        super(4, 4);
    }

    public TLVInt(short p_tag) {
        super(p_tag, 4, 4);
    }

    public TLVInt(short p_tag, int p_value) {
        super(p_tag, 4, 4);
        this.value = p_value;
        this.markValueSet();
    }

    protected void setValueData(ByteBuffer buffer) throws TLVException {
        this.checkLength(buffer);
        try {
            this.value = buffer.removeInt();
        }
        catch (NotEnoughDataInByteBufferException notEnoughDataInByteBufferException) {
            // empty catch block
        }
        this.markValueSet();
    }

    protected ByteBuffer getValueData() throws ValueNotSetException {
        ByteBuffer valueBuf = new ByteBuffer();
        valueBuf.appendInt(this.getValue());
        return valueBuf;
    }

    public void setValue(int p_value) {
        this.value = p_value;
        this.markValueSet();
    }

    public int getValue() throws ValueNotSetException {
        if (this.hasValue()) {
            return this.value;
        }
        throw new ValueNotSetException();
    }

    public String debugString() {
        String dbgs = "(int: ";
        dbgs = dbgs + super.debugString();
        dbgs = dbgs + this.value;
        dbgs = dbgs + ") ";
        return dbgs;
    }
}

