/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.pdu;

import org.smpp.pdu.PDUException;
import org.smpp.pdu.Response;
import org.smpp.pdu.WrongDateFormatException;
import org.smpp.pdu.WrongLengthOfStringException;
import org.smpp.util.ByteBuffer;
import org.smpp.util.NotEnoughDataInByteBufferException;
import org.smpp.util.TerminatingZeroNotFoundException;

public class QuerySMResp
extends Response {
    private String messageId = "";
    private String finalDate = "";
    private byte messageState = 0;
    private byte errorCode = 0;

    public QuerySMResp() {
        super(-2147483645);
    }

    public void setBody(ByteBuffer buffer) throws NotEnoughDataInByteBufferException, TerminatingZeroNotFoundException, PDUException {
        this.setMessageId(buffer.removeCString());
        this.setFinalDate(buffer.removeCString());
        this.setMessageState(buffer.removeByte());
        this.setErrorCode(buffer.removeByte());
    }

    public ByteBuffer getBody() {
        ByteBuffer buffer = new ByteBuffer();
        buffer.appendCString(this.getMessageId());
        buffer.appendCString(this.getFinalDate());
        buffer.appendByte(this.getMessageState());
        buffer.appendByte(this.getErrorCode());
        return buffer;
    }

    public void setMessageId(String value) throws WrongLengthOfStringException {
        QuerySMResp.checkString(value, 64);
        this.messageId = value;
    }

    public void setFinalDate(String value) throws WrongDateFormatException {
        QuerySMResp.checkDate(value);
        this.finalDate = value;
    }

    public void setMessageState(byte value) {
        this.messageState = value;
    }

    public void setErrorCode(byte value) {
        this.errorCode = value;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getFinalDate() {
        return this.finalDate;
    }

    public byte getMessageState() {
        return this.messageState;
    }

    public byte getErrorCode() {
        return this.errorCode;
    }

    public String debugString() {
        String dbgs = "(query_resp: ";
        dbgs = dbgs + super.debugString();
        dbgs = dbgs + this.getMessageId();
        dbgs = dbgs + " ";
        dbgs = dbgs + this.getFinalDate();
        dbgs = dbgs + " ";
        dbgs = dbgs + this.getMessageState();
        dbgs = dbgs + " ";
        dbgs = dbgs + this.getErrorCode();
        dbgs = dbgs + " ";
        dbgs = dbgs + this.debugStringOptional();
        dbgs = dbgs + ") ";
        return dbgs;
    }
}

