/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.pdu;

import org.smpp.pdu.PDU;
import org.smpp.pdu.PDUException;
import org.smpp.pdu.Request;
import org.smpp.pdu.Response;
import org.smpp.pdu.WrongLengthOfStringException;
import org.smpp.util.ByteBuffer;
import org.smpp.util.NotEnoughDataInByteBufferException;
import org.smpp.util.TerminatingZeroNotFoundException;

public class Outbind
extends Request {
    private String systemId = "";
    private String password = "";

    public Outbind() {
        super(11);
    }

    protected Response createResponse() {
        return null;
    }

    public boolean canResponse() {
        return false;
    }

    public void setBody(ByteBuffer buffer) throws NotEnoughDataInByteBufferException, TerminatingZeroNotFoundException, PDUException {
        this.setSystemId(buffer.removeCString());
        this.setPassword(buffer.removeCString());
    }

    public ByteBuffer getBody() {
        ByteBuffer buffer = new ByteBuffer();
        buffer.appendCString(this.getSystemId());
        buffer.appendCString(this.getPassword());
        return buffer;
    }

    public void setSystemId(String sysId) throws WrongLengthOfStringException {
        Outbind.checkString(sysId, 16);
        this.systemId = sysId;
    }

    public void setPassword(String pwd) throws WrongLengthOfStringException {
        Outbind.checkString(pwd, 9);
        this.password = pwd;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getPassword() {
        return this.password;
    }

    public String debugString() {
        String dbgs = "(outbind: ";
        dbgs = dbgs + super.debugString();
        dbgs = dbgs + this.getSystemId();
        dbgs = dbgs + " ";
        dbgs = dbgs + this.getPassword();
        dbgs = dbgs + ")";
        return dbgs;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        PDU pdu = (PDU)object;
        return pdu.getCommandId() == this.getCommandId();
    }
}

