/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.JRAbstractExtendedIncrementer;
import net.sf.jasperreports.engine.fill.JRCalculable;
import net.sf.jasperreports.engine.fill.JRDoubleIncrementerFactory;

class JRDoubleSumIncrementer
extends JRAbstractExtendedIncrementer {
    private static JRDoubleSumIncrementer mainInstance = new JRDoubleSumIncrementer();

    private JRDoubleSumIncrementer() {
    }

    public static JRDoubleSumIncrementer getInstance() {
        return mainInstance;
    }

    @Override
    public Object increment(JRCalculable variable, Object expressionValue, AbstractValueProvider valueProvider) {
        Number value = (Number)variable.getIncrementedValue();
        Number newValue = (Number)expressionValue;
        if (newValue == null) {
            if (variable.isInitialized()) {
                return null;
            }
            return value;
        }
        if (value == null) {
            value = variable.getValue() == null ? (Number)JRDoubleIncrementerFactory.ZERO : (Number)((Number)variable.getValue());
        }
        return new Double(value.doubleValue() + newValue.doubleValue());
    }

    @Override
    public Object initialValue(JRCalculable variable) {
        if (variable.getValue() == null) {
            return JRDoubleIncrementerFactory.ZERO;
        }
        return (Number)variable.getValue();
    }
}

