/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils.repositories;

import java.awt.geom.GeneralPath;
import java.io.Serializable;

public class Vector_Path
implements Serializable {
    private int increment_size = 1000;
    private int current_item;
    private int max_size = 250;
    private GeneralPath[] items = new GeneralPath[this.max_size];

    public Vector_Path() {
    }

    private static int incrementSize(int increment_size) {
        increment_size = increment_size < 8000 ? (increment_size *= 4) : (increment_size < 16000 ? (increment_size *= 2) : (increment_size += 2000));
        return increment_size;
    }

    public Vector_Path(int number) {
        this.max_size = number;
        this.items = new GeneralPath[this.max_size];
    }

    public final GeneralPath[] get() {
        return this.items;
    }

    public final void clear() {
        if (this.current_item > 0) {
            for (int i = 0; i < this.current_item; ++i) {
                this.items[i] = null;
            }
        } else {
            for (int i = 0; i < this.max_size; ++i) {
                this.items[i] = null;
            }
        }
        this.current_item = 0;
    }

    public final void set(GeneralPath[] new_items) {
        this.items = new_items;
    }

    public final GeneralPath elementAt(int id) {
        if (id >= this.max_size) {
            return null;
        }
        return this.items[id];
    }

    public final void addElement(GeneralPath value) {
        this.checkSize(this.current_item);
        this.items[this.current_item] = value;
        ++this.current_item;
    }

    public final int size() {
        return this.current_item + 1;
    }

    private void checkSize(int i) {
        if (i >= this.max_size) {
            int old_size = this.max_size;
            this.max_size += this.increment_size;
            if (this.max_size <= i) {
                this.max_size = i + this.increment_size + 2;
            }
            GeneralPath[] temp = this.items;
            this.items = new GeneralPath[this.max_size];
            System.arraycopy(temp, 0, this.items, 0, old_size);
            this.increment_size = Vector_Path.incrementSize(this.increment_size);
        }
    }

    public void setCurrent_item(int current_item) {
        this.current_item = current_item;
    }
}

