/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils;

class TextTokens {
    private final byte[] content;
    private final int length;
    private int currentCharPointer;

    TextTokens(byte[] rawText) {
        this.content = rawText;
        this.length = rawText.length;
        this.currentCharPointer = 0;
    }

    boolean hasMoreTokens() {
        return this.currentCharPointer < this.length;
    }

    char nextUnicodeToken(boolean keepReturns) {
        int combined;
        char second = '\u0000';
        char first = this.nextToken();
        if (this.hasMoreTokens() && (combined = (first << 8) + (second = this.nextToken())) == 13 && keepReturns) {
            return '\r';
        }
        if (first == '\r' && keepReturns && this.hasMoreTokens()) {
            first = this.nextToken();
        }
        if (this.hasMoreTokens() && second == '\r' && keepReturns && this.hasMoreTokens()) {
            second = this.nextToken();
        }
        return (char)((first << 8) + second);
    }

    private char getChar(int pointer) {
        int number = this.content[pointer] & 0xFF;
        return (char)number;
    }

    char nextToken() {
        char nextChar = this.getChar(this.currentCharPointer);
        ++this.currentCharPointer;
        return nextChar;
    }

    boolean isUnicode() {
        if (this.length >= 2 && this.nextToken() == '\u00fe' && this.nextToken() == '\u00ff') {
            return true;
        }
        this.currentCharPointer = 0;
        return false;
    }
}

