/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.text;

import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.glyph.MarkerGlyph;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.glyph.UnrendererGlyph;
import org.jpedal.objects.GraphicsState;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.parser.ParserOptions;
import org.jpedal.parser.text.GlyphData;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.render.SwingDisplay;

class JavaTextRenderer {
    JavaTextRenderer() {
    }

    static void renderTextWithJavaFonts(GraphicsState gs, DynamicVectorRenderer current, int streamType, ParserOptions parserOptions, PdfFont currentFontData, GlyphData glyphData, int Tmode, float currentWidth, boolean isTextShifted, PdfJavaGlyphs glyphs, float[][] Trm) {
        Object transformedGlyph2;
        float actualWidth = glyphData.getActualWidth();
        AffineTransform glyphAt = null;
        int rawInt = glyphData.getRawInt();
        if (parserOptions.generateGlyphOnRender() && !parserOptions.renderDirectly()) {
            transformedGlyph2 = JavaTextRenderer.getTransformedGlyph((SwingDisplay)current, currentFontData, glyphData, currentWidth, Trm, rawInt);
        } else {
            boolean isSTD;
            boolean bl = isSTD = actualWidth > 0.0f || DecoderOptions.isRunningOnMac || streamType == 1 || StandardFonts.isStandardFont(currentFontData.getBaseFontName(), true) || currentFontData.isBrokenFont();
            if (glyphs.lastTrm[0][0] != Trm[0][0] || glyphs.lastTrm[1][0] != Trm[1][0] || glyphs.lastTrm[0][1] != Trm[0][1] || glyphs.lastTrm[1][1] != Trm[1][1]) {
                glyphs.lastTrm = Trm;
                glyphs.flush();
            }
            Area glyph = glyphs.getCachedShape(rawInt);
            glyphAt = glyphs.getCachedTransform(rawInt);
            if (glyph == null) {
                double dY = -1.0;
                double dX = 1.0;
                double x3 = 0.0;
                double y3 = 0.0;
                if (isSTD || glyphs.isCIDFont) {
                    glyph = glyphs.getGlyph(glyphData.getDisplayValue(), currentWidth);
                    if (glyph != null && rawInt == 146 && glyphs.isArialInstalledLocally) {
                        y3 = -(glyph.getBounds().height - glyph.getBounds().y);
                    }
                } else {
                    String xx = glyphData.getDisplayValue();
                    GlyphVector gv1 = null;
                    if (!glyphs.isCIDFont || glyphs.isFontInstalled) {
                        gv1 = glyphs.getUnscaledFont().createGlyphVector(PdfJavaGlyphs.frc, xx);
                    }
                    if (gv1 != null) {
                        double glyphWidth;
                        double scaleFactor;
                        glyph = new Area(gv1.getOutline());
                        double glyphX = gv1.getOutline().getBounds2D().getX();
                        x3 = 0.0;
                        if (glyphX < 0.0) {
                            glyphX = -glyphX;
                            x3 = glyphX * 2.0;
                            x3 *= (double)Math.max(Trm[0][0], Trm[0][1]);
                        }
                        if ((scaleFactor = (double)currentWidth / (glyphWidth = gv1.getVisualBounds().getWidth() + glyphX * 2.0)) < 1.0) {
                            dX *= scaleFactor;
                        }
                        if (x3 > 0.0) {
                            x3 *= dX;
                        }
                    }
                }
                glyphAt = new AffineTransform(dX * (double)Trm[0][0], dX * (double)Trm[0][1], dY * (double)Trm[1][0], dY * (double)Trm[1][1], x3, y3);
                glyphs.setCachedShape(rawInt, glyph, glyphAt);
            }
            if (glyph != null && Tmode == 7 && glyph.getBounds().width > 0) {
                JavaTextRenderer.handleClipText(gs, parserOptions, Trm, glyphAt, glyph);
                glyph = null;
            }
            transformedGlyph2 = glyph;
        }
        if (transformedGlyph2 != null) {
            double[] textTrans = new double[6];
            if (glyphAt != null) {
                glyphAt.getMatrix(textTrans);
            }
            int fontSize = glyphData.getFontSize();
            if (parserOptions.renderDirectly()) {
                current.drawEmbeddedText(Trm, fontSize, null, transformedGlyph2, 1, gs, textTrans, glyphData.getUnicodeValue(), currentFontData, -100.0f);
            } else if (isTextShifted) {
                current.drawEmbeddedText(Trm, -fontSize, null, transformedGlyph2, 1, gs, null, glyphData.getUnicodeValue(), currentFontData, -100.0f);
            } else {
                current.drawEmbeddedText(Trm, fontSize, null, transformedGlyph2, 1, gs, null, glyphData.getUnicodeValue(), currentFontData, -100.0f);
            }
        }
    }

    private static Object getTransformedGlyph(SwingDisplay current, PdfFont currentFontData, GlyphData glyphData, float currentWidth, float[][] Trm, int rawInt) {
        PdfGlyph transformedGlyph2;
        if (glyphData.isfirstTime()) {
            transformedGlyph2 = new MarkerGlyph(Trm[0][0], Trm[0][1], Trm[1][0], Trm[1][1], currentFontData.getBaseFontName());
            current.checkFontSaved(transformedGlyph2, currentFontData.getBaseFontName(), currentFontData);
            glyphData.setFirstTime();
        }
        currentFontData.setValuesForGlyph(rawInt, null, glyphData.getDisplayValue(), null);
        transformedGlyph2 = new UnrendererGlyph(Trm[2][0], Trm[2][1], rawInt, currentWidth);
        return transformedGlyph2;
    }

    private static void handleClipText(GraphicsState gs, ParserOptions parserOptions, float[][] Trm, AffineTransform glyphAt, Area glyph) {
        Area glyphShape = (Area)glyph.clone();
        if (glyphAt != null) {
            glyphShape.transform(glyphAt);
        }
        if (parserOptions.renderDirectly()) {
            AffineTransform at2 = AffineTransform.getTranslateInstance(Trm[2][0], Trm[2][1]);
            glyphShape.transform(at2);
        }
        gs.addClip(glyphShape);
    }
}

