/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.shape;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import org.jpedal.color.PdfPaint;
import org.jpedal.color.ShearedTexturePaint;
import org.jpedal.external.ShapeTracker;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.PdfShape;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.ParserOptions;
import org.jpedal.parser.PdfObjectCache;
import org.jpedal.parser.image.PDFObjectToImage;
import org.jpedal.render.DynamicVectorRenderer;

public class F {
    public static void execute(int tokenNumber, boolean isStar, int formLevel, PdfShape currentDrawShape, GraphicsState gs, PdfObjectCache cache, PdfObjectReader currentPdfFile, DynamicVectorRenderer current, ParserOptions parserOptions, float multiplyer) {
        if (formLevel > 1 && cache.groupObj != null && !cache.groupObj.getBoolean(27) && !cache.groupObj.getBoolean(25) && gs.getAlphaMax(2) > 0.99f && gs.nonstrokeColorSpace.getID() == 1498837125 && gs.nonstrokeColorSpace.getColor().getRGB() == -1) {
            currentDrawShape.resetPath();
            return;
        }
        if (gs.SMask != null && gs.SMask.getDictionary(23) != null && (gs.nonstrokeColorSpace.getID() == 1568372915 || gs.nonstrokeColorSpace.getID() == 1785221209 || gs.nonstrokeColorSpace.getID() == 1498837125)) {
            if (isStar) {
                currentDrawShape.setEVENODDWindingRule();
            } else {
                currentDrawShape.setNONZEROWindingRule();
            }
            currentDrawShape.closeShape();
            Shape currentShape = currentDrawShape.generateShapeFromPath(gs.CTM, gs.getLineWidth(), 70);
            if (currentShape == null) {
                F.createSMaskFill(gs, currentPdfFile, current, parserOptions, formLevel, multiplyer);
            } else {
                F.renderShapeAsG2Shape(formLevel, currentDrawShape, gs, currentPdfFile, current, parserOptions, multiplyer);
            }
            currentDrawShape.resetPath();
            return;
        }
        if (parserOptions.isLayerVisible()) {
            if (isStar) {
                currentDrawShape.setEVENODDWindingRule();
            } else {
                currentDrawShape.setNONZEROWindingRule();
            }
            currentDrawShape.closeShape();
            Shape currentShape = currentDrawShape.generateShapeFromPath(gs.CTM, gs.getLineWidth(), 70);
            ShapeTracker customShapeTracker = parserOptions.getCustomShapeTraker();
            if (customShapeTracker != null) {
                if (isStar) {
                    customShapeTracker.addShape(tokenNumber, 17962, currentShape, gs.nonstrokeColorSpace.getColor(), gs.strokeColorSpace.getColor());
                } else {
                    customShapeTracker.addShape(tokenNumber, 70, currentShape, gs.nonstrokeColorSpace.getColor(), gs.strokeColorSpace.getColor());
                }
            }
            if (currentShape != null && parserOptions.isRenderPage()) {
                gs.setFillType(2);
                current.drawShape(currentDrawShape, gs, 70);
                if (current.isHTMLorSVG() && cache.groupObj == null) {
                    current.eliminateHiddenText(currentShape, gs, currentDrawShape.getSegmentCount(), false);
                }
            }
        }
        currentDrawShape.setClip(false);
        currentDrawShape.resetPath();
    }

    private static void renderShapeAsG2Shape(int formLevel, PdfShape currentDrawShape, GraphicsState gs, PdfObjectReader currentPdfFile, DynamicVectorRenderer current, ParserOptions parserOptions, float multiplyer) {
        BufferedImage result = F.getSmaskAppliedImage(gs, currentPdfFile, parserOptions, formLevel, multiplyer);
        PdfObject maskObj = gs.SMask.getDictionary(23);
        currentPdfFile.checkResolved(maskObj);
        float[] BBox = maskObj.getFloatArray(303185736);
        int fx1 = (int)(BBox[0] + 0.5f);
        int fy1 = (int)(BBox[1] + 0.5f);
        int fx2 = (int)(BBox[2] + 0.5f);
        int fy2 = (int)(BBox[3] + 0.5f);
        if (fx1 < 0) {
            fx1 = 0;
        }
        if (fy1 < 0) {
            fy1 = 0;
        }
        int w = fx2 - fx1;
        int h = fy2 - fy1;
        if (w < 0) {
            w = -w;
        } else if (w == 0) {
            w = 1;
        }
        if (h < 0) {
            h = -h;
        } else if (h == 0) {
            h = 1;
        }
        Rectangle rect = new Rectangle(fx1, fy1, w, h);
        GraphicsState gs1 = gs.deepCopy();
        gs1.nonstrokeColorSpace.setColor(new ShearedTexturePaint(result, rect, gs.CTM));
        gs1.setFillType(2);
        gs1.strokeColorSpace.setColor(gs.strokeColorSpace.getColor());
        current.drawShape(currentDrawShape, gs1, 70);
    }

    private static BufferedImage getSmaskAppliedImage(GraphicsState gs, PdfObjectReader currentPdfFile, ParserOptions parserOptions, int formLevel, float multiplyer) {
        PdfObject maskObj = gs.SMask.getDictionary(23);
        currentPdfFile.checkResolved(maskObj);
        float[] BBox = maskObj.getFloatArray(303185736);
        int x1 = (int)(BBox[0] + 0.5f);
        int y1 = (int)(BBox[1] + 0.5f);
        int x2 = (int)(BBox[2] + 0.5f);
        int y2 = (int)(BBox[3] + 0.5f);
        if (x1 < 0) {
            x1 = 0;
        }
        if (y1 < 0) {
            y1 = 0;
        }
        BufferedImage smaskImage = PDFObjectToImage.getImageFromPdfObject(maskObj, x1, x2, y1, y2, currentPdfFile, parserOptions, formLevel, multiplyer, false, 1.0f);
        BufferedImage result = F.blendBackgroundIntoImage(gs, smaskImage);
        smaskImage.flush();
        return result;
    }

    private static BufferedImage blendBackgroundIntoImage(GraphicsState gs, BufferedImage smaskImage) {
        PdfPaint prev = gs.nonstrokeColorSpace.getColor();
        int prevInt = prev.getRGB();
        float[] BC = gs.SMask.getFloatArray(4627);
        int brgb = 0;
        boolean hasBC = false;
        if (BC != null) {
            gs.nonstrokeColorSpace.setColor(BC);
            brgb = gs.nonstrokeColorSpace.getColor().getRGB();
            gs.nonstrokeColorSpace.setColor(prev);
            hasBC = true;
        }
        int pa = prevInt >>> 24;
        int br = brgb >> 16 & 0xFF;
        int bg = brgb >> 8 & 0xFF;
        int bb = brgb & 0xFF;
        BufferedImage result = new BufferedImage(smaskImage.getWidth(), smaskImage.getHeight(), 2);
        int[] sPixels = ((DataBufferInt)smaskImage.getRaster().getDataBuffer()).getData();
        int[] dPixels = ((DataBufferInt)result.getRaster().getDataBuffer()).getData();
        for (int i = 0; i < sPixels.length; ++i) {
            int sargb = sPixels[i];
            int sa = sargb >>> 24 & 0xFF;
            int sr = sargb >> 16 & 0xFF;
            int sg = sargb >> 8 & 0xFF;
            int sb = sargb & 0xFF;
            if (hasBC) {
                if (sa == 0) {
                    sr = br;
                    sg = bg;
                    sb = bb;
                } else if (sa < 255) {
                    int alpha_ = 255 - sa;
                    sr = sr * sa + br * alpha_ >> 8;
                    sg = sg * sa + bg * alpha_ >> 8;
                    sb = sb * sa + bb * alpha_ >> 8;
                }
            }
            int y = sr * 77 + sg * 152 + sb * 28;
            y = pa * y >> 16;
            dPixels[i] = y << 24 | prevInt & 0xFFFFFF;
        }
        return result;
    }

    private static void createSMaskFill(GraphicsState gs, PdfObjectReader currentPdfFile, DynamicVectorRenderer current, ParserOptions parserOptions, int formLevel, float multiplyer) {
        PdfObject maskObj = gs.SMask.getDictionary(23);
        currentPdfFile.checkResolved(maskObj);
        float[] BBox = maskObj.getFloatArray(303185736);
        int fx = (int)(BBox[0] + 0.5f);
        int fy = (int)(BBox[1] + 0.5f);
        int fw = (int)(BBox[2] + 0.5f);
        int fh = (int)(BBox[3] + 0.5f);
        if (fx < 0) {
            fx = 0;
        }
        if (fy < 0) {
            fy = 0;
        }
        BufferedImage smaskImage = PDFObjectToImage.getImageFromPdfObject(maskObj, fx, fw, fy, fh, currentPdfFile, parserOptions, formLevel, multiplyer, false, 1.0f);
        GraphicsState gs1 = gs.deepCopy();
        gs1.CTM = new float[][]{{smaskImage.getWidth(), 0.0f, 0.0f}, {0.0f, -smaskImage.getHeight(), 0.0f}, {0.0f, 0.0f, 1.0f}};
        gs1.x = fx;
        gs1.y = fy;
        gs1.CTM[2][0] = gs1.x;
        gs1.CTM[2][1] = gs1.y;
        PdfPaint prev = gs.nonstrokeColorSpace.getColor();
        int prevInt = prev.getRGB();
        float[] BC = gs.SMask.getFloatArray(4627);
        int brgb = 0;
        if (BC != null) {
            gs.nonstrokeColorSpace.setColor(BC);
            brgb = gs.nonstrokeColorSpace.getColor().getRGB();
            gs.nonstrokeColorSpace.setColor(prev);
        }
        int br = brgb >> 16 & 0xFF;
        int bg = brgb >> 8 & 0xFF;
        int bb = brgb & 0xFF;
        BufferedImage result = new BufferedImage(smaskImage.getWidth(), smaskImage.getHeight(), 2);
        int[] sPixels = ((DataBufferInt)smaskImage.getRaster().getDataBuffer()).getData();
        int[] dPixels = ((DataBufferInt)result.getRaster().getDataBuffer()).getData();
        for (int i = 0; i < sPixels.length; ++i) {
            int sargb = sPixels[i];
            int sa = sargb >>> 24 & 0xFF;
            int sr = sargb >> 16 & 0xFF;
            int sg = sargb >> 8 & 0xFF;
            int sb = sargb & 0xFF;
            if (sa == 0) {
                sr = br;
                sg = bg;
                sb = bb;
            } else if (sa < 255) {
                int alpha_ = 255 - sa;
                sr = sr * sa + br * alpha_ >> 8;
                sg = sg * sa + bg * alpha_ >> 8;
                sb = sb * sa + bb * alpha_ >> 8;
            }
            int y = sr * 77 + sg * 152 + sb * 28;
            sa = sa * y >> 16;
            dPixels[i] = sa << 24 | prevInt & 0xFFFFFF;
        }
        current.drawImage(parserOptions.getPageNumber(), result, gs1, false, "F", -1);
        smaskImage.flush();
    }
}

