/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image.utils;

import java.awt.geom.GeneralPath;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.SwingShape;
import org.jpedal.parser.ParserOptions;
import org.jpedal.render.DynamicVectorRenderer;

public class ConvertImageToShape {
    public static void convert(byte[] data, int h, GraphicsState gs, DynamicVectorRenderer current, ParserOptions parserOptions) {
        float ix = gs.CTM[2][0];
        float iy = gs.CTM[2][1];
        float ih = gs.CTM[1][1];
        float iw = gs.CTM[0][0];
        if (gs.CTM[0][0] == 0.0f && gs.CTM[0][1] > 0.0f && gs.CTM[1][0] != 0.0f && gs.CTM[1][1] == 0.0f) {
            float tmp = ih;
            ih = iw;
            iw = tmp;
        }
        double byteWidth = iw / (float)(data.length / h);
        double bitWidth = byteWidth / 8.0;
        for (int col = 0; col < data.length; ++col) {
            int currentByte = data[col] & 0xFF;
            int bitCount = 8;
            double endX = 0.0;
            boolean draw = false;
            for (currentByte = (currentByte ^ 0xFFFFFFFF) & 0xFF; currentByte != 0 || draw; currentByte >>>= 1) {
                double newValue = ((double)(--bitCount) + 0.5) * bitWidth + (double)col * byteWidth;
                if ((currentByte & 1) == 1) {
                    if (draw) continue;
                    endX = newValue;
                    draw = true;
                    continue;
                }
                if (!draw) continue;
                draw = false;
                double startX = newValue;
                GeneralPath currentShape = new GeneralPath(1);
                currentShape.moveTo((float)((double)ix + startX), iy);
                currentShape.lineTo((float)((double)ix + startX), iy + ih);
                currentShape.lineTo((float)((double)ix + endX), iy + ih);
                currentShape.lineTo((float)((double)ix + endX), iy);
                currentShape.closePath();
                if (!parserOptions.isRenderPage()) continue;
                gs.setFillType(2);
                current.drawShape(new SwingShape(currentShape), gs, 70);
            }
        }
    }
}

