/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image.mask;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.image.JPeg2000ImageDecoder;
import org.jpedal.parser.image.data.ImageData;

public class SMaskDecoder {
    public static byte[] applyJPX_JBIG_Smask(ImageData imageData, ImageData smaskData, byte[] maskData, PdfObject imageObject, PdfObject maskObject, GenericColorSpace colorSpace, GenericColorSpace maskCS) {
        byte[] index;
        byte[] objectData = imageData.getObjectData();
        int iw = imageData.getWidth();
        int ih = imageData.getHeight();
        int id = imageData.getDepth();
        float[] matte = maskObject.getFloatArray(826557522);
        if (matte != null) {
            matte = new float[]{matte[0], matte[0], matte[0]};
        }
        smaskData.getFilter(maskObject);
        if (smaskData.isJPX()) {
            maskData = JPeg2000ImageDecoder.getBytesFromJPEG2000(maskData);
            maskObject.setMixedArray(1011108731, null);
            maskObject.setDecodedStream(maskData);
        } else {
            objectData = ColorSpaceConvertor.normaliseTo8Bit(1, id, iw, ih, objectData);
        }
        int sw = smaskData.getWidth();
        int sh = smaskData.getHeight();
        int sd = smaskData.getDepth();
        float[] decodeArr = maskObject.getFloatArray(859785322);
        if (maskData != null && decodeArr != null && decodeArr[0] == 1.0f && decodeArr[1] == 0.0f) {
            int i = 0;
            while (i < maskData.length) {
                int n = i++;
                maskData[n] = (byte)(maskData[n] ^ 0xFF);
            }
        }
        if ((index = colorSpace.getIndexedMap()) != null) {
            index = colorSpace.convertIndexToRGB(index);
            objectData = ColorSpaceConvertor.convertIndexToRGBByte(index, iw, ih, id, objectData, false, false);
        } else {
            objectData = colorSpace.dataToRGBByteArray(objectData, iw, ih);
        }
        maskData = ColorSpaceConvertor.normaliseTo8Bit(1, sd, sw, sh, maskData);
        int imageDim = iw * ih;
        int maskDim = sw * sh;
        if (imageDim > maskDim) {
            maskData = SMaskDecoder.getScaledBytes(maskData, sw, sh, iw, ih);
        } else if (maskDim > imageDim) {
            objectData = SMaskDecoder.getScaledBytes(objectData, iw, ih, sw, sh);
            imageDim = maskDim;
            iw = sw;
            ih = sh;
        }
        int p = 0;
        ByteBuffer buffer = ByteBuffer.allocate(iw * ih * 4);
        if (imageDim == objectData.length) {
            int aa = 0;
            for (int i = 0; i < imageDim; ++i) {
                byte r = objectData[i];
                for (int j = 0; j < 3; ++j) {
                    buffer.put(r);
                }
                buffer.put(maskData[aa++]);
            }
        } else {
            SMaskDecoder.handleIncorrectlySizedMask(maskData, objectData, iw, ih, matte, imageDim, p, buffer);
        }
        imageObject.setIntNumber(959726687, iw);
        imageObject.setIntNumber(959926393, ih);
        imageObject.setIntNumber(-1344207655, 8);
        return buffer.array();
    }

    private static void handleIncorrectlySizedMask(byte[] maskData, byte[] objectData, int iw, int ih, float[] matte, int imageDim, int p, ByteBuffer buffer) {
        if (matte != null) {
            for (byte aMaskData : maskData) {
                int a = aMaskData & 0xFF;
                int r = objectData[p++] & 0xFF;
                int g = objectData[p++] & 0xFF;
                int b = objectData[p++] & 0xFF;
                if (a != 0) {
                    double k = 255.0 / (double)a;
                    r = (int)((double)((float)r - matte[0]) * k + (double)matte[0]);
                    g = (int)((double)((float)g - matte[1]) * k + (double)matte[1]);
                    b = (int)((double)((float)b - matte[2]) * k + (double)matte[2]);
                    r = r < 0 ? 0 : Math.min(r, 255);
                    g = g < 0 ? 0 : Math.min(g, 255);
                    b = b < 0 ? 0 : Math.min(b, 255);
                }
                byte[] bb = new byte[]{(byte)r, (byte)g, (byte)b, (byte)a};
                buffer.put(bb);
            }
        } else {
            int expected = imageDim * 3;
            if (objectData.length < expected) {
                byte[] temp = new byte[expected];
                System.arraycopy(objectData, 0, temp, 0, objectData.length);
                objectData = temp;
            }
            int iter = Math.min(maskData.length, iw * ih);
            for (int i = 0; i < iter; ++i) {
                buffer.put(new byte[]{objectData[p++], objectData[p++], objectData[p++], maskData[i]});
            }
        }
    }

    private static byte[] getScaledBytes(byte[] data, int sw, int sh, int dw, int dh) {
        if (data.length == sw * sh) {
            return SMaskDecoder.rescaleComponent(data, sw, sh, dw, dh);
        }
        int dim = sw * sh;
        int maxSize = data.length / 3;
        if (dim > maxSize) {
            dim = maxSize;
        }
        byte[] rr = new byte[dim];
        byte[] gg = new byte[dim];
        byte[] bb = new byte[dim];
        int p = 0;
        for (int i = 0; i < dim; ++i) {
            rr[i] = data[p++];
            gg[i] = data[p++];
            bb[i] = data[p++];
        }
        rr = SMaskDecoder.rescaleComponent(rr, sw, sh, dw, dh);
        gg = SMaskDecoder.rescaleComponent(gg, sw, sh, dw, dh);
        bb = SMaskDecoder.rescaleComponent(bb, sw, sh, dw, dh);
        p = 0;
        dim = dw * dh;
        byte[] temp = new byte[dim * 3];
        for (int i = 0; i < dim; ++i) {
            temp[p++] = rr[i];
            temp[p++] = gg[i];
            temp[p++] = bb[i];
        }
        return temp;
    }

    private static byte[] rescaleComponent(byte[] data, int sw, int sh, int dw, int dh) {
        if (data.length == 1) {
            byte a = data[0];
            data = new byte[dw * dh];
            Arrays.fill(data, a);
            return data;
        }
        if (sh == 1) {
            byte[] temp = new byte[2 * sw];
            System.arraycopy(data, 0, temp, 0, sw);
            System.arraycopy(data, 0, temp, sw, sw);
            sh = 2;
            data = temp;
        }
        float ratioW = (float)sw / (float)dw;
        float ratioH = (float)sh / (float)dh;
        byte[] combinedData = new byte[dw * dh];
        int rawDataSize = data.length;
        int i = 0;
        try {
            for (int mY = 0; mY < dh; ++mY) {
                for (int mX = 0; mX < dw; ++mX) {
                    int rgbPtr = (int)((float)mX * ratioW) + (int)((float)mY * ratioH) * sw;
                    if (rgbPtr < rawDataSize) {
                        combinedData[i] = data[rgbPtr];
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return combinedData;
    }
}

