/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image.mask;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import org.jpedal.function.PDFFunction;
import org.jpedal.io.ColorSpaceConvertor;

class SMask {
    SMask() {
    }

    public static BufferedImage applyLuminosityMask(BufferedImage image, BufferedImage smask, int[] tr, boolean hasBC, int bc) {
        int sh;
        int sw;
        int smaskDim;
        int ih;
        int iw;
        int imageDim;
        if (smask == null) {
            return image;
        }
        if (smask.getType() != 2) {
            smask = ColorSpaceConvertor.convertToARGB(smask);
        }
        if (image.getType() != 2) {
            image = ColorSpaceConvertor.convertToARGB(image);
        }
        if ((imageDim = (iw = image.getWidth()) * (ih = image.getHeight())) < (smaskDim = (sw = smask.getWidth()) * (sh = smask.getHeight()))) {
            image = SMask.scaleImage(image, sw, sh);
        } else if (smaskDim < imageDim) {
            smask = SMask.scaleImage(smask, iw, ih);
        }
        int[] imagePixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int[] maskPixels = ((DataBufferInt)smask.getRaster().getDataBuffer()).getData();
        int r0 = bc >> 16 & 0xFF;
        int g0 = bc >> 8 & 0xFF;
        int b0 = bc & 0xFF;
        for (int i = 0; i < imagePixels.length; ++i) {
            int mp = maskPixels[i];
            int a = mp >>> 24;
            int r = mp >> 16 & 0xFF;
            int g = mp >> 8 & 0xFF;
            int b = mp & 0xFF;
            if (hasBC) {
                if (a == 0) {
                    r = r0;
                    g = g0;
                    b = b0;
                } else if (a < 255) {
                    int a_ = 255 - a;
                    r = r * a + r0 * a_ >> 8;
                    g = g * a + g0 * a_ >> 8;
                    b = b * a + b0 * a_ >> 8;
                }
            }
            int y = r * 77 + g * 152 + b * 28;
            int ip = imagePixels[i];
            int resA = ip >> 24 & 0xFF;
            resA = tr != null ? resA * tr[y >> 8] >> 8 : resA * y >> 16;
            imagePixels[i] = resA << 24 | ip & 0xFFFFFF;
        }
        return image;
    }

    public static BufferedImage applyAlphaMask(BufferedImage image, BufferedImage smask, PDFFunction trFunction) {
        int sh;
        int sw;
        int smaskDim;
        int ih;
        int iw;
        int imageDim;
        if (smask == null) {
            return image;
        }
        if (smask.getType() != 2) {
            smask = ColorSpaceConvertor.convertToARGB(smask);
        }
        if (image.getType() != 2) {
            image = ColorSpaceConvertor.convertToARGB(image);
        }
        if ((imageDim = (iw = image.getWidth()) * (ih = image.getHeight())) < (smaskDim = (sw = smask.getWidth()) * (sh = smask.getHeight()))) {
            image = SMask.scaleImage(image, sw, sh);
        } else if (smaskDim < imageDim) {
            smask = SMask.scaleImage(smask, iw, ih);
        }
        int[] imagePixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int[] maskPixels = ((DataBufferInt)smask.getRaster().getDataBuffer()).getData();
        float sc = 0.003921569f;
        for (int i = 0; i < imagePixels.length; ++i) {
            int mp = maskPixels[i];
            int ip = imagePixels[i];
            int ia = ip >> 24 & 0xFF;
            int ma = mp >> 24 & 0xFF;
            if (trFunction != null) {
                ma = (int)(255.0f * trFunction.compute(new float[]{(float)ma / 255.0f})[0]);
            }
            int a = (int)((float)(ia * ma) * 0.003921569f);
            imagePixels[i] = a << 24 | ip & 0xFFFFFF;
        }
        return image;
    }

    private static BufferedImage scaleImage(BufferedImage src, int w, int h) {
        BufferedImage dimg = new BufferedImage(w, h, 2);
        Graphics2D g = dimg.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(src, 0, 0, w, h, null);
        g.dispose();
        return dimg;
    }
}

