/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image.mask;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import org.jpedal.color.ColorspaceFactory;
import org.jpedal.color.DeviceRGBColorSpace;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.function.FunctionFactory;
import org.jpedal.function.PDFFunction;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.raw.FunctionObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.ParserOptions;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.parser.image.PDFObjectToImage;
import org.jpedal.parser.image.mask.SMask;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.render.SwingDisplay;
import org.jpedal.utils.LogWriter;

public class MaskUtils {
    public static void createMaskForm(PdfObject XObject2, String name, PdfObject newSMask, GraphicsState gs, DynamicVectorRenderer current, PdfObjectReader currentPdfFile, ParserOptions parserOptions, int formLevel, float multiplyer, boolean useTransparancy, int blendMode) {
        GraphicsState gs1;
        float[] BBox = MaskUtils.getBBoxScaledByMatrix(XObject2);
        int x1 = (int)BBox[0];
        int y1 = (int)BBox[1];
        int x2 = (int)BBox[2];
        int y2 = (int)BBox[3];
        String upscaleMasks = System.getProperty("org.jpedal.upscaleMasks");
        float scaling = upscaleMasks == null || upscaleMasks.equalsIgnoreCase("true") ? 4.0f : 1.0f;
        if (x1 < 0) {
            x1 = 0;
        }
        if (y1 < 0) {
            y1 = 0;
        }
        BufferedImage image = PDFObjectToImage.getImageFromPdfObject(XObject2, x1, x2, y1, y2, currentPdfFile, parserOptions, formLevel, multiplyer, newSMask == null && useTransparancy, scaling);
        if (newSMask != null) {
            image = MaskUtils.handleSMask(newSMask, gs, currentPdfFile, parserOptions, formLevel, multiplyer, x1, y1, x2, y2, scaling, image);
        }
        int iw = (int)((float)image.getWidth() / scaling);
        int ih = (int)((float)image.getHeight() / scaling);
        boolean isChanged = false;
        if (newSMask == null && gs.getAlphaMax(2) < 1.0f) {
            isChanged = true;
            gs1 = new GraphicsState();
            gs1.setMaxAlpha(2, gs.getAlphaMax(2));
            gs1.setMaxAlpha(1, gs.getAlphaMax(1));
            current.setGraphicsState(1, gs.getAlpha(1), 1111314299);
            current.setGraphicsState(2, gs.getAlpha(2), blendMode);
        } else {
            gs1 = formLevel == 1 ? new GraphicsState(gs) : new GraphicsState();
        }
        int prevBM = gs1.getBMValue();
        gs1.setBMValue(blendMode);
        gs1.CTM = new float[][]{{iw, 0.0f, 0.0f}, {0.0f, ih, 0.0f}, {0.0f, 0.0f, 1.0f}};
        if (parserOptions.isFlattenedForm()) {
            gs1.x = parserOptions.getflattenX();
            gs1.y = parserOptions.getflattenY();
        } else {
            gs1.x = x1;
            gs1.y = y1 < y2 ? (float)y1 : (float)(y1 - ih);
        }
        gs1.CTM[2][0] = gs1.x * gs.CTM[0][0] + gs.CTM[2][0];
        gs1.CTM[2][1] = gs1.y * gs.CTM[1][1] + gs.CTM[2][1];
        float[] fArray = gs1.CTM[0];
        fArray[0] = fArray[0] * gs.CTM[0][0];
        gs1.CTM[1][1] = -gs1.CTM[1][1] * gs.CTM[1][1];
        float[] fArray2 = gs1.CTM[2];
        fArray2[1] = fArray2[1] - gs1.CTM[1][1];
        if (current.isHTMLorSVG()) {
            Area clip = gs.getClippingShape();
            if (clip != null) {
                gs1.updateClip(clip);
            }
            current.drawImage(parserOptions.getPageNumber(), image, gs1, false, name, -2);
        } else {
            gs1.x = gs1.CTM[2][0];
            gs1.y = gs1.CTM[2][1];
            current.drawImage(parserOptions.getPageNumber(), image, gs1, false, name, -1);
        }
        gs1.setBMValue(prevBM);
        if (isChanged) {
            current.setGraphicsState(1, gs.getAlpha(1), gs.getBMValue());
            current.setGraphicsState(2, gs.getAlpha(2), gs.getBMValue());
        }
    }

    private static float[] getBBoxScaledByMatrix(PdfObject XObject2) {
        float[] BBox = XObject2.getFloatArray(303185736);
        float[] matrix = XObject2.getFloatArray(1145198201);
        if (matrix != null) {
            AffineTransform tx = new AffineTransform(matrix);
            Point2D px = new Point2D.Double(1.0, 0.0);
            Point2D py = new Point2D.Double(0.0, 1.0);
            px = tx.deltaTransform(px, px);
            double scaleX = px.distance(0.0, 0.0);
            py = tx.deltaTransform(py, py);
            double scaleY = py.distance(0.0, 0.0);
            BBox[0] = (float)((double)BBox[0] / scaleX);
            BBox[1] = (float)((double)BBox[1] / scaleY);
            BBox[2] = (float)((double)BBox[2] / scaleX);
            BBox[3] = (float)((double)BBox[3] / scaleY);
        }
        return BBox;
    }

    private static BufferedImage handleSMask(PdfObject newSMask, GraphicsState gs, PdfObjectReader currentPdfFile, ParserOptions parserOptions, int formLevel, float multiplyer, int x1, int y1, int x2, int y2, float scaling, BufferedImage image) {
        PDFFunction function;
        BufferedImage smaskImage = PDFObjectToImage.getImageFromPdfObject(newSMask, x1, x2, y1, y2, currentPdfFile, parserOptions, formLevel, multiplyer, false, scaling);
        PdfObject objTR = gs.SMask.getDictionary(9250);
        if (objTR != null) {
            FunctionObject funcObj = new FunctionObject(objTR.getObjectRefAsString());
            currentPdfFile.readObject(funcObj);
            function = FunctionFactory.getFunction(funcObj, currentPdfFile);
        } else {
            function = null;
        }
        if (gs.SMask.getNameAsConstant(35) == -2139971891) {
            int[] tr;
            float[] bcFloats = gs.SMask.getFloatArray(4627);
            if (function != null) {
                tr = new int[256];
                for (int i = 0; i < 256; ++i) {
                    tr[i] = (int)(function.compute(new float[]{(float)i / 255.0f})[0] * 255.0f);
                }
            } else {
                tr = null;
            }
            if (bcFloats != null) {
                int bc = MaskUtils.getBCasRGB(gs, currentPdfFile, bcFloats);
                image = SMask.applyLuminosityMask(image, smaskImage, tr, true, bc);
            } else {
                image = SMask.applyLuminosityMask(image, smaskImage, tr, false, 0);
            }
        } else {
            image = SMask.applyAlphaMask(image, smaskImage, function);
        }
        if (smaskImage != null) {
            smaskImage.flush();
        }
        return image;
    }

    private static int getBCasRGB(GraphicsState gs, PdfObjectReader currentPdfFile, float[] bcFloats) {
        PdfObject group;
        GenericColorSpace decodeColorData = new DeviceRGBColorSpace();
        PdfObject g = gs.SMask.getDictionary(23);
        if (g != null && (group = g.getDictionary(1111442775)) != null) {
            currentPdfFile.checkResolved(group);
            PdfArrayIterator ColorSpace2 = group.getMixedArray(2087749783);
            if (ColorSpace2 != null && ColorSpace2.getTokenCount() > 0) {
                decodeColorData = ColorspaceFactory.getColorSpaceInstance(currentPdfFile, ColorSpace2);
            }
        }
        ((GenericColorSpace)decodeColorData).setColor(bcFloats);
        return decodeColorData.getColor().getRGB();
    }

    public static BufferedImage createTransparentForm(PdfObject XObject2, int fy, int fw, int fh, PdfObjectReader currentPdfFile, ParserOptions parserOptions, int formLevel, float multiplyer) {
        byte[] objectData1 = currentPdfFile.readStream(XObject2, true, true, false, false, false, XObject2.getCacheName(currentPdfFile.getObjectReader()));
        ObjectStore localStore = currentPdfFile.getObjectStore();
        SwingDisplay glyphDisplay = new SwingDisplay(0, false, 20, localStore);
        PdfStreamDecoder glyphDecoder = new PdfStreamDecoder(currentPdfFile);
        glyphDecoder.setParameters(true, true, 3, 65, false);
        glyphDecoder.setObjectValue(-8, localStore);
        glyphDecoder.setFormLevel(formLevel);
        glyphDecoder.setMultiplyer(multiplyer);
        glyphDecoder.setRenderer(glyphDisplay);
        try {
            PdfObject SMaskResources = XObject2.getDictionary(2004251818);
            if (SMaskResources != null) {
                glyphDecoder.readResources(SMaskResources, false);
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        if (objectData1 != null) {
            glyphDecoder.decodeStreamIntoObjects(objectData1, false);
        }
        int hh = fh;
        if (fy > fh) {
            hh = fy - fh;
        }
        int scaling = 4;
        BufferedImage image = new BufferedImage(4 * fw, 4 * hh, 2);
        Graphics2D formG2 = image.createGraphics();
        formG2.translate(0, 4 * hh);
        formG2.scale(1.0, -1.0);
        formG2.scale(4.0, 4.0);
        glyphDisplay.setG2(formG2);
        glyphDisplay.paint(null, null, null);
        return image;
    }
}

