/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ErrorTracker;
import org.jpedal.fonts.CIDFontType0;
import org.jpedal.fonts.CIDFontType2;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.TrueType;
import org.jpedal.fonts.Type1C;
import org.jpedal.fonts.Type3;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.FontObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.parser.FallbackFont;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.StringUtils;

public class PdfFontFactory {
    private boolean hasEmbeddedFonts;
    private String fontsInFile;
    private final ArrayList<String> nonEmbeddedCIDFonts = new ArrayList();
    private final HashMap<String, PdfJavaGlyphs> fontsLoaded = new HashMap(50);
    private final PdfObjectReader currentPdfFile;

    public PdfFontFactory(PdfObjectReader currentPdfFile) {
        this.currentPdfFile = currentPdfFile;
    }

    public PdfFont createFont(boolean fallbackToArial, PdfObject pdfObject, String font_id, ObjectStore objectStoreStreamRef, boolean renderPage, ErrorTracker errorTracker, boolean isHTML) throws PdfException {
        PdfObject descendantFont = pdfObject.getDictionary(-1547306032);
        int fontType = pdfObject.getParameterConstant(1147962727);
        int origFontType = -1;
        if (fontType == 1228944676 && descendantFont != null) {
            origFontType = fontType = descendantFont.getParameterConstant(1147962727);
        }
        boolean isEmbedded = PdfFontFactory.isFontEmbedded(pdfObject);
        FallbackFont fallbackFont = null;
        if (isHTML && !isEmbedded && pdfObject.getParameterConstant(1147962727) != 1228944679 && (fallbackFont = PdfFontFactory.inlineFallbackFontForHTML(pdfObject, font_id, descendantFont)) != null) {
            fontType = descendantFont == null ? 1217103210 : -1684566724;
            isEmbedded = true;
        }
        String subFont = null;
        PdfFont currentFontData = null;
        String rawFont = "";
        boolean isFontBroken = true;
        while (isFontBroken) {
            isFontBroken = false;
            rawFont = "";
            if (FontMappings.fontSubstitutionTable != null && !isEmbedded && pdfObject.getParameterConstant(1147962727) != 1228944679) {
                String fontName;
                rawFont = PdfFontFactory.getFontName(pdfObject, font_id, descendantFont);
                if (rawFont.indexOf(35) != -1) {
                    rawFont = StringUtils.convertHexChars(rawFont);
                }
                if (!(FontMappings.fontSubstitutionTable.get(fontName = PdfFontFactory.stripPostscript(rawFont).toLowerCase()) != null || DecoderOptions.isRunningOnMac && fontName.equals("zapfdingbats"))) {
                    fontName = PdfFontFactory.getAliasedFontName(fontName);
                }
                if (FontMappings.fontSubstitutionTable.get(fontName) == null && rawFont.startsWith("Wingdings") && FontMappings.fontSubstitutionTable.get(fontName = (rawFont = DecoderOptions.isRunningOnMac ? "WingDings" : "WingDing").toLowerCase()) == null) {
                    fontName = PdfFontFactory.getAliasedFontName(fontName);
                }
                String newSubtype = FontMappings.fontSubstitutionTable.get(fontName);
                subFont = FontMappings.fontSubstitutionLocation.get(fontName);
                if (newSubtype != null && descendantFont == null) {
                    fontType = PdfFontFactory.convertStringToFontType(newSubtype);
                    origFontType = pdfObject.getParameterConstant(1147962727);
                }
            }
            if (!isEmbedded && subFont == null && fallbackToArial && fontType != 1228944679) {
                subFont = PdfFontFactory.getSubFont(pdfObject);
            }
            if (fontType == 1228944677 || fontType == -1684566726) {
                fontType = PdfFontFactory.scanForOpenType(pdfObject, this.currentPdfFile, fontType);
            }
            currentFontData = PdfFontFactory.createFont(fontType, this.currentPdfFile, subFont);
            try {
                currentFontData.createFont(pdfObject, font_id, renderPage, objectStoreStreamRef, this.fontsLoaded);
                if (currentFontData.isFontEmbedded || !isEmbedded) continue;
                isFontBroken = true;
                isEmbedded = false;
            }
            catch (Exception e) {
                String error = "Problem " + e + " reading Font type " + StandardFonts.getFontTypeAsString(fontType);
                LogWriter.writeLog("[PDF] " + error);
                errorTracker.addPageFailureMessage(error);
            }
        }
        if (!(fontType != -1684566726 && fontType != -1684566724 || isEmbedded || subFont != null)) {
            this.nonEmbeddedCIDFonts.add(PdfFontFactory.stripPostscript(rawFont).toLowerCase());
        }
        if (currentFontData != null) {
            currentFontData.setRawFontName(rawFont);
            if (fallbackFont != null) {
                currentFontData.setFallbackFont(fallbackFont);
            }
            if (this.fontsInFile == null || !this.fontsInFile.contains(font_id + "  ")) {
                this.setDetails(font_id, currentFontData, fontType, descendantFont, origFontType, subFont);
            }
        }
        return currentFontData;
    }

    private static PdfFont createFont(int fontType, PdfObjectReader currentPdfFile, String subFont) {
        PdfFont currentFontData;
        switch (fontType) {
            case 1217103210: {
                currentFontData = new TrueType(currentPdfFile, subFont);
                break;
            }
            case 1228944679: {
                currentFontData = new Type3(currentPdfFile);
                break;
            }
            case -1684566726: {
                currentFontData = new CIDFontType0(currentPdfFile, subFont);
                break;
            }
            case -1684566724: {
                currentFontData = new CIDFontType2(currentPdfFile, subFont);
                break;
            }
            default: {
                currentFontData = new Type1C(currentPdfFile, subFont);
            }
        }
        if (FontMappings.defaultFont != null) {
            currentFontData.setDefaultDisplayFont(FontMappings.defaultFont);
        }
        return currentFontData;
    }

    private static String getSubFont(PdfObject pdfObject) {
        String subFont;
        String replacementFont = "arial";
        String testFont = pdfObject.getName(678461817);
        if (testFont != null) {
            if ((testFont = testFont.toLowerCase()).contains("bolditalic")) {
                replacementFont = "arial bold italic";
            } else if (testFont.contains("italic")) {
                replacementFont = "arial italic";
            } else if (testFont.contains("bold")) {
                replacementFont = "arial bold";
            }
        }
        if ((subFont = FontMappings.fontSubstitutionLocation.get(replacementFont)) == null) {
            FallbackFont.BaseType baseType = FallbackFont.BaseType.LiberationSans;
            FallbackFont.FontStyle fontStyle = PdfFontFactory.calculateFallbackFontStyle(testFont, 0, baseType);
            FallbackFont fallbackFont = new FallbackFont(baseType, fontStyle);
            FontMappings.addFallBackFont(fallbackFont);
            subFont = FontMappings.fontSubstitutionLocation.get(fallbackFont.getName());
        }
        return subFont;
    }

    private static boolean isJapaneseOrKoreanCIDFont(PdfObject descendantFont) {
        if (descendantFont == null) {
            return false;
        }
        PdfObject systemInfo = descendantFont.getDictionary(1972801240);
        if (systemInfo == null) {
            return false;
        }
        String ordering = systemInfo.getTextStreamValue(1635480172);
        return ordering.equals("Japan1") || ordering.equals("Adobe-Korea1") || ordering.equals("Adobe-KR");
    }

    private static boolean hasNarrowWidths(PdfObject pdfObject) {
        float[] floatWidthValues = pdfObject.getFloatArray(876896124);
        if (floatWidthValues != null && floatWidthValues.length != 0) {
            float total = 0.0f;
            int count = 0;
            for (float width : floatWidthValues) {
                if (width == 0.0f) continue;
                total += width;
                ++count;
            }
            return count > 0 && total / (float)count < 450.0f;
        }
        return false;
    }

    private static FallbackFont.BaseType calculateFallbackBaseType(String fontName, int flags, PdfObject pdfObject, PdfObject descendantFont) {
        FallbackFont.BaseType baseType = fontName.contains("times") ? FallbackFont.BaseType.LiberationSerif : (fontName.contains("narrow") || fontName.contains("light") ? FallbackFont.BaseType.NotoSansCondensed : (PdfFontFactory.isJapaneseOrKoreanCIDFont(descendantFont) ? FallbackFont.BaseType.Unifont : (fontName.contains("arial") ? FallbackFont.BaseType.LiberationSans : ((flags >> 1 & 1) == 1 ? FallbackFont.BaseType.LiberationSerif : (PdfFontFactory.hasNarrowWidths(pdfObject) ? FallbackFont.BaseType.NotoSansCondensed : FallbackFont.BaseType.LiberationSans)))));
        return baseType;
    }

    private static FallbackFont.FontStyle calculateFallbackFontStyle(String fontName, int flags, FallbackFont.BaseType baseType) {
        boolean isBold;
        if (baseType == FallbackFont.BaseType.Unifont) {
            return FallbackFont.FontStyle.Regular;
        }
        boolean isItalic = (flags >> 6 & 1) == 1;
        boolean bl = isBold = (flags >> 18 & 1) == 1;
        FallbackFont.FontStyle fontStyle = fontName.contains("bolditalic") || isBold && isItalic ? FallbackFont.FontStyle.BoldItalic : (fontName.contains("italic") || isItalic ? FallbackFont.FontStyle.Italic : (fontName.contains("bold") || fontName.contains("black") || fontName.contains("medium") || isBold ? FallbackFont.FontStyle.Bold : FallbackFont.FontStyle.Regular));
        return fontStyle;
    }

    private static FallbackFont inlineFallbackFontForHTML(PdfObject pdfObject, String font_id, PdfObject descendantFont) {
        byte[] stream;
        PdfObject fontDescriptor = descendantFont == null ? pdfObject.getDictionary(-1044665361) : descendantFont.getDictionary(-1044665361);
        if (fontDescriptor == null) {
            return null;
        }
        String fontName = PdfFontFactory.getFontName(pdfObject, font_id, descendantFont).toLowerCase();
        int flags = fontDescriptor.getInt(1009858393);
        FallbackFont.BaseType baseType = PdfFontFactory.calculateFallbackBaseType(fontName, flags, pdfObject, descendantFont);
        FallbackFont.FontStyle fontStyle = PdfFontFactory.calculateFallbackFontStyle(fontName, flags, baseType);
        FallbackFont fallbackFont = new FallbackFont(baseType, fontStyle);
        FontMappings.addFallBackFont(fallbackFont);
        String location = FontMappings.fontSubstitutionLocation.get(fallbackFont.getName());
        if (location == null) {
            return null;
        }
        try (RandomAccessFile f = new RandomAccessFile(location, "r");){
            stream = new byte[(int)f.length()];
            f.readFully(stream);
        }
        catch (Exception e) {
            LogWriter.writeLog("[PDF] Exception reading fallback font " + e);
            return null;
        }
        FontObject fontObj = new FontObject(pdfObject.getObjectRefAsString());
        fontObj.setDecodedStream(stream);
        fontDescriptor.setDictionary(2021292334, fontObj);
        return fallbackFont;
    }

    private void setDetails(String font_id, PdfFont currentFontData, int fontType, PdfObject descendantFont, int origFontType, String subFont) {
        String details;
        String name = currentFontData.getFontName();
        if (name.indexOf(35) != -1) {
            name = StringUtils.convertHexChars(name);
        }
        if (currentFontData.isFontSubstituted()) {
            details = font_id + "  " + name + "  " + StandardFonts.getFontTypeAsString(origFontType) + "  Substituted (" + subFont + ' ' + StandardFonts.getFontTypeAsString(fontType) + ')';
        } else if (currentFontData.isFontEmbedded) {
            this.hasEmbeddedFonts = true;
            details = currentFontData.is1C() && descendantFont == null ? font_id + "  " + name + " Type1C  Embedded" : font_id + "  " + name + "  " + StandardFonts.getFontTypeAsString(fontType) + "  Embedded";
        } else {
            details = font_id + "  " + name + "  " + StandardFonts.getFontTypeAsString(fontType);
        }
        this.fontsInFile = this.fontsInFile == null ? details : details + '\n' + this.fontsInFile;
    }

    private static int scanForOpenType(PdfObject pdfObject, PdfObjectReader currentPdfFile, int fontType) {
        if (fontType == -1684566726) {
            PdfObject desc = pdfObject.getDictionary(-1547306032);
            PdfObject FontDescriptor = desc.getDictionary(-1044665361);
            if (FontDescriptor != null) {
                byte[] stream;
                PdfObject FontFile22 = FontDescriptor.getDictionary(2021292334);
                if (FontFile22 == null) {
                    FontFile22 = FontDescriptor.getDictionary(2021292335);
                }
                if (FontFile22 != null && (stream = currentPdfFile.readStream(FontFile22, true, true, false, false, false, FontFile22.getCacheName(currentPdfFile.getObjectReader()))) != null && stream.length > 3 && stream[0] == 79 && stream[1] == 84 && stream[2] == 84 && stream[3] == 79) {
                    fontType = -1684566724;
                }
            }
        } else {
            byte[] stream;
            PdfObject FontFile3;
            PdfObject FontDescriptor = pdfObject.getDictionary(-1044665361);
            if (FontDescriptor != null && (FontFile3 = FontDescriptor.getDictionary(2021292335)) != null && (stream = currentPdfFile.readStream(FontFile3, true, true, false, false, false, FontFile3.getCacheName(currentPdfFile.getObjectReader()))) != null && stream.length > 3 && stream[0] == 79 && stream[1] == 84 && stream[2] == 84 && stream[3] == 79) {
                fontType = 1217103210;
            }
        }
        return fontType;
    }

    private static int convertStringToFontType(String newSubtype) {
        switch (newSubtype) {
            case "/Type1": 
            case "/Type1C": 
            case "/MMType1": {
                return 1228944677;
            }
            case "/TrueType": {
                return 1217103210;
            }
            case "/Type3": {
                return 1228944679;
            }
        }
        throw new RuntimeException("Unknown font type " + newSubtype + " used for font substitution");
    }

    private static String getFontName(PdfObject pdfObject, String font_id, PdfObject descendantFont) {
        String rawFont = descendantFont == null ? pdfObject.getName(678461817) : descendantFont.getName(678461817);
        if (rawFont == null) {
            rawFont = pdfObject.getName(506543413);
        }
        if (rawFont == null) {
            rawFont = font_id;
        }
        return rawFont;
    }

    private static String stripPostscript(String name) {
        return name.indexOf(43) == 6 ? name.substring(7) : name;
    }

    private static String getAliasedFontName(String rawFont) throws PdfException {
        String nextFont;
        String testFont = rawFont;
        String result = "";
        HashSet<String> fontsMapped = new HashSet<String>(50);
        while ((nextFont = FontMappings.fontSubstitutionAliasTable.get(testFont)) != null) {
            testFont = nextFont;
            if (FontMappings.fontSubstitutionTable.get(testFont) != null) {
                result = testFont;
            }
            if (fontsMapped.contains(testFont)) {
                StringBuilder errorMessage = new StringBuilder("[PDF] Circular font mapping for fonts");
                for (Object o : fontsMapped.toArray()) {
                    errorMessage.append(' ');
                    errorMessage.append(o);
                }
                throw new PdfException(errorMessage.toString());
            }
            fontsMapped.add(nextFont);
        }
        return result;
    }

    public static boolean isFontEmbedded(PdfObject pdfObject) {
        PdfObject descFontObj;
        int fontType = pdfObject.getParameterConstant(1147962727);
        if (fontType == 1228944676) {
            pdfObject = pdfObject.getDictionary(-1547306032);
        }
        if ((descFontObj = pdfObject.getDictionary(-1044665361)) == null) {
            return false;
        }
        return descFontObj.hasStream();
    }

    public String getNonEmbeddedCIDFonts() {
        if (this.nonEmbeddedCIDFonts.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.nonEmbeddedCIDFonts.get(0));
        for (int i = 1; i < this.nonEmbeddedCIDFonts.size(); ++i) {
            sb.append(',').append(this.nonEmbeddedCIDFonts.get(i));
        }
        return sb.toString();
    }

    public String getFontsInFile() {
        return this.fontsInFile;
    }

    public void resetFontsInFile() {
        this.fontsInFile = "";
    }

    public boolean hasEmbeddedFonts() {
        return this.hasEmbeddedFonts;
    }

    public boolean hasNonEmbeddedCIDFonts() {
        return !this.nonEmbeddedCIDFonts.isEmpty();
    }
}

