/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

public class FallbackFont {
    private final BaseType baseType;
    private final FontStyle fontStyle;

    FallbackFont(BaseType baseType, FontStyle fontStyle) {
        this.baseType = baseType;
        this.fontStyle = fontStyle;
    }

    public String getName() {
        return this.baseType.toString() + '-' + (Object)((Object)this.fontStyle);
    }

    public String getPath() {
        return this.baseType.path;
    }

    public boolean isUnicode() {
        return this.baseType.isUnicode;
    }

    public int getUnitsPerEm() {
        return this.baseType.unitsPerEm;
    }

    public static enum FontStyle {
        Regular,
        Bold,
        Italic,
        BoldItalic;

    }

    public static enum BaseType {
        LiberationSerif(false, "liberation-serif", 2048),
        LiberationSans(false, "liberation-sans", 2048),
        NotoSansCondensed(false, "notosans-condensed", 1000),
        Unifont(true, "unifont", 1024);

        private final boolean isUnicode;
        private final String path;
        private final int unitsPerEm;

        private BaseType(boolean isUnicode, String path, int unitsPerEm) {
            this.isUnicode = isUnicode;
            this.path = path;
            this.unitsPerEm = unitsPerEm;
        }
    }
}

