/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.raw;

import org.jpedal.objects.acroforms.utils.ConvertToString;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.StringUtils;

public class MKObject
extends FormObject {
    private float[] BC;
    private float[] BG;
    private String AC;
    private String CA;
    private String RC;
    private byte[] rawAC;
    private byte[] rawCA;
    private byte[] rawRC;
    private int TP = -1;
    private int R;
    private PdfObject I;

    public String toString() {
        return "BC=" + ConvertToString.convertArrayToString(this.getFloatArray(4627)) + " BG=" + ConvertToString.convertArrayToString(this.getFloatArray(4631)) + " AC=" + this.getTextStreamValue(4371) + " CA=" + this.getTextStreamValue(4881) + " RC=" + this.getTextStreamValue(8723) + " TP=" + this.TP + " R=" + this.R + " I=" + this.I;
    }

    @Override
    public PdfObject duplicate() {
        int[] floatStreams;
        int[] textStreams;
        MKObject copy = new MKObject();
        int sourceTP = this.getInt(9248);
        if (sourceTP != -1) {
            copy.setIntNumber(9248, sourceTP);
        }
        int sourceR = this.getInt(34);
        copy.setIntNumber(34, sourceR);
        for (int textStream : textStreams = new int[]{4371, 4881, 8723}) {
            byte[] bytes = this.getTextStreamValueAsByte(textStream);
            if (bytes == null) continue;
            copy.setTextStreamValue(textStream, bytes);
        }
        for (int floatStream : floatStreams = new int[]{4627, 4631}) {
            float[] floats = this.getFloatArray(floatStream);
            if (floats == null) continue;
            copy.setFloatArray(floatStream, floats);
        }
        if (this.I != null) {
            copy.I = this.I.duplicate();
        }
        return copy;
    }

    public MKObject(String ref) {
        super(ref);
    }

    public MKObject(int ref, int gen) {
        super(ref, gen);
    }

    public MKObject() {
    }

    @Override
    public PdfObject getDictionary(int id) {
        if (id == 25) {
            return this.I;
        }
        return super.getDictionary(id);
    }

    @Override
    public void setIntNumber(int id, int value) {
        switch (id) {
            case 34: {
                this.R = value;
                break;
            }
            case 9248: {
                this.TP = value;
                break;
            }
            default: {
                super.setIntNumber(id, value);
            }
        }
    }

    @Override
    public int getInt(int id) {
        switch (id) {
            case 34: {
                return this.R;
            }
            case 9248: {
                return this.TP;
            }
        }
        return super.getInt(id);
    }

    @Override
    public void setDictionary(int id, PdfObject value) {
        value.setID(id);
        if (id == 25) {
            this.I = value;
        } else {
            super.setDictionary(id, value);
        }
    }

    @Override
    public float[] getFloatArray(int id) {
        switch (id) {
            case 4627: {
                return this.BC;
            }
            case 4631: {
                return this.BG;
            }
        }
        return super.getFloatArray(id);
    }

    @Override
    public void setFloatArray(int id, float[] value) {
        switch (id) {
            case 4627: {
                this.BC = value;
                break;
            }
            case 4631: {
                this.BG = value;
                break;
            }
            default: {
                super.setFloatArray(id, value);
            }
        }
    }

    @Override
    public byte[] getTextStreamValueAsByte(int id) {
        switch (id) {
            case 4371: {
                return this.rawAC;
            }
            case 4881: {
                return this.rawCA;
            }
            case 8723: {
                return this.rawRC;
            }
        }
        return super.getTextStreamValueAsByte(id);
    }

    @Override
    public void setTextStreamValue(int id, byte[] value) {
        switch (id) {
            case 4371: {
                this.rawAC = value;
                break;
            }
            case 4881: {
                this.rawCA = value;
                break;
            }
            case 8723: {
                this.rawRC = value;
                break;
            }
            default: {
                super.setTextStreamValue(id, value);
            }
        }
    }

    @Override
    public String getTextStreamValue(int id) {
        switch (id) {
            case 4371: {
                if (this.AC == null && this.rawAC != null) {
                    this.AC = StringUtils.getTextString(this.rawAC, false);
                }
                return this.AC;
            }
            case 4881: {
                if (this.CA == null && this.rawCA != null) {
                    this.CA = StringUtils.getTextString(this.rawCA, false);
                }
                return this.CA;
            }
            case 8723: {
                if (this.RC == null && this.rawRC != null) {
                    this.RC = StringUtils.getTextString(this.rawRC, false);
                }
                return this.RC;
            }
        }
        return super.getTextStreamValue(id);
    }

    @Override
    public int getObjectType() {
        return 7451;
    }
}

