/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.raw;

import org.jpedal.objects.raw.PdfObject;

public class CompressedObject
extends PdfObject {
    private int[] Index;
    private int[] W;
    private byte[][] ID;
    private int First;
    private int Prev = -1;
    private int XRefStm = -1;
    private PdfObject Encrypt;
    private PdfObject Extends;
    private PdfObject Info;
    private PdfObject Root;
    private int Size;

    public CompressedObject(String ref) {
        super(ref);
    }

    public CompressedObject(int ref, int gen) {
        super(ref, gen);
    }

    @Override
    public PdfObject getDictionary(int id) {
        switch (id) {
            case 1113489015: {
                return this.Encrypt;
            }
            case 894663815: {
                return this.Extends;
            }
            case 423507519: {
                return this.Info;
            }
            case 574570308: {
                return this.Root;
            }
        }
        return super.getDictionary(id);
    }

    @Override
    public void setIntNumber(int id, int value) {
        switch (id) {
            case 960643930: {
                this.First = value;
                break;
            }
            case 541209926: {
                if (this.Prev != -1) break;
                this.Prev = value;
                break;
            }
            case 590957109: {
                this.Size = value;
                break;
            }
            case 910911090: {
                this.XRefStm = value;
                break;
            }
            default: {
                super.setIntNumber(id, value);
            }
        }
    }

    @Override
    public int getInt(int id) {
        switch (id) {
            case 960643930: {
                return this.First;
            }
            case 541209926: {
                return this.Prev;
            }
            case 590957109: {
                return this.Size;
            }
            case 910911090: {
                return this.XRefStm;
            }
        }
        return super.getInt(id);
    }

    @Override
    public void setDictionary(int id, PdfObject value) {
        value.setID(id);
        switch (id) {
            case 1113489015: {
                this.Encrypt = value;
                break;
            }
            case 894663815: {
                this.Extends = value;
                break;
            }
            case 423507519: {
                this.Info = value;
                break;
            }
            case 574570308: {
                this.Root = value;
                break;
            }
            default: {
                super.setDictionary(id, value);
            }
        }
    }

    @Override
    public int setConstant(int pdfKeyType, int keyStart, int keyLength, byte[] raw) {
        int id = PdfObject.getId(keyStart, keyLength, raw);
        int PDFvalue = super.setConstant(pdfKeyType, id);
        switch (pdfKeyType) {
            case 489767774: {
                this.generalType = PDFvalue;
                break;
            }
            case 9250: {
                this.generalType = PDFvalue;
            }
        }
        return PDFvalue;
    }

    @Override
    public int[] getIntArray(int id) {
        switch (id) {
            case 1043608929: {
                return CompressedObject.deepCopy(this.Index);
            }
            case 39: {
                return CompressedObject.deepCopy(this.W);
            }
        }
        return super.getIntArray(id);
    }

    @Override
    public void setIntArray(int id, int[] value) {
        switch (id) {
            case 1043608929: {
                this.Index = value;
                break;
            }
            case 39: {
                this.W = value;
                break;
            }
            default: {
                super.setIntArray(id, value);
            }
        }
    }

    @Override
    public byte[][] getStringArray(int id) {
        if (id == 6420) {
            return CompressedObject.deepCopy(this.ID);
        }
        return super.getStringArray(id);
    }

    @Override
    public void setStringArray(int id, byte[][] value) {
        if (id == 6420) {
            this.ID = value;
        } else {
            super.setStringArray(id, value);
        }
    }

    @Override
    public boolean decompressStreamWhenRead() {
        return true;
    }

    @Override
    public int getObjectType() {
        return 23;
    }
}

