/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.javascript.functions;

import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.javascript.functions.AFNumber;
import org.jpedal.objects.javascript.functions.JSFunction;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.sun.PrintfFormat;

public class AFPercent
extends AFNumber {
    public AFPercent(AcroRenderer acro, FormObject formObject) {
        super(acro, formObject);
    }

    @Override
    public int execute(String js, String[] args, int type, int event, char keyPressed) {
        int messageCode = 0;
        if (args == null) {
            org.jpedal.objects.javascript.functions.AFPercent.debug("Unknown implementation in " + js);
        } else if (args.length < 1) {
            org.jpedal.objects.javascript.functions.AFPercent.debug("Values length is less than 1");
        } else {
            int gapFormat;
            int decCount = JSFunction.getStaticDecimalCount();
            if (decCount == -1) {
                decCount = Integer.parseInt(args[1]);
            }
            if ((gapFormat = JSFunction.getStaticGapFormat()) == -1) {
                gapFormat = Integer.parseInt(args[2]);
            }
            switch (type) {
                case 1: {
                    messageCode = this.validateNumber(type, event, decCount, gapFormat, 0, "", true);
                    break;
                }
                case 3: {
                    String currentVal = (String)this.formObject.getFormValue();
                    float number = 0.0f;
                    String mask = "";
                    if (currentVal != null && !currentVal.isEmpty()) {
                        StringBuffer numValu = org.jpedal.objects.javascript.functions.AFPercent.convertStringToNumber(currentVal, gapFormat);
                        if (numValu.length() > 0) {
                            number = Float.parseFloat(numValu.toString()) * 100.0f;
                        }
                        mask = mask + '%' + gapFormat + '.' + decCount + 'f';
                        currentVal = new PrintfFormat(mask).sprintf(number) + '%';
                    } else {
                        currentVal = "";
                    }
                    this.formObject.setLastValidValue(currentVal);
                    this.formObject.updateValue(currentVal, false, true);
                    break;
                }
                default: {
                    org.jpedal.objects.javascript.functions.AFPercent.debug("Unknown type " + args[0] + " in " + js);
                }
            }
        }
        return messageCode;
    }
}

