/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.javascript.functions;

import java.awt.Color;
import java.awt.Component;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.javascript.functions.JSFunction;
import org.jpedal.objects.raw.FormObject;

public class AFNumber
extends JSFunction {
    public AFNumber(AcroRenderer acro, FormObject formObject) {
        super(acro, formObject);
    }

    @Override
    public int execute(String js, String[] args, int type, int event, char keyPressed) {
        this.value = this.formObject.getObjectRefAsString();
        int messageCode = 0;
        if (args == null) {
            org.jpedal.objects.javascript.functions.AFNumber.debug("Unknown implementation in " + js);
        } else if (args.length < 1) {
            org.jpedal.objects.javascript.functions.AFNumber.debug("Values length is less than 1");
        } else {
            boolean broken = false;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].length() >= 1) continue;
                org.jpedal.objects.javascript.functions.AFNumber.debug("Value[" + i + "] length is less than 1");
                broken = true;
            }
            if (!broken) {
                int gapFormat;
                int decCount = JSFunction.getStaticDecimalCount();
                if (decCount == -1) {
                    decCount = Integer.parseInt(args[1]);
                }
                if ((gapFormat = JSFunction.getStaticGapFormat()) == -1) {
                    gapFormat = Integer.parseInt(args[2]);
                }
                int minusFormat = Integer.parseInt(args[3]);
                String currencyMask = org.jpedal.objects.javascript.functions.AFNumber.stripQuotes(args[5]);
                boolean hasCurrencySymbol = Boolean.parseBoolean(args[6]);
                if (gapFormat == 2 || gapFormat == 3) {
                    this.DECIMAL_IS_COMMA = true;
                }
                if (event == 1) {
                    boolean isValidForNumber;
                    String actualValue = (String)this.formObject.getFormValue();
                    boolean bl = isValidForNumber = keyPressed >= '0' && keyPressed <= '9' || keyPressed == '-' && actualValue.indexOf(keyPressed) == -1 || keyPressed == '.' && actualValue.indexOf(keyPressed) == -1 && gapFormat != 2 || keyPressed == ',' && actualValue.indexOf(keyPressed) == -1 && gapFormat == 2;
                    if (!isValidForNumber) {
                        messageCode = 1;
                    }
                } else {
                    messageCode = this.validateNumber(type, event, decCount, gapFormat, minusFormat, currencyMask, hasCurrencySymbol);
                }
            }
        }
        if (messageCode == 1) {
            this.value = null;
        }
        return messageCode;
    }

    int validateNumber(int type, int event, int decCount, int gapFormat, int minusFormat, String currencyMask, boolean hasCurrencySymbolAtFront) {
        boolean messageCode = false;
        String currentVal = (String)this.formObject.getFormValue();
        String processedVal = "";
        if (type == 1) {
            currentVal = org.jpedal.objects.javascript.functions.AFNumber.convertStringToNumber(currentVal, gapFormat).toString();
            if (gapFormat > 1) {
                if (event == 6) {
                    processedVal = org.jpedal.objects.javascript.functions.AFNumber.applyRegexp(currentVal, new String[]{"[+-]?\\d+([.,]\\d+)?", "[+-]?[.,]\\d+", "[+-]?\\d+[.,]"});
                } else if (event == 2) {
                    processedVal = currentVal;
                }
            } else if (event == 6) {
                processedVal = org.jpedal.objects.javascript.functions.AFNumber.applyRegexp(currentVal, new String[]{"[+-]?\\d+(\\.\\d+)?", "[+-]?\\.\\d+", "[+-]?\\d+\\."});
            } else if (event == 2) {
                processedVal = currentVal;
            }
            if (!processedVal.equals(currentVal) && currentVal.indexOf(45) <= 0) {
                this.formObject.updateValue(this.formObject.getLastValidValue(), false, true);
            } else if (event == 6) {
                org.jpedal.objects.javascript.functions.AFNumber.eventFocus(decCount, gapFormat, minusFormat, currencyMask, hasCurrencySymbolAtFront, currentVal, this.DECIMAL_IS_COMMA, this.formObject);
            }
        }
        return 0;
    }

    private static void eventFocus(int decCount, int gapFormat, int minusFormat, String currencyMask, boolean hasCurrencySymbolAtFront, String currentVal, boolean DECIMAL_IS_COMMA, FormObject formObject) {
        if (currentVal.indexOf(45) > 0) {
            currentVal = currentVal.charAt(0) + currentVal.substring(1).replaceAll("-", "");
        }
        if (currentVal.isEmpty()) {
            currentVal = "";
        } else {
            String decimal;
            String sep;
            boolean isNegative;
            double number = DECIMAL_IS_COMMA ? Double.parseDouble(currentVal.replaceAll(",", ".")) : Double.parseDouble(currentVal);
            boolean bl = isNegative = number < 0.0;
            if (currentVal.charAt(0) == '-' && number == 0.0) {
                number = 0.0;
            }
            if (number < 0.0) {
                number = -number;
            }
            switch (gapFormat) {
                case 1: {
                    sep = "";
                    decimal = ".";
                    break;
                }
                case 2: {
                    sep = ".";
                    decimal = ",";
                    break;
                }
                case 3: {
                    sep = "";
                    decimal = ",";
                    break;
                }
                default: {
                    sep = ",";
                    decimal = ".";
                }
            }
            currentVal = org.jpedal.objects.javascript.functions.AFNumber.crteateValue(decCount, minusFormat, currencyMask, hasCurrencySymbolAtFront, number, isNegative, sep, decimal);
            if (minusFormat == 1 || minusFormat == 3) {
                org.jpedal.objects.javascript.functions.AFNumber.setColor(formObject, isNegative);
            }
        }
        formObject.updateValue(currentVal, false, true);
    }

    private static String crteateValue(int decCount, int minusFormat, String currencyMask, boolean hasCurrencySymbolAtFront, double number, boolean isNegative, String sep, String decimal) {
        StringBuilder mask = new StringBuilder("###");
        if (!sep.isEmpty()) {
            mask.append(',');
        }
        mask.append("##");
        if (decCount != 0) {
            mask.append("0.0");
            for (int i = 1; i < decCount; ++i) {
                mask.append('0');
            }
        } else {
            mask.append('#');
        }
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator(decimal.charAt(0));
        if (!sep.isEmpty()) {
            dfs.setGroupingSeparator(sep.charAt(0));
        }
        String currentVal = new DecimalFormat(mask.toString(), dfs).format(number);
        StringBuilder rawValue = new StringBuilder(currentVal);
        if (hasCurrencySymbolAtFront) {
            rawValue.insert(0, currencyMask);
        }
        if (isNegative && (minusFormat == 2 || minusFormat == 3)) {
            rawValue.insert(0, '(');
        }
        if (!hasCurrencySymbolAtFront) {
            rawValue.append(currencyMask);
        }
        if (isNegative && (minusFormat == 2 || minusFormat == 3)) {
            rawValue.append(')');
        }
        if (isNegative && minusFormat != 1 && minusFormat != 3) {
            rawValue.insert(0, '-');
        }
        currentVal = rawValue.toString();
        return currentVal;
    }

    private static void setColor(FormObject formObject, boolean isNegative) {
        Color textColor = isNegative ? Color.RED : Color.BLACK;
        if (formObject.getGUIComponent() != null) {
            ((Component)formObject.getGUIComponent()).setForeground(textColor);
        }
    }

    static StringBuffer convertStringToNumber(String currentVal, int gapFormat) {
        char decVal;
        int charCount;
        if (currentVal == null || (charCount = currentVal.length()) == 0) {
            return new StringBuffer(0);
        }
        StringBuffer numValu = new StringBuffer();
        switch (gapFormat) {
            case 1: {
                decVal = '.';
                break;
            }
            case 2: {
                decVal = ',';
                break;
            }
            case 3: {
                decVal = ',';
                break;
            }
            default: {
                decVal = '.';
            }
        }
        boolean hasDecPoint = false;
        for (int i = 0; i < charCount; ++i) {
            char c = currentVal.charAt(i);
            if ((i != 0 || c != '-') && (hasDecPoint || c != '.' && c != ',') && (c < '0' || c > '9')) continue;
            if (c == '.' || c == ',') {
                if (c != decVal) continue;
                hasDecPoint = true;
                numValu.append('.');
                continue;
            }
            numValu.append(c);
        }
        return numValu;
    }
}

