/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.linear;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.FileAccess;
import org.jpedal.exception.PdfException;
import org.jpedal.io.LinearizedHintTable;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.io.security.CryptoIDR;
import org.jpedal.linear.LinearThread;
import org.jpedal.objects.raw.LinearizedObject;
import org.jpedal.objects.raw.PageObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.NumberUtils;
import org.jpedal.utils.repositories.FastByteArrayOutputStream;

public class LinearParser {
    private boolean isLinearizationTested;
    private PageObject linObject;
    private final Map<Integer, PageObject> linObjects = new HashMap<Integer, PageObject>();
    private int linearPageCount = -1;
    private PdfObject linearObj;
    private LinearizedHintTable linHintTable;
    private int E = -1;
    public LinearThread linearizedBackgroundReaderer;

    public void closePdfFile() {
        this.E = -1;
        this.linearObj = null;
        this.isLinearizationTested = false;
        this.linObjects.clear();
        if (this.linearizedBackgroundReaderer != null && this.linearizedBackgroundReaderer.isAlive()) {
            this.linearizedBackgroundReaderer.interrupt();
        }
        while (this.linearizedBackgroundReaderer != null && this.linearizedBackgroundReaderer.isAlive()) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        this.linHintTable = null;
    }

    private void testForLinearlized(byte[] buffer, PdfObjectReader currentPdfFile) {
        int start = 0;
        int end = 0;
        boolean isLinear = false;
        int len = buffer.length;
        for (int i = 0; i < len; ++i) {
            if (start == 0 && i + 2 < len && buffer[i] == 111 && buffer[i + 1] == 98 && buffer[i + 2] == 106) {
                start = i + 3;
                continue;
            }
            if (end == 0 && i + 5 < len && buffer[i] == 101 && buffer[i + 1] == 110 && buffer[i + 2] == 100 && buffer[i + 3] == 111 && buffer[i + 4] == 98 && buffer[i + 5] == 106) {
                end = i + 7;
                continue;
            }
            if (isLinear || i + 6 >= len || buffer[i] != 47 || buffer[i + 1] != 76 || buffer[i + 2] != 105 || buffer[i + 3] != 110 || buffer[i + 4] != 101 || buffer[i + 5] != 97 || buffer[i + 6] != 114) continue;
            isLinear = true;
        }
        if (isLinear) {
            int dataLength = end - start;
            byte[] data = new byte[dataLength + 1];
            System.arraycopy(buffer, start, data, 0, dataLength);
            this.linearObj = new LinearizedObject("0 0 R");
            this.linearObj.setStatus(2);
            this.linearObj.setUnresolvedData(data, 2004845231);
            currentPdfFile.checkResolved(this.linearObj);
        } else {
            this.linearObj = null;
        }
    }

    public boolean isPageAvailable(int rawPage, PdfObjectReader currentPdfFile) {
        boolean isPageAvailable = true;
        try {
            if (this.linearizedBackgroundReaderer != null && this.linearizedBackgroundReaderer.isAlive() && rawPage > 1 && this.linHintTable != null) {
                Integer key = rawPage;
                if (this.linObjects.containsKey(key)) {
                    this.linObject = this.linObjects.get(key);
                    return true;
                }
                int objID = this.linHintTable.getPageObjectRef(rawPage);
                byte[] pageData = this.linHintTable.getObjData(objID);
                if (pageData != null) {
                    this.linObject = new PageObject(objID + " 0 R");
                    this.linObject.setStatus(2);
                    this.linObject.setUnresolvedData(pageData, 540096309);
                    this.linObject.isDataExternal(true);
                    PdfFileReader objectReader = currentPdfFile.getObjectReader();
                    if (!ObjectDecoder.resolveFully(this.linObject, objectReader)) {
                        isPageAvailable = false;
                    } else {
                        if (this.linObject != null) {
                            byte[] b_data = currentPdfFile.getObjectReader().readPageIntoStream(this.linObject);
                            if (b_data == null) {
                                isPageAvailable = false;
                            } else {
                                PdfObject Resources = this.linObject.getDictionary(2004251818);
                                if (Resources == null) {
                                    this.linObject = null;
                                    isPageAvailable = false;
                                } else if (!ObjectDecoder.resolveFully(Resources, objectReader)) {
                                    this.linObject = null;
                                    isPageAvailable = false;
                                } else {
                                    Resources.isDataExternal(true);
                                    new PdfStreamDecoder(currentPdfFile).readResources(Resources, true);
                                    if (!Resources.isFullyResolved()) {
                                        this.linObject = null;
                                        isPageAvailable = false;
                                    }
                                }
                            }
                        }
                        if (isPageAvailable && this.linObject != null) {
                            this.linObjects.put(key, this.linObject);
                        }
                    }
                } else {
                    isPageAvailable = false;
                }
            } else {
                this.linObject = null;
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
            isPageAvailable = false;
        }
        return isPageAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readLinearData(byte[] password, PdfObjectReader currentPdfFile, File tempURLFile, InputStream is, FileAccess fileAccess) throws IOException {
        int read;
        FileChannel fos = new RandomAccessFile(tempURLFile, "rws").getChannel();
        fos.force(true);
        FastByteArrayOutputStream bos = new FastByteArrayOutputStream(8192);
        CryptoIDR crypto = null;
        if (password != null) {
            crypto = new CryptoIDR(password);
        }
        byte[] buffer = new byte[4096];
        int bytesRead = 0;
        while ((read = is.read(buffer)) != -1) {
            if (read > 0) {
                FileChannel fileChannel = fos;
                synchronized (fileChannel) {
                    byte[] b = new byte[read];
                    System.arraycopy(buffer, 0, b, 0, read);
                    if (password != null) {
                        b = crypto.encrypt(b, bytesRead);
                    }
                    ByteBuffer f = ByteBuffer.wrap(b);
                    fos.write(f);
                }
            }
            bytesRead += read;
            if (this.E != -1) {
                bos.write(buffer, 0, read);
                if (this.E >= bytesRead) continue;
                byte[] linearBytes = bos.toByteArray();
                this.linHintTable = new LinearizedHintTable(fos, password);
                currentPdfFile.getObjectReader().storeLinearizedTables(this.linHintTable);
                this.linearizedBackgroundReaderer = new LinearThread(is, fos, password, tempURLFile, this.linearObj, linearBytes, this.linHintTable, fileAccess);
                return linearBytes;
            }
            if (this.isLinearizationTested) continue;
            this.isLinearizationTested = true;
            this.testForLinearlized(buffer, currentPdfFile);
            if (this.linearObj == null) continue;
            this.E = this.linearObj.getInt(21);
            bos.write(buffer, 0, read);
        }
        return null;
    }

    public PdfObject readHintTable(PdfObjectReader currentPdfFile) throws PdfException {
        PdfObject pdfObject;
        long Ooffset = -1L;
        this.linearPageCount = -1;
        int O = this.linearObj.getInt(31);
        if (O != -1) {
            this.linearObj.setIntNumber(31, -1);
            currentPdfFile.getObjectReader().readReferenceTable(this.linearObj, currentPdfFile.getObjectReader());
            pdfObject = new PageObject(O, 0);
            currentPdfFile.readObject(pdfObject);
            this.linearPageCount = this.linearObj.getInt(30);
            Ooffset = currentPdfFile.getObjectReader().getOffset(O);
        } else {
            pdfObject = currentPdfFile.getObjectReader().readReferenceTable(null, currentPdfFile.getObjectReader());
        }
        int[] H = this.linearObj.getIntArray(24);
        byte[] hintStream = currentPdfFile.getObjectReader().getBytes(H[0], H[1]);
        int length = hintStream.length;
        int startHint = 0;
        int i = 0;
        boolean contentIsDodgy = false;
        int keyStart2 = i;
        while (hintStream[i] != 10 && hintStream[i] != 13 && hintStream[i] != 32 && hintStream[i] != 47 && hintStream[i] != 60 && hintStream[i] != 62) {
            if (hintStream[i] < 48 || hintStream[i] > 57) {
                contentIsDodgy = true;
                break;
            }
            ++i;
        }
        if (!contentIsDodgy) {
            int number = NumberUtils.parseInt(keyStart2, i, hintStream);
            while (hintStream[i] == 10 || hintStream[i] == 13 || hintStream[i] == 32 || hintStream[i] == 47 || hintStream[i] == 60) {
                ++i;
            }
            keyStart2 = i;
            while (i < 10 && hintStream[i] != 10 && hintStream[i] != 13 && hintStream[i] != 32 && hintStream[i] != 47 && hintStream[i] != 60 && hintStream[i] != 62) {
                ++i;
            }
            int generation = NumberUtils.parseInt(keyStart2, i, hintStream);
            while (i < length - 1) {
                if (hintStream[i] == 60 && hintStream[i + 1] == 60) {
                    startHint = i;
                    i = length;
                }
                ++i;
            }
            byte[] data = new byte[length - startHint];
            System.arraycopy(hintStream, startHint, data, 0, data.length);
            LinearizedObject hintObj = new LinearizedObject(number, generation);
            hintObj.setStatus(2);
            hintObj.setUnresolvedData(data, 2004845231);
            currentPdfFile.checkResolved(hintObj);
            this.linHintTable.readTable(hintObj, this.linearObj, O, Ooffset);
        }
        return pdfObject;
    }

    public int getPageCount() {
        return this.linearPageCount;
    }

    public boolean hasLinearData() {
        return this.linearObj != null && this.E != -1;
    }

    public PdfObject getLinearPageObject() {
        return this.linObject;
    }

    public PdfObject getLinearObject(boolean isOpen, PdfObjectReader currentPdfFile) {
        if (!this.isLinearizationTested && isOpen) {
            this.isLinearizationTested = true;
            this.testForLinearlized(currentPdfFile.getObjectReader().getBytes(0L, 400), currentPdfFile);
        }
        return this.linearObj;
    }
}

