/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.jbig2.segment.region.refinement;

import java.io.IOException;
import org.jpedal.jbig2.JBIG2Exception;
import org.jpedal.jbig2.decoders.JBIG2StreamDecoder;
import org.jpedal.jbig2.image.JBIG2Bitmap;
import org.jpedal.jbig2.segment.pageinformation.PageInformationSegment;
import org.jpedal.jbig2.segment.region.RegionSegment;
import org.jpedal.jbig2.segment.region.refinement.RefinementRegionFlags;

public class RefinementRegionSegment
extends RegionSegment {
    private final RefinementRegionFlags refinementRegionFlags = new RefinementRegionFlags();
    private final boolean inlineImage;
    private final int noOfReferredToSegments;
    private final int[] referredToSegments;

    public RefinementRegionSegment(JBIG2StreamDecoder streamDecoder, boolean inlineImage, int[] referredToSegments, int noOfReferredToSegments) {
        super(streamDecoder);
        this.inlineImage = inlineImage;
        this.referredToSegments = referredToSegments;
        this.noOfReferredToSegments = noOfReferredToSegments;
    }

    @Override
    public void readSegment() throws IOException, JBIG2Exception {
        JBIG2Bitmap referredToBitmap;
        super.readSegment();
        this.readGenericRegionFlags();
        short[] genericRegionAdaptiveTemplateX = new short[2];
        short[] genericRegionAdaptiveTemplateY = new short[2];
        int template = this.refinementRegionFlags.getFlagValue("GR_TEMPLATE");
        if (template == 0) {
            genericRegionAdaptiveTemplateX[0] = this.readATValue();
            genericRegionAdaptiveTemplateY[0] = this.readATValue();
            genericRegionAdaptiveTemplateX[1] = this.readATValue();
            genericRegionAdaptiveTemplateY[1] = this.readATValue();
        }
        if (this.noOfReferredToSegments == 0 || this.inlineImage) {
            PageInformationSegment pageSegment = this.decoder.findPageSegment(this.segmentHeader.getPageAssociation());
            JBIG2Bitmap pageBitmap = pageSegment.getPageBitmap();
            if (pageSegment.getPageBitmapHeight() == -1 && this.regionBitmapYLocation + this.regionBitmapHeight > pageBitmap.getHeight()) {
                pageBitmap.expand(this.regionBitmapYLocation + this.regionBitmapHeight);
            }
        }
        if (this.noOfReferredToSegments > 1) {
            return;
        }
        if (this.noOfReferredToSegments == 1) {
            referredToBitmap = this.decoder.findBitmap(this.referredToSegments[0]);
        } else {
            PageInformationSegment pageSegment = this.decoder.findPageSegment(this.segmentHeader.getPageAssociation());
            JBIG2Bitmap pageBitmap = pageSegment.getPageBitmap();
            referredToBitmap = pageBitmap.getSlice(this.regionBitmapXLocation, this.regionBitmapYLocation, this.regionBitmapWidth, this.regionBitmapHeight);
        }
        this.arithmeticDecoder.resetRefinementStats(template, null);
        this.arithmeticDecoder.start();
        boolean typicalPredictionGenericRefinementOn = this.refinementRegionFlags.getFlagValue("TPGDON") != 0;
        JBIG2Bitmap bitmap = new JBIG2Bitmap(this.regionBitmapWidth, this.regionBitmapHeight, this.arithmeticDecoder, this.huffmanDecoder, this.mmrDecoder, this.decoder);
        bitmap.readGenericRefinementRegion(template, typicalPredictionGenericRefinementOn, referredToBitmap, 0, 0, genericRegionAdaptiveTemplateX, genericRegionAdaptiveTemplateY);
        if (this.inlineImage) {
            PageInformationSegment pageSegment = this.decoder.findPageSegment(this.segmentHeader.getPageAssociation());
            JBIG2Bitmap pageBitmap = pageSegment.getPageBitmap();
            int extCombOp = this.regionFlags.getFlagValue("EXTERNAL_COMBINATION_OPERATOR");
            pageBitmap.combine(bitmap, this.regionBitmapXLocation, this.regionBitmapYLocation, extCombOp);
            bitmap.getDataWriter().clearResources();
            if (this.noOfReferredToSegments != 1) {
                referredToBitmap.getDataWriter().clearResources();
            }
        } else {
            bitmap.setBitmapNumber(this.getSegmentHeader().getSegmentNumber());
            this.decoder.appendBitmap(bitmap);
        }
    }

    private void readGenericRegionFlags() {
        short refinementRegionFlagsField = this.decoder.readByte();
        this.refinementRegionFlags.setFlags(refinementRegionFlagsField);
    }

    @Override
    public JBIG2Bitmap[] getBitmaps() {
        return null;
    }
}

