/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.jbig2.image;

import org.jpedal.jbig2.JBIG2DataWriter;
import org.jpedal.jbig2.image.JBIG2Bitmap;

class BitmapPointer {
    private int x;
    private final int width;
    private final int height;
    private final int line;
    private int lineOffset;
    private final JBIG2DataWriter jBIG2DataWriter;

    BitmapPointer(JBIG2Bitmap bitmap) {
        this.height = bitmap.getHeight();
        this.width = bitmap.getWidth();
        this.line = bitmap.getLine();
        this.jBIG2DataWriter = bitmap.getDataWriter();
    }

    public void setPointer(int x, int y) {
        this.x = x;
        this.lineOffset = y < 0 || y >= this.height ? -1 : y * this.line;
    }

    public int nextPixel() {
        if (this.x >= this.width || this.lineOffset == -1) {
            return 0;
        }
        if (this.x < 0) {
            ++this.x;
            return 0;
        }
        int pixel = (this.jBIG2DataWriter.getItemAt(this.lineOffset + (this.x >> 3)) & 1 << 7 - (this.x & 7)) != 0 ? 1 : 0;
        ++this.x;
        return pixel;
    }
}

