/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.filter.ccitt;

import org.jpedal.exception.PdfException;
import org.jpedal.io.filter.ccitt.CCITT2D;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class CCITTMix
extends CCITT2D {
    private int fillBits;
    private boolean isWhite;

    public CCITTMix(byte[] rawData, int width, int height, PdfObject decodeParms) {
        super(rawData, width, height, decodeParms);
        this.data = rawData;
        this.is2D = false;
    }

    @Override
    public byte[] decode() {
        try {
            int[] prev = new int[this.width + 1];
            int[] curr = new int[this.width + 1];
            int[] currentChangeElement = new int[2];
            if (this.readEOL(true) != 1) {
                throw new PdfException("TIFFFaxDecoder3");
            }
            this.decode1DRun(curr);
            for (int lines = 1; lines < this.height; ++lines) {
                if (this.readEOL(false) == 0) {
                    int[] temp = prev;
                    prev = curr;
                    curr = temp;
                    this.set2D(prev, curr, this.changingElemSize, currentChangeElement);
                    curr[this.currIndex++] = this.bitOffset;
                    this.changingElemSize = this.currIndex;
                    continue;
                }
                this.decode1DRun(curr);
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        byte[] buffer = this.createOutputFromBitset();
        if (!this.BlackIs1) {
            for (int i = 0; i < buffer.length; ++i) {
                buffer[i] = (byte)(255 - buffer[i]);
            }
        }
        return buffer;
    }

    private void decode1DRun(int[] curr) throws Exception {
        int bitOffset = 0;
        this.isWhite = true;
        this.changingElemSize = 0;
        while (bitOffset < this.columns) {
            int bits;
            int isT;
            int entry;
            int current;
            block13: while (this.isWhite) {
                current = this.get1DBits(10);
                this.bitReached += 10;
                entry = white[current];
                isT = entry & 1;
                bits = entry >>> 1 & 0xF;
                switch (bits) {
                    case 12: {
                        bitOffset = this.handle12BitsWhenWhite(current, bitOffset);
                        continue block13;
                    }
                    case 0: 
                    case 15: {
                        throw new Exception("1Derror");
                    }
                }
                bitOffset = this.handleDefaultWhenWhite(entry, bitOffset, bits, isT, curr);
            }
            if (bitOffset == this.columns) break;
            block14: while (!this.isWhite) {
                current = this.get1DBits(4);
                entry = initBlack[current];
                this.bitReached += 4;
                bits = entry >>> 1 & 0xF;
                int code = entry >>> 5 & 0x7FF;
                switch (code) {
                    case 100: {
                        current = this.get1DBits(9);
                        this.bitReached += 9;
                        entry = black[current];
                        isT = entry & 1;
                        bits = entry >>> 1 & 0xF;
                        code = entry >>> 5 & 0x7FF;
                        switch (bits) {
                            case 12: {
                                bitOffset = this.handle12BitsWhenBlack(bitOffset);
                                continue block14;
                            }
                            case 15: {
                                throw new PdfException("1D error");
                            }
                        }
                        bitOffset = this.handleDefaultBitsWhenBlack(code, bitOffset, bits, isT, curr);
                        continue block14;
                    }
                    case 200: {
                        bitOffset = this.handleCodeIs200(bitOffset, curr);
                        continue block14;
                    }
                }
                bitOffset = this.handleDefaultCode(code, bitOffset, bits, curr);
            }
            if (bitOffset != this.columns) continue;
        }
        curr[this.changingElemSize++] = bitOffset;
    }

    private int handleDefaultCode(int code, int bitOffset1, int bits, int[] curr) {
        this.out.set(this.outPtr, this.outPtr + code, true);
        this.outPtr += code;
        this.bitReached -= 4 - bits;
        this.isWhite = true;
        curr[this.changingElemSize++] = bitOffset1 += code;
        return bitOffset1;
    }

    private int handleCodeIs200(int bitOffset1, int[] curr) {
        int current = this.get1DBits(2);
        this.bitReached += 2;
        int entry = twoBitBlack[current];
        int code = entry >>> 5 & 0x7FF;
        int bits = entry >>> 1 & 0xF;
        this.out.set(this.outPtr, this.outPtr + code, true);
        this.outPtr += code;
        this.bitReached -= 2 - bits;
        this.isWhite = true;
        curr[this.changingElemSize++] = bitOffset1 += code;
        return bitOffset1;
    }

    private int handleDefaultBitsWhenBlack(int code, int bitOffset1, int bits, int isT, int[] curr) {
        this.out.set(this.outPtr, this.outPtr + code, true);
        this.outPtr += code;
        bitOffset1 += code;
        this.bitReached -= 9 - bits;
        if (isT == 0) {
            this.isWhite = true;
            curr[this.changingElemSize++] = bitOffset1;
        }
        return bitOffset1;
    }

    private int handle12BitsWhenBlack(int bitOffset1) {
        this.bitReached -= 5;
        int current = this.get1DBits(4);
        this.bitReached += 4;
        int entry = additionalMakeup[current];
        int bits = entry >>> 1 & 7;
        int code = entry >>> 4 & 0xFFF;
        this.out.set(this.outPtr, this.outPtr + code, true);
        this.outPtr += code;
        this.bitReached -= 4 - bits;
        return bitOffset1 += code;
    }

    private int handleDefaultWhenWhite(int entry, int bitOffset1, int bits, int isT, int[] curr) {
        int code = entry >>> 5 & 0x7FF;
        bitOffset1 += code;
        this.bitReached -= 10 - bits;
        if (isT == 0) {
            this.isWhite = false;
            curr[this.changingElemSize++] = bitOffset1;
        }
        this.outPtr += code;
        return bitOffset1;
    }

    private int handle12BitsWhenWhite(int current, int bitOffset1) {
        int twoBits = this.get1DBits(2);
        this.bitReached += 2;
        current = current << 2 & 0xC | twoBits;
        int entry = additionalMakeup[current];
        int bits = entry >>> 1 & 7;
        int code = entry >>> 4 & 0xFFF;
        this.outPtr += code;
        this.bitReached -= 4 - bits;
        return bitOffset1 += code;
    }

    private int readEOL(boolean isFirstEOL) throws PdfException {
        if (this.fillBits == 0) {
            if (this.isByteAligned && this.bitReached % 8 != 0) {
                this.bitReached += 8 - this.bitReached % 8;
            }
            int next12Bits = this.get1DBits(12);
            this.bitReached += 12;
            if (isFirstEOL && next12Bits == 0) {
                int aa = this.get1DBits(4);
                this.bitReached += 4;
                if (aa == 1) {
                    this.fillBits = 1;
                    ++this.bitReached;
                    return 1;
                }
            }
            if (next12Bits != 1) {
                throw new PdfException("EOL error1");
            }
        } else if (this.fillBits == 1) {
            int bitsLeft = 8 - (this.bitReached & 7);
            int rr = this.get1DBits(bitsLeft);
            this.bitReached += bitsLeft;
            if (rr != 0) {
                throw new PdfException("EOL error2");
            }
            if (bitsLeft < 4) {
                int rr2 = this.get1DBits(8);
                this.bitReached += 8;
                if (rr2 != 0) {
                    throw new PdfException("EOL error3");
                }
            }
            int n = this.get1DBits(8);
            this.bitReached += 8;
            while (n != 1) {
                if (n != 0) {
                    throw new PdfException("EOL error4");
                }
                n = this.get1DBits(8);
                this.bitReached += 8;
            }
        }
        int r = this.get1DBits(1);
        ++this.bitReached;
        return r;
    }
}

