/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.filter.ccitt;

import org.jpedal.io.filter.ccitt.CCITT1D;
import org.jpedal.objects.raw.PdfObject;

public class CCITT2D
extends CCITT1D {
    int changingElemSize;
    boolean is2D = true;
    int bitOffset;
    int currIndex;
    static final int[] initBlack = new int[]{3226, 6412, 200, 168, 38, 38, 134, 134, 100, 100, 100, 100, 68, 68, 68, 68};
    private static final byte[] code2D = new byte[]{80, 88, 23, 71, 30, 30, 62, 62, 4, 4, 4, 4, 4, 4, 4, 4, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41};
    static final int[] black = new int[]{62, 62, 30, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 588, 588, 588, 588, 588, 588, 588, 588, 1680, 1680, 20499, 22547, 24595, 26643, 1776, 1776, 1808, 1808, -24557, -22509, -20461, -18413, 1904, 1904, 1936, 1936, -16365, -14317, 782, 782, 782, 782, 814, 814, 814, 814, -12269, -10221, 10257, 10257, 12305, 12305, 14353, 14353, 16403, 18451, 1712, 1712, 1744, 1744, 28691, 30739, -32749, -30701, -28653, -26605, 2061, 2061, 2061, 2061, 2061, 2061, 2061, 2061, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 750, 750, 750, 750, 1616, 1616, 1648, 1648, 1424, 1424, 1456, 1456, 1488, 1488, 1520, 1520, 1840, 1840, 1872, 1872, 1968, 1968, 8209, 8209, 524, 524, 524, 524, 524, 524, 524, 524, 556, 556, 556, 556, 556, 556, 556, 556, 1552, 1552, 1584, 1584, 2000, 2000, 2032, 2032, 976, 976, 1008, 1008, 1040, 1040, 1072, 1072, 1296, 1296, 1328, 1328, 718, 718, 718, 718, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 490, 490, 490, 490, 490, 490, 490, 490, 490, 490, 490, 490, 490, 490, 490, 490, 4113, 4113, 6161, 6161, 848, 848, 880, 880, 912, 912, 944, 944, 622, 622, 622, 622, 654, 654, 654, 654, 1104, 1104, 1136, 1136, 1168, 1168, 1200, 1200, 1232, 1232, 1264, 1264, 686, 686, 686, 686, 1360, 1360, 1392, 1392, 12, 12, 12, 12, 12, 12, 12, 12, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390};
    static final int[] additionalMakeup = new int[]{28679, 28679, 31752, 32777, 33801, 34825, 35849, 36873, 29703, 29703, 30727, 30727, 37897, 38921, 39945, 40969};
    static final int[] white = new int[]{6430, 6400, 6400, 6400, 3225, 3225, 3225, 3225, 944, 944, 944, 944, 976, 976, 976, 976, 1456, 1456, 1456, 1456, 1488, 1488, 1488, 1488, 718, 718, 718, 718, 718, 718, 718, 718, 750, 750, 750, 750, 750, 750, 750, 750, 1520, 1520, 1520, 1520, 1552, 1552, 1552, 1552, 428, 428, 428, 428, 428, 428, 428, 428, 428, 428, 428, 428, 428, 428, 428, 428, 654, 654, 654, 654, 654, 654, 654, 654, 1072, 1072, 1072, 1072, 1104, 1104, 1104, 1104, 1136, 1136, 1136, 1136, 1168, 1168, 1168, 1168, 1200, 1200, 1200, 1200, 1232, 1232, 1232, 1232, 622, 622, 622, 622, 622, 622, 622, 622, 1008, 1008, 1008, 1008, 1040, 1040, 1040, 1040, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 1712, 1712, 1712, 1712, 1744, 1744, 1744, 1744, 846, 846, 846, 846, 846, 846, 846, 846, 1264, 1264, 1264, 1264, 1296, 1296, 1296, 1296, 1328, 1328, 1328, 1328, 1360, 1360, 1360, 1360, 1392, 1392, 1392, 1392, 1424, 1424, 1424, 1424, 686, 686, 686, 686, 686, 686, 686, 686, 910, 910, 910, 910, 910, 910, 910, 910, 1968, 1968, 1968, 1968, 2000, 2000, 2000, 2000, 2032, 2032, 2032, 2032, 16, 16, 16, 16, 10257, 10257, 10257, 10257, 12305, 12305, 12305, 12305, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 878, 878, 878, 878, 878, 878, 878, 878, 1904, 1904, 1904, 1904, 1936, 1936, 1936, 1936, -18413, -18413, -16365, -16365, -14317, -14317, -10221, -10221, 590, 590, 590, 590, 590, 590, 590, 590, 782, 782, 782, 782, 782, 782, 782, 782, 1584, 1584, 1584, 1584, 1616, 1616, 1616, 1616, 1648, 1648, 1648, 1648, 1680, 1680, 1680, 1680, 814, 814, 814, 814, 814, 814, 814, 814, 1776, 1776, 1776, 1776, 1808, 1808, 1808, 1808, 1840, 1840, 1840, 1840, 1872, 1872, 1872, 1872, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, 14353, 14353, 14353, 14353, 16401, 16401, 16401, 16401, 22547, 22547, 24595, 24595, 20497, 20497, 20497, 20497, 18449, 18449, 18449, 18449, 26643, 26643, 28691, 28691, 30739, 30739, -32749, -32749, -30701, -30701, -28653, -28653, -26605, -26605, -24557, -24557, -22509, -22509, -20461, -20461, 8207, 8207, 8207, 8207, 8207, 8207, 8207, 8207, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 524, 524, 524, 524, 524, 524, 524, 524, 524, 524, 524, 524, 524, 524, 524, 524, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 460, 460, 460, 460, 460, 460, 460, 460, 460, 460, 460, 460, 460, 460, 460, 460, 492, 492, 492, 492, 492, 492, 492, 492, 492, 492, 492, 492, 492, 492, 492, 492, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232};
    static final int[] twoBitBlack = new int[]{292, 260, 226, 226};

    public CCITT2D(byte[] rawData, int width, int height, PdfObject DecodeParms) {
        super(rawData, width, height, DecodeParms);
    }

    CCITT2D() {
    }

    @Override
    public byte[] decode() {
        this.decode2DRun();
        byte[] output = this.createOutputFromBitset();
        if (!this.BlackIs1) {
            for (int i = 0; i < output.length; ++i) {
                output[i] = (byte)(255 - output[i]);
            }
        }
        return output;
    }

    private void decode2DRun() {
        int[] prev = new int[this.width + 1];
        int[] curr = new int[this.width + 1];
        this.changingElemSize = 2;
        curr[0] = this.width;
        curr[1] = this.width;
        int byteReached = 0;
        int[] currentChangeElement = new int[2];
        for (int lines = 0; lines < this.height; ++lines) {
            if (this.isByteAligned && this.bitReached > 0) {
                int iPart = this.bitReached % 8;
                int iDrop = 8 - iPart;
                if (iPart > 0) {
                    this.bitReached += iDrop;
                }
            }
            int[] temp = prev;
            prev = curr;
            curr = temp;
            this.set2D(prev, curr, this.changingElemSize, currentChangeElement);
            if (curr.length != this.currIndex) {
                curr[this.currIndex++] = this.bitOffset;
            }
            this.changingElemSize = this.currIndex;
            byteReached += this.scanlineStride;
        }
    }

    void set2D(int[] prev, int[] curr, int changingElemSize, int[] currentChangeElement) {
        this.isWhite = true;
        this.currIndex = 0;
        this.bitOffset = 0;
        int bits = 0;
        int a0 = -1;
        block5: while (this.bitOffset < this.width) {
            CCITT2D.getNextChangingElement(a0, this.isWhite, currentChangeElement, prev, changingElemSize);
            int bitCode = this.get1DBits(7);
            this.bitReached += 7;
            int entry = code2D[bitCode] & 0xFF;
            int code = (entry & 0x78) >>> 3;
            if (!this.is2D) {
                bits = entry & 7;
            } else if (code != 11) {
                this.updatePointer(7 - (entry & 7));
            }
            switch (code) {
                case 0: {
                    a0 = this.setA0Case0(currentChangeElement, bits);
                    continue block5;
                }
                case 1: {
                    a0 = this.setA0Case1(bits, curr);
                    continue block5;
                }
                case 11: {
                    this.handleCase11(curr);
                    continue block5;
                }
            }
            a0 = this.setA0Default(curr, currentChangeElement, code, a0, bits);
        }
    }

    private int setA0Default(int[] curr, int[] currentChangeElement, int code, int a0, int bits) {
        curr[this.currIndex++] = currentChangeElement[0] + (code - 5);
        int pixelCount = currentChangeElement[0] + (code - 5) - this.bitOffset;
        if (!this.isWhite) {
            this.out.set(this.outPtr, this.outPtr + pixelCount, true);
        }
        this.outPtr += pixelCount;
        this.bitOffset = a0 = currentChangeElement[0] + (code - 5);
        boolean bl = this.isWhite = !this.isWhite;
        if (!this.is2D) {
            this.bitReached -= 7 - bits;
        }
        return a0;
    }

    private void handleCase11(int[] curr) throws RuntimeException {
        int nextValue = this.get1DBits(3);
        this.bitReached += 3;
        if (nextValue != 7) {
            throw new RuntimeException("Unexpected value " + nextValue);
        }
        int zeroBits = 0;
        boolean isDone = false;
        while (!isDone) {
            int bitCode;
            while (true) {
                bitCode = this.get1DBits(1);
                ++this.bitReached;
                if (bitCode == 1) break;
                ++zeroBits;
            }
            if (zeroBits > 5) {
                if (!this.isWhite && (zeroBits -= 6) > 0) {
                    curr[this.currIndex++] = this.bitOffset;
                }
                this.bitOffset += zeroBits;
                if (zeroBits > 0) {
                    this.isWhite = true;
                }
                bitCode = this.get1DBits(1);
                ++this.bitReached;
                if (bitCode == 0) {
                    if (!this.isWhite) {
                        curr[this.currIndex++] = this.bitOffset;
                    }
                    this.isWhite = true;
                } else {
                    if (this.isWhite) {
                        curr[this.currIndex++] = this.bitOffset;
                    }
                    this.isWhite = false;
                }
                isDone = true;
            }
            if (zeroBits == 5) {
                if (!this.isWhite) {
                    curr[this.currIndex++] = this.bitOffset;
                }
                this.bitOffset += 5;
                this.isWhite = true;
                continue;
            }
            this.bitOffset += zeroBits;
            curr[this.currIndex++] = this.bitOffset++;
            this.out.set(this.outPtr, this.outPtr + 1, true);
            ++this.outPtr;
            this.isWhite = false;
        }
    }

    private int setA0Case1(int bits, int[] curr) {
        int pixelCount;
        if (!this.is2D) {
            this.bitReached -= 7 - bits;
        }
        if (this.isWhite) {
            pixelCount = this.getWhiteRunCodeWord();
            this.outPtr += pixelCount;
            this.bitOffset += pixelCount;
            curr[this.currIndex++] = this.bitOffset;
            pixelCount = this.getBlackRunCodeWord();
            this.out.set(this.outPtr, this.outPtr + pixelCount, true);
            this.outPtr += pixelCount;
        } else {
            pixelCount = this.getBlackRunCodeWord();
            this.out.set(this.outPtr, this.outPtr + pixelCount, true);
            this.outPtr += pixelCount;
            this.bitOffset += pixelCount;
            curr[this.currIndex++] = this.bitOffset;
            pixelCount = this.getWhiteRunCodeWord();
            this.outPtr += pixelCount;
        }
        this.bitOffset += pixelCount;
        curr[this.currIndex++] = this.bitOffset;
        int a0 = this.bitOffset;
        return a0;
    }

    private int setA0Case0(int[] currentChangeElement, int bits) {
        int pixelCount = currentChangeElement[1] - this.bitOffset;
        if (!this.isWhite) {
            this.out.set(this.outPtr, this.outPtr + pixelCount, true);
        }
        this.outPtr += pixelCount;
        this.bitOffset = currentChangeElement[1];
        int a0 = currentChangeElement[1];
        if (!this.is2D) {
            this.bitReached -= 7 - bits;
        }
        return a0;
    }

    private int getBlackRunCodeWord() {
        int length = 0;
        boolean isBlack = true;
        block8: while (isBlack) {
            int bitCode = this.get1DBits(4);
            this.bitReached += 4;
            int entry = initBlack[bitCode];
            int bits = entry >>> 1 & 0xF;
            int code = entry >>> 5 & 0x7FF;
            switch (code) {
                case 100: {
                    bitCode = this.get1DBits(9);
                    this.bitReached += 9;
                    entry = black[bitCode];
                    bits = entry >>> 1 & 0xF;
                    code = entry >>> 5 & 0x7FF;
                    switch (bits) {
                        case 12: {
                            this.updatePointer(5);
                            bitCode = this.get1DBits(4);
                            this.bitReached += 4;
                            entry = additionalMakeup[bitCode];
                            bits = entry >>> 1 & 7;
                            code = entry >>> 4 & 0xFFF;
                            length += code;
                            this.updatePointer(4 - bits);
                            continue block8;
                        }
                        case 15: {
                            throw new RuntimeException("CCITT unexpected EOL");
                        }
                    }
                    length += code;
                    this.updatePointer(9 - bits);
                    if ((entry & 1) != 0) continue block8;
                    isBlack = false;
                    continue block8;
                }
                case 200: {
                    bitCode = this.get1DBits(2);
                    this.bitReached += 2;
                    entry = twoBitBlack[bitCode];
                    code = entry >>> 5 & 0x7FF;
                    length += code;
                    bits = entry >>> 1 & 0xF;
                    this.updatePointer(2 - bits);
                    isBlack = false;
                    continue block8;
                }
            }
            length += code;
            this.updatePointer(4 - bits);
            isBlack = false;
        }
        return length;
    }

    private int getWhiteRunCodeWord() {
        int length = 0;
        boolean isWhite = true;
        block4: while (isWhite) {
            int code;
            int current = this.get1DBits(10);
            this.bitReached += 10;
            int entry = white[current];
            int bits = entry >>> 1 & 0xF;
            switch (bits) {
                case 12: {
                    int twoBits = this.get1DBits(2);
                    this.bitReached += 2;
                    current = current << 2 & 0xC | twoBits;
                    entry = additionalMakeup[current];
                    bits = entry >>> 1 & 7;
                    code = entry >>> 4 & 0xFFF;
                    length += code;
                    this.updatePointer(4 - bits);
                    continue block4;
                }
                case 0: 
                case 15: {
                    throw new RuntimeException("CCITT Error in getWhiteRunCodeWord");
                }
            }
            code = entry >>> 5 & 0x7FF;
            length += code;
            this.updatePointer(10 - bits);
            if ((entry & 1) != 0) continue;
            isWhite = false;
        }
        return length;
    }

    private static void getNextChangingElement(int a0, boolean isWhite, int[] ret, int[] prevChangingElems, int changingElemSize) {
        int i;
        int start = 0;
        if (!isWhite) {
            start |= 1;
        }
        for (i = start; i < changingElemSize; i += 2) {
            int temp = prevChangingElems[i];
            if (temp <= a0) continue;
            ret[0] = temp;
            break;
        }
        if (i + 1 < changingElemSize) {
            ret[1] = prevChangingElems[i + 1];
        }
    }

    private void updatePointer(int bitsToMoveBack) {
        this.bitReached -= bitsToMoveBack;
    }
}

